/*
 * Decompiled with CFR 0.152.
 */
package com.sun.eras.common.translator.cml;

import com.sun.eras.common.logging4.Logger;
import com.sun.eras.common.translator.TranslationException;
import com.sun.eras.common.translator.TranslatorConfig;
import com.sun.eras.common.translator.cml.CmlTranslator;
import com.sun.eras.common.translator.cml.TranslatorInitializationException;
import com.sun.eras.common.util.LocalizedString;
import com.sun.eras.common.util.MessageKey;
import com.sun.eras.common.util.MessageLocalizer;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public abstract class CmlXslTranslator
extends CmlTranslator {
    private static final Logger logger = Logger.getLogger((class$com$sun$eras$common$translator$cml$CmlXslTranslator == null ? (class$com$sun$eras$common$translator$cml$CmlXslTranslator = CmlXslTranslator.class$("com.sun.eras.common.translator.cml.CmlXslTranslator")) : class$com$sun$eras$common$translator$cml$CmlXslTranslator).getName());
    private String xslFileName = null;
    static /* synthetic */ Class class$com$sun$eras$common$translator$cml$CmlXslTranslator;
    static /* synthetic */ Class class$com$sun$eras$common$translator$TranslationException;

    protected CmlXslTranslator(String string) throws TranslatorInitializationException {
        super(string);
    }

    protected String useXslFromConfig(String string) throws TranslationException {
        String string2 = this.getXslFileName();
        return this.useXslFromFileName(string, string2);
    }

    protected String getXslFileName() throws TranslationException {
        if (this.xslFileName == null) {
            String string = this.getOutputFormat();
            TranslatorConfig translatorConfig = TranslatorConfig.getInstance();
            try {
                this.xslFileName = translatorConfig.getXslFileName("cml", string);
            }
            catch (TranslationException translationException) {
                throw new TranslationException(new MessageKey("XSLFileNameLookup"), "Could not look up xsl file name for " + string + ".  " + translationException.getLocalizedMessage(), new Object[]{string, translationException.getLocalizedMessage()}, null, null);
            }
            if (null == this.xslFileName) {
                throw new TranslationException(new MessageKey("XSLFileNotFound"), "Failed to find xsl file in config for " + string + ".  ", new Object[]{string}, null, null);
            }
        }
        return this.xslFileName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String useXslFromFileName(String string, String string2) throws TranslationException {
        if (null == string2) {
            throw new TranslationException(new MessageKey("FileNameNull"), "File Name cannot be null", null, null, null);
        }
        Reader reader = null;
        String string3 = null;
        try {
            try {
                reader = this.getXslReader(string2);
                string3 = this.useXsl(string, reader);
                if (string3 == null) {
                    throw new TranslationException(new MessageKey("useXslOutputNull"), "useXsl Output is null", null, null, null);
                }
                Object var9_5 = null;
                if (reader == null) return string3;
            }
            catch (TranslationException translationException) {
                throw translationException;
            }
            catch (Throwable throwable) {
                LocalizedString localizedString = MessageLocalizer.makeLS(class$com$sun$eras$common$translator$TranslationException == null ? (class$com$sun$eras$common$translator$TranslationException = CmlXslTranslator.class$("com.sun.eras.common.translator.TranslationException")) : class$com$sun$eras$common$translator$TranslationException, TranslationException.USEXSLFROMFILENAME, "useXslFromFileName: " + throwable.toString(), new Object[]{throwable.toString()}, null);
                throw new TranslationException(localizedString, throwable);
            }
        }
        catch (Throwable throwable) {
            Object var9_6 = null;
            if (reader == null) throw throwable;
            try {
                reader.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Throwable throwable) {}
        reader.close();
        return string3;
    }

    protected Reader getXslReader(String string) throws TranslationException {
        if (null == string) {
            throw new TranslationException(new MessageKey("FileNameNull"), "File Name cannot be null", null, null, null);
        }
        String string2 = string;
        InputStream inputStream = this.getClass().getResourceAsStream(string2);
        if (null == inputStream) {
            throw new TranslationException(new MessageKey("FileNotInClassPath"), "File Not In ClassPath " + string2, new Object[]{string2}, null, null);
        }
        return new InputStreamReader(inputStream);
    }

    protected String useXsl(String string, Reader reader) throws TranslationException {
        this.validateTranslatorSettings();
        try {
            String string2 = this.encapsulateFragmentInDocument(string);
            StringReader stringReader = new StringReader(string2);
            StringWriter stringWriter = new StringWriter();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer(new StreamSource(reader));
            transformer.transform(new StreamSource(stringReader), new StreamResult(stringWriter));
            return stringWriter.toString();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            LocalizedString localizedString = MessageLocalizer.makeLS(class$com$sun$eras$common$translator$TranslationException == null ? (class$com$sun$eras$common$translator$TranslationException = CmlXslTranslator.class$("com.sun.eras.common.translator.TranslationException")) : class$com$sun$eras$common$translator$TranslationException, TranslationException.SAXEXCEPTION, "javax.xml.transform.TransformerConfigurationException", null, null);
            throw new TranslationException(localizedString, (Throwable)transformerConfigurationException);
        }
        catch (TransformerException transformerException) {
            LocalizedString localizedString = MessageLocalizer.makeLS(class$com$sun$eras$common$translator$TranslationException == null ? (class$com$sun$eras$common$translator$TranslationException = CmlXslTranslator.class$("com.sun.eras.common.translator.TranslationException")) : class$com$sun$eras$common$translator$TranslationException, TranslationException.SAXEXCEPTION, "javax.xml.transform.TransformerException", null, null);
            throw new TranslationException(localizedString, (Throwable)transformerException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

