/*
 * Decompiled with CFR 0.152.
 */
package com.sun.eras.common.translator.cml;

import com.sun.eras.common.translator.TranslationException;
import com.sun.eras.common.translator.cml.CmlXslTranslator;
import com.sun.eras.common.translator.cml.TranslatorInitializationException;
import com.sun.eras.common.util.MessageKey;
import com.sun.eras.common.util.MessageLocalizer;

class CmlToPdfTranslator
extends CmlXslTranslator {
    public static final double MIN_MEDIA_WIDTH = 1.0;
    private double mediaWidth = 0.0;
    private String mediaWidthUnit = null;

    CmlToPdfTranslator(String string) throws TranslatorInitializationException {
        super(string);
    }

    public void setMediaWidth(double d) {
        if (d <= 0.0) {
            String string = MessageLocalizer.makeLMS(this, new MessageKey("MediaWidthMustNotBeNegative"), "Media Width Must not be negative", null, null);
            throw new IllegalArgumentException(string);
        }
        this.mediaWidth = d;
    }

    public double getMediaWidth() {
        return this.mediaWidth;
    }

    public void setMediaWidthUnit(String string) {
        this.mediaWidthUnit = string;
    }

    public String getMediaWidthUnit() {
        return this.mediaWidthUnit;
    }

    public String translate(String string) throws TranslationException {
        return this.useXslFromConfig(string);
    }

    protected void validateTranslatorSettings() throws TranslatorInitializationException {
        if (this.getMediaWidth() == 0.0) {
            throw new TranslatorInitializationException(new MessageKey("MediaWidthCannotBeZero"), "Media Width Must Cannot Be Zero", null, null, null);
        }
        if (this.getMediaWidth() < 1.0) {
            throw new TranslatorInitializationException(new MessageKey("WidthMustBeAtLeast"), "Width Must Be At Least 1.0", new Object[]{new Double(1.0)}, null, null);
        }
        if (this.getMediaWidthUnit() == null) {
            throw new TranslatorInitializationException(new MessageKey("MediaWidthUnitNull"), "Media Width Unit cannot be null", null, null, null);
        }
    }

    protected void addTextbodyAttributes(StringBuffer stringBuffer) {
        super.addTextbodyAttributes(stringBuffer);
        double d = this.getMediaWidth();
        stringBuffer.append(" mediaWidth=\"").append(d).append("\"");
        String string = this.getMediaWidthUnit();
        stringBuffer.append(" mediaWidthUnit=\"").append(string).append("\"");
    }
}

