/*
 * Decompiled with CFR 0.152.
 */
package com.sun.eras.common.translator;

import com.sun.eras.common.logging4.Logger;
import com.sun.eras.common.translator.TranslationException;
import com.sun.eras.common.util.Config;
import com.sun.eras.common.util.ConfigNotFoundException;
import com.sun.eras.common.util.MessageKey;
import com.sun.eras.common.util.MessageLocalizer;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

public class TranslatorConfig
extends Config {
    private static final Logger logger = Logger.getLogger((class$com$sun$eras$common$translator$TranslatorConfig == null ? (class$com$sun$eras$common$translator$TranslatorConfig = TranslatorConfig.class$("com.sun.eras.common.translator.TranslatorConfig")) : class$com$sun$eras$common$translator$TranslatorConfig).getName());
    public static final String BASE_CONFIG_FILE_NAME = "translator";
    public static final String PROPERTY_PREFIX = "translator";
    public static final String RESULT_PREFIX = "result";
    public static final String CML_PREFIX = "cml";
    public static final String TRANSLATOR_CLASS_PROPERTY_PREFIX = "translatorClass";
    public static final String TRANSLATOR_FACTORY_CLASS_PROPERTY = "factory.factoryClass";
    public static final String XSL_PROPERTY_PREFIX = "xsl";
    public static final String HTML_OUTPUT_FORMAT = "HTML";
    public static final String TEXT_OUTPUT_FORMAT = "TEXT";
    public static final String CSV_OUTPUT_FORMAT = "CSV";
    public static final String PDF_OUTPUT_FORMAT = "PDF";
    public static final String HTML_BODY_FORMAT = "HTML.BODY";
    public static final String HTML_TEXTAREA_FORMAT = "HTML.TEXTAREA";
    public static final String HTML_TAG_ATTRIBUTE_FORMAT = "HTML.TAGATTRIBUTE";
    private static String[][] defaultsArray = new String[][]{{"translator.result.xsl.HTML", "/com/sun/eras/common/translator/result/XmlToHtmlFailedOnly.xsl"}, {"translator.result.xsl.TEXT", "/com/sun/eras/common/translator/result/XmlToTextFailedOnlySortBySev.xsl"}, {"translator.result.xsl.CSV", "/com/sun/eras/common/translator/result/XmlToCsvFailedOnly.xsl"}, {"translator.result.translatorClass.HTML", "com.sun.eras.common.translator.result.XmlToHtmlTranslator"}, {"translator.result.translatorClass.TEXT", "com.sun.eras.common.translator.result.XmlToTextTranslator"}, {"translator.result.translatorClass.CSV", "com.sun.eras.common.translator.result.XmlToCsvTranslator"}, {"translator.cml.translatorClass.HTML.BODY", "com.sun.eras.common.translator.cml.CmlToHtmlTranslator"}, {"translator.cml.translatorClass.HTML.TEXTAREA", "com.sun.eras.common.translator.cml.CmlToHtmlTranslator"}, {"translator.cml.translatorClass.HTML.TAGATTRIBUTE", "com.sun.eras.common.translator.cml.CmlToHtmlTranslator"}, {"translator.cml.translatorClass.PDF", "com.sun.eras.common.translator.cml.CmlToPdfTranslator"}, {"translator.cml.translatorClass.TEXT", "com.sun.eras.common.translator.cml.CmlToTextTranslator"}, {"translator.cml.xsl.HTML.BODY", "/com/sun/eras/common/translator/cml/CmlToHtmlStd.xsl"}, {"translator.cml.xsl.PDF", "/com/sun/eras/common/translator/cml/CmlToFoStd.xsl"}, {"mediaWidth", "90"}, {"mediaWidthUnit", "columns"}, {"tableLeft", "\"| \""}, {"tableColSep", "\" | \""}, {"tableRight", "\" |\""}, {"tableTop", "__________"}, {"tableBottom", "___________"}, {"tableRowSep", "---------"}, {"ulBullets", "\" * \",\" + \",\" - \""}};
    private static ResourceBundle defaultsBundle = Config.makeDefaultsBundle(defaultsArray);
    private static TranslatorConfig instance = null;
    private Map cache = new HashMap();
    private String cmlTranslatedFlag = null;
    private String cmlTranslatorFormat = "TEXT";
    static /* synthetic */ Class class$com$sun$eras$common$translator$TranslatorConfig;

    private TranslatorConfig() {
        super("translator", defaultsBundle);
    }

    public static TranslatorConfig getInstance() {
        if (instance == null) {
            TranslatorConfig.makeInstance();
        }
        return instance;
    }

    private static synchronized void makeInstance() {
        if (instance == null) {
            instance = new TranslatorConfig();
        }
    }

    public String getTranslatorFactoryClassName(String string, String string2) {
        String string3 = string2;
        try {
            string3 = this.getString("translator." + string + "." + TRANSLATOR_FACTORY_CLASS_PROPERTY, null);
            if (string3 == null) {
                string3 = string2;
            }
        }
        catch (ConfigNotFoundException configNotFoundException) {
            String string4 = MessageLocalizer.makeLMS(this, new MessageKey("CMLTranslatorFactoryFailed"), "CML translator factory failed to create Config object", new Object[]{"translator", string2}, null);
            logger.info(string4);
        }
        return string3;
    }

    protected Object handleGetObject(String string) {
        if (this.cache.containsKey(string)) {
            return (String)this.cache.get(string);
        }
        Map map = this.cache;
        synchronized (map) {
            if (this.cache.containsKey(string)) {
                String string2 = (String)this.cache.get(string);
                return string2;
            }
            Object object = super.handleGetObject(string, true, null);
            this.cache.put(string, object);
            Object object2 = object;
            return object2;
        }
    }

    public String getXslFileName(String string, String string2) throws TranslationException {
        String string3 = null;
        string3 = this.getString("translator." + string + "." + XSL_PROPERTY_PREFIX + "." + string2, null);
        return string3;
    }

    public String getTranslatorClassName(String string, String string2) throws TranslationException {
        String string3 = null;
        string3 = this.getString("translator." + string + "." + TRANSLATOR_CLASS_PROPERTY_PREFIX + "." + string2, null);
        return string3;
    }

    public String getCmlTranslatedFlag() throws TranslationException {
        if (this.cmlTranslatedFlag == null) {
            this.cmlTranslatedFlag = this.getString("translator.result.cml_translated_flag", "").trim();
        }
        return this.cmlTranslatedFlag;
    }

    public void setCmlTranslatedFlag(String string) throws TranslationException {
        this.cmlTranslatedFlag = string;
    }

    public String getCmlTranslatorFormat() {
        return this.cmlTranslatorFormat;
    }

    public void setCmlTranslatorFormat(String string) {
        if (string.equalsIgnoreCase(HTML_OUTPUT_FORMAT) || string.equalsIgnoreCase(TEXT_OUTPUT_FORMAT) || string.equalsIgnoreCase(CSV_OUTPUT_FORMAT) || string.equalsIgnoreCase(PDF_OUTPUT_FORMAT)) {
            this.cmlTranslatorFormat = string.toUpperCase();
        }
    }

    public ResourceBundle getCmlTranslatorConfig() {
        return this;
    }

    public String getCmlTranslatorPrefix() {
        return "cmlTranslator";
    }

    private String getXslRootPath() {
        return this.getString("translator.xsl.root_path", "").trim();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

