/*
 * Decompiled with CFR 0.152.
 */
package com.sun.eras.common.logging4;

import com.sun.eras.common.logging4.Level;
import com.sun.eras.common.logging4.LogManager;
import com.sun.eras.common.logging4.LogRecord;
import com.sun.eras.common.logging4.StreamHandler;
import com.sun.eras.common.logging4.XMLFormatter;
import com.sun.eras.common.util.MessageKey;
import com.sun.eras.common.util.MessageLocalizer;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;

public class SocketHandler
extends StreamHandler {
    private Socket sock;
    private String host;
    private int port;
    private String portProperty;
    static /* synthetic */ Class class$com$sun$eras$common$logging4$SocketHandler;

    private void configure() {
        LogManager logManager = LogManager.getLogManager();
        String string = (class$com$sun$eras$common$logging4$SocketHandler == null ? (class$com$sun$eras$common$logging4$SocketHandler = SocketHandler.class$("com.sun.eras.common.logging4.SocketHandler")) : class$com$sun$eras$common$logging4$SocketHandler).getName();
        this.setLevel(logManager.getLevelProperty(string + ".level", Level.ALL));
        this.setFilter(logManager.getFilterProperty(string + ".filter", null));
        this.setFormatter(logManager.getFormatterProperty(string + ".formatter", new XMLFormatter()));
        try {
            this.setEncoding(logManager.getStringProperty(string + ".encoding", null));
        }
        catch (Exception exception) {
            try {
                this.setEncoding(null);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        this.port = logManager.getIntProperty(string + ".port", 0);
        this.host = logManager.getStringProperty(string + ".host", null);
    }

    public SocketHandler() throws IOException {
        this.sealed = false;
        this.configure();
        try {
            this.connect();
        }
        catch (IOException iOException) {
            System.err.println("SocketHandler: connect failed to " + this.host + ":" + this.port);
            throw iOException;
        }
        this.sealed = true;
    }

    public SocketHandler(String string, int n) throws IOException {
        this.sealed = false;
        this.configure();
        this.sealed = true;
        this.port = n;
        this.host = string;
        this.connect();
    }

    private void connect() throws IOException {
        if (this.port == 0) {
            String string = MessageLocalizer.makeLMS(this, new MessageKey("Badport"), "Bad port: " + this.port, new Object[]{new Integer(this.port)}, null);
            throw new IllegalArgumentException(string);
        }
        if (this.host == null) {
            String string = MessageLocalizer.makeLMS(this, new MessageKey("Nullhostname"), "Null host name: " + this.host, new Object[]{this.host}, null);
            throw new IllegalArgumentException(string);
        }
        this.sock = new Socket(this.host, this.port);
        OutputStream outputStream = this.sock.getOutputStream();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        this.setOutputStream(bufferedOutputStream);
    }

    public synchronized void close() throws SecurityException {
        super.close();
        if (this.sock != null) {
            try {
                this.sock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.sock = null;
    }

    public synchronized void publish(LogRecord logRecord) {
        if (!this.isLoggable(logRecord)) {
            return;
        }
        super.publish(logRecord);
        this.flush();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

