/*
 * Decompiled with CFR 0.152.
 */
package com.sun.eras.common.logging4;

import com.sun.eras.common.logging4.ErrorManager;
import com.sun.eras.common.logging4.Level;
import com.sun.eras.common.logging4.LogManager;
import com.sun.eras.common.logging4.LogRecord;
import com.sun.eras.common.logging4.StreamHandler;
import com.sun.eras.common.logging4.XMLFormatter;
import com.sun.eras.common.util.MessageKey;
import com.sun.eras.common.util.MessageLocalizer;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class FileHandler
extends StreamHandler {
    private MeteredStream meter;
    private boolean append;
    private int limit;
    private int count;
    private String pattern;
    private File[] files;
    static /* synthetic */ Class class$com$sun$eras$common$logging4$FileHandler;

    private void open(File file, boolean bl) throws IOException {
        int n = 0;
        if (bl) {
            n = (int)file.length();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file.toString(), bl);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        this.meter = new MeteredStream(bufferedOutputStream, n);
        this.setOutputStream(this.meter);
    }

    private void configure() {
        LogManager logManager = LogManager.getLogManager();
        String string = (class$com$sun$eras$common$logging4$FileHandler == null ? (class$com$sun$eras$common$logging4$FileHandler = FileHandler.class$("com.sun.eras.common.logging4.FileHandler")) : class$com$sun$eras$common$logging4$FileHandler).getName();
        this.pattern = logManager.getStringProperty(string + ".pattern", "%h/java%u.log");
        this.limit = logManager.getIntProperty(string + ".limit", 0);
        if (this.limit < 0) {
            this.limit = 0;
        }
        this.count = logManager.getIntProperty(string + ".count", 1);
        if (this.count <= 0) {
            this.count = 1;
        }
        this.append = logManager.getBooleanProperty(string + ".append", false);
        this.setLevel(logManager.getLevelProperty(string + ".level", Level.ALL));
        this.setFilter(logManager.getFilterProperty(string + ".filter", null));
        this.setFormatter(logManager.getFormatterProperty(string + ".formatter", new XMLFormatter()));
        try {
            this.setEncoding(logManager.getStringProperty(string + ".encoding", null));
        }
        catch (Exception exception) {
            try {
                this.setEncoding(null);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    public FileHandler() throws IOException, SecurityException {
        this.checkAccess();
        this.configure();
        this.openFiles();
    }

    public FileHandler(String string) throws IOException, SecurityException {
        this.checkAccess();
        this.configure();
        this.pattern = string;
        this.limit = 0;
        this.count = 1;
        this.openFiles();
    }

    public FileHandler(String string, boolean bl) throws IOException, SecurityException {
        this.checkAccess();
        this.configure();
        this.pattern = string;
        this.limit = 0;
        this.count = 1;
        this.append = bl;
        this.openFiles();
    }

    public FileHandler(String string, int n, int n2) throws IOException, SecurityException {
        if (n < 0 || n2 < 1) {
            throw new IllegalArgumentException();
        }
        this.checkAccess();
        this.configure();
        this.pattern = string;
        this.limit = n;
        this.count = n2;
        this.openFiles();
    }

    public FileHandler(String string, int n, int n2, boolean bl) throws IOException, SecurityException {
        if (n < 0 || n2 < 1) {
            throw new IllegalArgumentException();
        }
        this.checkAccess();
        this.configure();
        this.pattern = string;
        this.limit = n;
        this.count = n2;
        this.append = bl;
        this.openFiles();
    }

    private void openFiles() throws IOException {
        LogManager logManager = LogManager.getLogManager();
        logManager.checkAccess();
        if (this.count < 1) {
            String string = MessageLocalizer.makeLMS(this, new MessageKey("filecount"), "file count = " + this.count, new Object[]{new Integer(this.count)}, null);
            throw new IllegalArgumentException(string);
        }
        if (this.limit < 0) {
            this.limit = 0;
        }
        InitializationErrorManager initializationErrorManager = new InitializationErrorManager();
        this.setErrorManager(initializationErrorManager);
        int n = 0;
        this.files = new File[this.count];
        int n2 = 0;
        while (n2 < this.count) {
            this.files[n2] = this.generate(this.pattern, n2, n);
            ++n2;
        }
        if (this.append) {
            this.open(this.files[0], true);
        } else {
            this.rotate();
        }
        Exception exception = initializationErrorManager.lastException;
        if (exception != null) {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof SecurityException) {
                throw (SecurityException)exception;
            }
            String string = MessageLocalizer.makeLMS(this, new MessageKey("Exception"), "Exception: " + exception, new Object[]{exception}, null);
            throw new IOException(string);
        }
        this.setErrorManager(new ErrorManager());
    }

    private File generate(String string, int n, int n2) throws IOException {
        File file = null;
        String string2 = "";
        int n3 = 0;
        boolean bl = false;
        boolean bl2 = false;
        while (n3 < string.length()) {
            char c = string.charAt(n3);
            char c2 = '\u0000';
            if (++n3 < string.length()) {
                c2 = Character.toLowerCase(string.charAt(n3));
            }
            if (c == '/') {
                file = file == null ? new File(string2) : new File(file, string2);
                string2 = "";
                continue;
            }
            if (c == '%') {
                if (c2 == 't') {
                    String string3 = System.getProperty("java.io.tmpdir");
                    if (string3 == null) {
                        string3 = System.getProperty("user.home");
                    }
                    file = new File(string3);
                    ++n3;
                    string2 = "";
                    continue;
                }
                if (c2 == 'h') {
                    file = new File(System.getProperty("user.home"));
                    ++n3;
                    string2 = "";
                    continue;
                }
                if (c2 == 'g') {
                    string2 = string2 + n;
                    bl = true;
                    ++n3;
                    continue;
                }
                if (c2 == 'u') {
                    string2 = string2 + n2;
                    bl2 = true;
                    ++n3;
                    continue;
                }
                if (c2 == '%') {
                    string2 = string2 + "%";
                    ++n3;
                    continue;
                }
            }
            string2 = string2 + c;
        }
        if (this.count > 1 && !bl) {
            string2 = string2 + "." + n;
        }
        if (n2 > 0 && !bl2) {
            string2 = string2 + "." + n2;
        }
        if (string2.length() > 0) {
            file = file == null ? new File(string2) : new File(file, string2);
        }
        return file;
    }

    private synchronized void rotate() {
        Level level = this.getLevel();
        this.setLevel(Level.OFF);
        super.close();
        int n = this.count - 2;
        while (n >= 0) {
            File file = this.files[n];
            File file2 = this.files[n + 1];
            if (file.exists()) {
                if (file2.exists()) {
                    file2.delete();
                }
                file.renameTo(file2);
            }
            --n;
        }
        try {
            this.open(this.files[0], false);
        }
        catch (IOException iOException) {
            this.reportError(null, iOException, 4);
        }
        this.setLevel(level);
    }

    public synchronized void publish(LogRecord logRecord) {
        if (!this.isLoggable(logRecord)) {
            return;
        }
        super.publish(logRecord);
        this.flush();
        if (this.limit > 0 && this.meter.written >= this.limit) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    FileHandler.this.rotate();
                    return null;
                }
            });
        }
    }

    public synchronized void close() throws SecurityException {
        super.close();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class InitializationErrorManager
    extends ErrorManager {
        Exception lastException;

        private InitializationErrorManager() {
        }

        public void error(String string, Exception exception, int n) {
            this.lastException = exception;
        }
    }

    private class MeteredStream
    extends OutputStream {
        OutputStream out;
        int written;

        MeteredStream(OutputStream outputStream, int n) {
            this.out = outputStream;
            this.written = n;
        }

        public void write(int n) throws IOException {
            this.out.write(n);
            ++this.written;
        }

        public void write(byte[] byArray) throws IOException {
            this.out.write(byArray);
            this.written += byArray.length;
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.out.write(byArray, n, n2);
            this.written += n2;
        }

        public void flush() throws IOException {
            this.out.flush();
        }

        public void close() throws IOException {
            this.out.close();
        }
    }
}

