/*
 * Decompiled with CFR 0.152.
 */
package com.sun.eras.common.kaeresult;

import com.sun.eras.common.checks.CheckSeverity;
import com.sun.eras.common.kaeresult.CheckResults;
import com.sun.eras.common.kaeresult.KAEResultConversionException;
import com.sun.eras.common.kaeresult.ProductInfoBean;
import com.sun.eras.common.kaeresult.RawCml;
import com.sun.eras.common.logging4.Logger;
import com.sun.eras.common.util.LocalizedString;
import com.sun.eras.common.util.MessageKey;
import com.sun.eras.common.util.MessageLocalizer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class CheckResultsBean
implements CheckResults,
Cloneable,
Serializable {
    static final long serialVersionUID = -2616100654088512763L;
    private static final Logger logger = Logger.getLogger((class$com$sun$eras$common$kaeresult$CheckResultsBean == null ? (class$com$sun$eras$common$kaeresult$CheckResultsBean = CheckResultsBean.class$("com.sun.eras.common.kaeresult.CheckResultsBean")) : class$com$sun$eras$common$kaeresult$CheckResultsBean).getName());
    public static final String STATUS_UNKNOWN = "UNKNOWN";
    private String checkId = null;
    private int checkRevisionNumber = -1;
    private String description = null;
    private List productCategories = null;
    private List products = null;
    private String status = null;
    private CheckSeverity severity = null;
    private boolean applicabilityOnly = false;
    private boolean applicable = false;
    private boolean conditionPasses = false;
    private RawCml analysisCml = null;
    private RawCml recommendationsCml = null;
    private String comment = null;
    private String errorMessage = null;
    private Exception exception = null;
    private boolean errored = false;
    private String execution = null;
    static /* synthetic */ Class class$com$sun$eras$common$kaeresult$CheckResultsBean;
    static /* synthetic */ Class class$com$sun$eras$common$kaeresult$KAEResultConversionException;

    protected CheckResultsBean(String string, int n) {
        this.checkId = string;
        this.checkRevisionNumber = n;
    }

    CheckResultsBean() {
        this(null, -1);
    }

    public CheckResultsBean(CheckResults checkResults) {
        this(checkResults.getCheckId(), checkResults.getCheckRevisionNumber());
        this.status = checkResults.getStatus();
        this.errored = checkResults.isErrored();
        this.exception = checkResults.getException();
        this.errorMessage = checkResults.getErrorMessage();
        this.severity = checkResults.getSeverity();
        this.applicabilityOnly = checkResults.isApplicabilityOnly();
        this.applicable = checkResults.isApplicable();
        this.conditionPasses = checkResults.isConditionPasses();
        this.analysisCml = checkResults.getAnalysisCml();
        this.recommendationsCml = checkResults.getRecommendationsCml();
        this.comment = checkResults.getComment();
        this.description = checkResults.getDescription();
        if (checkResults.getProductCategories() != null && checkResults.getProductCategories().size() > 0) {
            this.productCategories = new ArrayList();
            this.productCategories.addAll(checkResults.getProductCategories());
        }
        if (checkResults.getProducts() != null && checkResults.getProducts().size() > 0) {
            this.products = new ArrayList();
            this.products.addAll(checkResults.getProducts());
        }
    }

    public String getCheckId() {
        return this.checkId;
    }

    void setCheckId(String string) {
        if (this.checkId != null) {
            String string2 = MessageLocalizer.makeLMS(this, new MessageKey("Idcanbesetonlyonce"), "Id can be set only once", null, null);
            throw new IllegalStateException(string2);
        }
        this.checkId = string;
    }

    public int getCheckRevisionNumber() {
        return this.checkRevisionNumber;
    }

    void setCheckRevisionNumber(int n) {
        if (this.checkRevisionNumber != -1) {
            String string = MessageLocalizer.makeLMS(this, new MessageKey("Revisioncanbesetonlyonce"), "Revision can be set only once", null, null);
            throw new IllegalStateException(string);
        }
        this.checkRevisionNumber = n;
    }

    public String getDescription() {
        return this.description;
    }

    protected void setDescription(String string) {
        this.description = string;
    }

    public List getProductCategories() {
        return this.productCategories;
    }

    protected void setProductCategories(List list) {
        this.productCategories = list;
    }

    public List getProducts() {
        return this.products;
    }

    protected void setProducts(List list) {
        this.products = list;
    }

    public String getStatus() {
        return this.status;
    }

    protected void setStatus(String string) {
        this.status = string;
    }

    public void setErrored(boolean bl) {
        this.errored = bl;
    }

    public boolean isErrored() {
        return this.errored;
    }

    public CheckSeverity getSeverity() {
        return this.severity;
    }

    protected void setSeverity(CheckSeverity checkSeverity) {
        this.severity = checkSeverity;
    }

    public boolean isApplicabilityOnly() {
        return this.applicabilityOnly;
    }

    protected void setApplicabilityOnly(boolean bl) {
        this.applicabilityOnly = bl;
    }

    public boolean isApplicable() {
        return this.applicable;
    }

    protected void setApplicable(boolean bl) {
        this.applicable = bl;
    }

    public boolean isConditionPasses() {
        return this.conditionPasses;
    }

    protected void setConditionPasses(boolean bl) {
        this.conditionPasses = bl;
    }

    public RawCml getAnalysisCml() {
        return this.analysisCml;
    }

    public void setAnalysisCml(RawCml rawCml) {
        this.analysisCml = rawCml;
    }

    public RawCml getRecommendationsCml() {
        return this.recommendationsCml;
    }

    public void setRecommendationsCml(RawCml rawCml) {
        this.recommendationsCml = rawCml;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public Exception getException() {
        return this.exception;
    }

    protected void setException(Exception exception) {
        this.exception = exception;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    protected void setErrorMessage(String string) {
        this.errorMessage = string;
    }

    public void setExecution(String string) {
        this.execution = string;
    }

    public String getExecution() {
        return this.execution;
    }

    static String truncateString(String string) {
        if (string == null) {
            return "null";
        }
        if (string.length() > 40) {
            string = string.substring(0, 40);
        }
        return "\"" + string.replace('\n', ' ') + "\"";
    }

    static String truncateString(RawCml rawCml) {
        if (rawCml == null) {
            return "null";
        }
        return CheckResultsBean.truncateString(rawCml.getAsString());
    }

    protected StringBuffer toStringBody(StringBuffer stringBuffer) {
        Object object;
        Object object2;
        stringBuffer.append("status=").append(this.getStatus()).append(",");
        stringBuffer.append("errored=").append(this.isErrored()).append(",");
        stringBuffer.append("applicabilityOnly=").append(this.isApplicabilityOnly()).append(",");
        stringBuffer.append("applicable=").append(this.isApplicable()).append(",");
        stringBuffer.append("conditionPasses=").append(this.isConditionPasses()).append(",");
        stringBuffer.append("severity=").append(this.getSeverity()).append(",");
        stringBuffer.append("analysisCml=");
        RawCml rawCml = this.getAnalysisCml();
        stringBuffer.append(CheckResultsBean.truncateString(rawCml));
        stringBuffer.append(",");
        stringBuffer.append("recommendationsCml=");
        rawCml = this.getRecommendationsCml();
        stringBuffer.append(CheckResultsBean.truncateString(rawCml));
        stringBuffer.append(",");
        List list = this.getProductCategories();
        if (list != null && list.size() > 0) {
            object2 = list.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                stringBuffer.append("product_category=" + (String)object + ",");
            }
        }
        if ((object2 = this.getProducts()) != null && object2.size() > 0) {
            object = object2.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                stringBuffer.append("product=" + string + ",");
            }
        }
        stringBuffer.append("comment=").append(this.getComment()).append(",");
        stringBuffer.append("exception=").append(this.getException()).append(",");
        stringBuffer.append("errorMessage=").append(this.getErrorMessage());
        return stringBuffer;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("CheckResultsBean[");
        stringBuffer.append("checkId=").append(this.checkId).append(",");
        stringBuffer.append("checkRevisionNumber=").append(this.checkRevisionNumber).append(",");
        this.toStringBody(stringBuffer);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public final String toXML() throws KAEResultConversionException {
        return this.toXML(new StringBuffer(128)).toString();
    }

    public final StringBuffer toXML(StringBuffer stringBuffer) throws KAEResultConversionException {
        this.toXML("", stringBuffer);
        return stringBuffer;
    }

    public final boolean toXML(OutputStream outputStream) throws KAEResultConversionException {
        try {
            outputStream.write(this.toXML().getBytes());
            return true;
        }
        catch (IOException iOException) {
            logger.throwing(this.getClass().getName(), "toXML(OutputStream) failed", iOException);
            LocalizedString localizedString = MessageLocalizer.makeLS(class$com$sun$eras$common$kaeresult$KAEResultConversionException == null ? (class$com$sun$eras$common$kaeresult$KAEResultConversionException = CheckResultsBean.class$("com.sun.eras.common.kaeresult.KAEResultConversionException")) : class$com$sun$eras$common$kaeresult$KAEResultConversionException, KAEResultConversionException.TOXMLOUTPUTSTREAMFAILED, "toXML(OutputStream) failed", null, null);
            throw new KAEResultConversionException(localizedString, (Throwable)iOException);
        }
    }

    public final StringBuffer toXML(String string, StringBuffer stringBuffer) throws KAEResultConversionException {
        Object object;
        Object object2;
        List list;
        if (stringBuffer == null) {
            LocalizedString localizedString = MessageLocalizer.makeLS(class$com$sun$eras$common$kaeresult$KAEResultConversionException == null ? (class$com$sun$eras$common$kaeresult$KAEResultConversionException = CheckResultsBean.class$("com.sun.eras.common.kaeresult.KAEResultConversionException")) : class$com$sun$eras$common$kaeresult$KAEResultConversionException, KAEResultConversionException.NULLSTRINGBUFFER, "null StringBuffer", null, null);
            KAEResultConversionException kAEResultConversionException = new KAEResultConversionException(localizedString);
            logger.throwing(this.getClass().getName(), "toXML(String, StringBuffer)", kAEResultConversionException);
            throw kAEResultConversionException;
        }
        stringBuffer.append(string + "<checkresult status=\"" + this.getStatus() + "\" severity=\"" + this.getSeverity().stringValue() + "\">\n");
        stringBuffer.append(string + "\t" + "<check_id>\n");
        stringBuffer.append(string + "\t\t" + "<id>" + this.getCheckId() + "</id>\n");
        stringBuffer.append(string + "\t" + "</check_id>\n");
        stringBuffer.append(string + "\t" + "<check_revision>" + this.getCheckRevisionNumber() + "</check_revision>\n");
        stringBuffer.append(string + "\t" + "<description><![CDATA[" + this.getDescription() + "]]></description>\n");
        if (this.getAnalysisCml() != null) {
            stringBuffer.append(string + "\t" + "<analysis><![CDATA[" + this.getAnalysisCml().getAsString() + "]]></analysis>\n");
        }
        if (this.getRecommendationsCml() != null) {
            stringBuffer.append(string + "\t" + "<recommendations><![CDATA[" + this.getRecommendationsCml().getAsString() + "]]></recommendations>\n");
        }
        if ((list = this.getProductCategories()) != null && list.size() > 0) {
            object2 = list.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                stringBuffer.append(string + "\t" + "<product_category>" + (String)object + "</product_category>\n");
            }
        }
        if ((object2 = this.getProducts()) != null && object2.size() > 0) {
            object = object2.iterator();
            while (object.hasNext()) {
                ProductInfoBean productInfoBean = (ProductInfoBean)object.next();
                productInfoBean.toXML(string + "\t", stringBuffer);
            }
        }
        if (this.comment != null) {
            stringBuffer.append(string + "\t" + "<comment>" + this.getComment() + "</comment>\n");
        }
        stringBuffer.append(string + "</checkresult>\n");
        return stringBuffer;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

