/*
 * Decompiled with CFR 0.152.
 */
package com.sun.eras.common.checkstorage;

import com.sun.eras.common.util.MessageKey;
import com.sun.eras.common.util.MessageLocalizer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlUtilities {
    public static final String EMPTY_STRING = "";
    private boolean actingLikeExportToXml = false;
    private String indentString = "  ";

    public void setActingLikeExportToXml(boolean bl) {
        this.actingLikeExportToXml = bl;
    }

    public boolean isActingLikeExportToXml() {
        return this.actingLikeExportToXml;
    }

    public void setIndentString(String string) {
        this.indentString = string;
    }

    public String getIndentString() {
        return this.indentString;
    }

    public Date stringToDate(String string) {
        try {
            return new Date(Long.parseLong(string));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public Element getChild(Element element, String string) {
        List list = XmlUtilities.getChildren(element, string);
        if (list == null || list.size() == 0) {
            return null;
        }
        if (list.size() > 1) {
            String string2 = MessageLocalizer.makeLMS(this, new MessageKey("Morethanonechildnodeforinacontextwhereoneisexpected"), "More than one child node for " + string + " in a context where one is expected.", new Object[]{string}, null);
            throw new IllegalArgumentException(string2);
        }
        return (Element)list.get(0);
    }

    public String getChildText(Element element, String string) {
        Element element2 = this.getChild(element, string);
        if (element2 != null) {
            return element2.getNodeValue();
        }
        return null;
    }

    public String getChildTextTrim(Element element, String string) {
        Element element2 = this.getChild(element, string);
        if (element2 != null) {
            return element2.getNodeValue().trim();
        }
        return null;
    }

    public List getChildrenText(Element element, String string) {
        List list = XmlUtilities.getChildren(element, string);
        if (list == null || list.size() == 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            if (element2 == null) continue;
            arrayList.add(element2.getNodeValue());
        }
        return arrayList;
    }

    public String makeCdata(String string) {
        if (string == null) {
            return string;
        }
        if (string.trim().equals(EMPTY_STRING)) {
            return string;
        }
        return "<![CDATA[" + string + "]]>";
    }

    public String notNull(String string) {
        return string == null || string.equals(EMPTY_STRING) ? EMPTY_STRING : string;
    }

    public Date notNull(Date date) {
        return date == null ? new Date() : date;
    }

    public StringBuffer appendOpenForAttributes(StringBuffer stringBuffer, int n, String string) {
        if (this.actingLikeExportToXml && n == 3) {
            stringBuffer.append("\t");
        } else if (!this.actingLikeExportToXml) {
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append(this.indentString);
                ++n2;
            }
        }
        stringBuffer.append("<");
        stringBuffer.append(string);
        return stringBuffer;
    }

    public StringBuffer appendOpen(StringBuffer stringBuffer, int n, String string) {
        return this.appendOpenForAttributes(stringBuffer, n, string).append(">");
    }

    public StringBuffer appendOpen(StringBuffer stringBuffer, int n, String string, int n2) {
        this.appendOpen(stringBuffer, n, string);
        int n3 = 0;
        while (n3 < n2) {
            stringBuffer.append("\n");
            ++n3;
        }
        return stringBuffer;
    }

    public StringBuffer appendClose(StringBuffer stringBuffer, int n, String string, int n2) {
        int n3;
        if (!this.actingLikeExportToXml) {
            n3 = 0;
            while (n3 < n) {
                stringBuffer.append(this.indentString);
                ++n3;
            }
        }
        stringBuffer.append("</").append(string).append(">");
        n3 = 0;
        while (n3 < n2) {
            stringBuffer.append("\n");
            ++n3;
        }
        return stringBuffer;
    }

    public StringBuffer appendClause(StringBuffer stringBuffer, int n, String string, String string2, int n2) {
        if (string2 == null) {
            return stringBuffer;
        }
        this.appendOpen(stringBuffer, n, string);
        stringBuffer.append(string2);
        this.appendClose(stringBuffer, 0, string, n2);
        return stringBuffer;
    }

    public StringBuffer appendClause(StringBuffer stringBuffer, int n, String string, String string2) {
        return this.appendClause(stringBuffer, n, string, string2, 1);
    }

    public StringBuffer appendClause(StringBuffer stringBuffer, String string, String string2, int n) {
        return this.appendClause(stringBuffer, 1, string, string2, n);
    }

    public StringBuffer appendClause(StringBuffer stringBuffer, String string, String string2) {
        return this.appendClause(stringBuffer, 1, string, string2, 1);
    }

    public StringBuffer appendClause(StringBuffer stringBuffer, int n, String string, Date date, int n2) {
        if (date == null) {
            return stringBuffer;
        }
        this.appendOpenForAttributes(stringBuffer, n, string);
        if (date != null && !this.actingLikeExportToXml) {
            stringBuffer.append(" GMT='").append(date).append("'");
        }
        stringBuffer.append(">");
        if (date != null) {
            stringBuffer.append(date.getTime());
        }
        this.appendClose(stringBuffer, 0, string, n2);
        return stringBuffer;
    }

    public StringBuffer appendClause(StringBuffer stringBuffer, String string, Date date, int n) {
        return this.appendClause(stringBuffer, 1, string, date, n);
    }

    public StringBuffer appendClause(StringBuffer stringBuffer, int n, String string, Date date) {
        return this.appendClause(stringBuffer, n, string, date, 1);
    }

    public StringBuffer appendClause(StringBuffer stringBuffer, String string, Date date) {
        return this.appendClause(stringBuffer, 1, string, date, 1);
    }

    public static List getChildren(Element element, String string) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            if (nodeList.item(n).getNodeName().equals(string)) {
                arrayList.add(nodeList.item(n));
            }
            ++n;
        }
        return arrayList;
    }
}

