/*
 * Decompiled with CFR 0.152.
 */
package com.sun.eras.common.checkstorage;

import com.sun.eras.common.checks.Check;
import com.sun.eras.common.checks.CheckIterator;
import com.sun.eras.common.checks.CheckKeyword;
import com.sun.eras.common.checks.CheckList;
import com.sun.eras.common.checks.CheckNote;
import com.sun.eras.common.checks.CheckParam;
import com.sun.eras.common.checks.CheckProduct;
import com.sun.eras.common.checks.CheckRefdoc;
import com.sun.eras.common.checks.CheckReportSection;
import com.sun.eras.common.checks.CheckSeverity;
import com.sun.eras.common.checks.CheckSwordfishProduct;
import com.sun.eras.common.checks.filters.CheckFilter;
import com.sun.eras.common.checkstorage.CheckStorageConnection;
import com.sun.eras.common.checkstorage.CheckStorageCrcException;
import com.sun.eras.common.checkstorage.CheckStorageException;
import com.sun.eras.common.checkstorage.CheckStorageExpiredException;
import com.sun.eras.common.checkstorage.CheckStorageIOException;
import com.sun.eras.common.checkstorage.CheckStorageIllegalDtdException;
import com.sun.eras.common.checkstorage.CheckStorageSecurityCredentials;
import com.sun.eras.common.checkstorage.InsecureCheckStorageAdapter;
import com.sun.eras.common.checkstorage.ReadChecklistFromXml;
import com.sun.eras.common.checkstorage.XmlUtilities;
import com.sun.eras.common.logging4.Logger;
import com.sun.eras.common.util.CRCFactory;
import com.sun.eras.common.util.DateUtil;
import com.sun.eras.common.util.EntityResolverHelper;
import com.sun.eras.common.util.LocalizedString;
import com.sun.eras.common.util.MessageKey;
import com.sun.eras.common.util.MessageLocalizer;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.Writer;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;

public class XmlCheckStorage
extends InsecureCheckStorageAdapter {
    protected static final Logger logger = Logger.getLogger((class$com$sun$eras$common$checkstorage$XmlCheckStorage == null ? (class$com$sun$eras$common$checkstorage$XmlCheckStorage = XmlCheckStorage.class$("com.sun.eras.common.checkstorage.XmlCheckStorage")) : class$com$sun$eras$common$checkstorage$XmlCheckStorage).getName());
    public static final String ChecklistDTDURL = "Entity-Resolver-Required:eras-common.jar!checklist.dtd";
    public static final String ChecklistDTDPublicId = "-//Sun Microsystems, Inc.//DTD eRAS Checklist 1.0//EN";
    public static final String ChecklistDTDResourcePath = "/com/sun/eras/common/checks/checklist.dtd";
    public static boolean CHECKLIST_CDATA;
    private static final String DEFAULT_DOCTYPE = "Entity-Resolver-Required:eras-common.jar!checklist.dtd";
    private static final boolean DEFAULT_CDATA;
    private static final boolean DEFAULT_VALIDATING = false;
    private static final boolean DEFAULT_VALIDATE_EXPIRATION_DATE = true;
    private static final boolean DEFAULT_VALIDATE_CRC = true;
    private String fileName = null;
    private InputStream inputStream = null;
    private boolean inputStreamRead = false;
    private boolean validating = false;
    private String doctype = "Entity-Resolver-Required:eras-common.jar!checklist.dtd";
    private boolean cdata = DEFAULT_CDATA;
    private boolean allowGenerationWithBadDtd = false;
    private XmlUtilities xu = new XmlUtilities();
    private boolean actingLikeExportToXml = false;
    private int daysToExpire = 14;
    private Date generationDate = null;
    private Date expirationDate = null;
    private boolean validateExpirationDate = true;
    private String givenCRC = null;
    private String computedCRC = null;
    private boolean validateCRC = true;
    private EntityResolverHelper entityHelper = null;
    static /* synthetic */ Class class$com$sun$eras$common$checkstorage$XmlCheckStorage;
    static /* synthetic */ Class class$com$sun$eras$common$checkstorage$CheckStorageIOException;
    static /* synthetic */ Class class$com$sun$eras$common$checkstorage$CheckStorageExpiredException;
    static /* synthetic */ Class class$com$sun$eras$common$checkstorage$CheckStorageCrcException;

    XmlCheckStorage(InputStream inputStream, String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        this.inputStream = inputStream;
        this.fileName = string;
        if (string2 != null) {
            this.doctype = string2;
        }
        this.validating = bl;
        this.validateExpirationDate = bl2;
        this.validateCRC = bl3;
    }

    public XmlCheckStorage(InputStream inputStream, String string, boolean bl) {
        this(inputStream, null, string, bl, true, true);
    }

    XmlCheckStorage(ByteArrayInputStream byteArrayInputStream, String string, boolean bl, boolean bl2, boolean bl3) {
        this(byteArrayInputStream, null, string, bl, bl2, bl3);
    }

    public XmlCheckStorage(InputStream inputStream, String string) {
        this(inputStream, string, false);
    }

    public XmlCheckStorage(InputStream inputStream, boolean bl) {
        this(inputStream, "Entity-Resolver-Required:eras-common.jar!checklist.dtd", bl);
    }

    public XmlCheckStorage(InputStream inputStream) {
        this(inputStream, "Entity-Resolver-Required:eras-common.jar!checklist.dtd", false);
    }

    public XmlCheckStorage(String string, String string2, boolean bl) {
        this(null, string, string2, bl, true, true);
    }

    public XmlCheckStorage(String string, String string2) {
        this(string, string2, false);
    }

    public XmlCheckStorage(String string, boolean bl) {
        this(string, "Entity-Resolver-Required:eras-common.jar!checklist.dtd", bl);
    }

    public XmlCheckStorage(String string) {
        this(string, "Entity-Resolver-Required:eras-common.jar!checklist.dtd", false);
    }

    public XmlCheckStorage() {
        this((String)null, "Entity-Resolver-Required:eras-common.jar!checklist.dtd", false);
    }

    void setActingLikeExportToXml(boolean bl) {
        this.actingLikeExportToXml = bl;
        this.xu.setActingLikeExportToXml(bl);
    }

    boolean isActingLikeExportToXml() {
        return this.actingLikeExportToXml;
    }

    public void setDaysToExpire(int n) {
        this.daysToExpire = n;
    }

    public int getDaysToExpire() {
        return this.daysToExpire;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public void setCdata(boolean bl) {
        this.cdata = bl;
    }

    void setAllowGenerationWithBadDtd(boolean bl) {
        this.allowGenerationWithBadDtd = bl;
    }

    public Date getGenerationDate() {
        return this.generationDate;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    void setEntityResolver(EntityResolverHelper entityResolverHelper) {
        this.entityHelper = entityResolverHelper;
        logger.fine("setEntityResolver(" + this.entityHelper + ")");
    }

    public CheckList getChecks() throws CheckStorageException {
        logger.fine("XmlCheckStorage.getChecks with no parameters");
        return this.readChecks();
    }

    public CheckList getChecks(CheckFilter checkFilter) throws CheckStorageException {
        logger.fine("XmlCheckStorage.getChecks with one parameter");
        return new CheckList(this.readChecks(), checkFilter);
    }

    public void storeChecks(CheckList checkList) throws CheckStorageException {
        if (this.fileName == null) {
            String string = MessageLocalizer.makeLMS(this, new MessageKey("XmlCheckStoragewasconstructedwithastreamsowecantwrite"), "XmlCheckStorage was constructed with a stream so we can't write.", null, null);
            throw new UnsupportedOperationException(string);
        }
        String string = this.fileName + ".new";
        boolean bl = true;
        this.storeChecks(checkList, bl, string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected CheckList readChecks() throws CheckStorageException {
        IOException iOException4;
        CheckList checkList;
        InputStream inputStream;
        block19: {
            if (this.inputStream == null) {
                try {
                    inputStream = new FileInputStream(this.fileName);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    LocalizedString localizedString = MessageLocalizer.makeLS(class$com$sun$eras$common$checkstorage$CheckStorageIOException == null ? (class$com$sun$eras$common$checkstorage$CheckStorageIOException = XmlCheckStorage.class$("com.sun.eras.common.checkstorage.CheckStorageIOException")) : class$com$sun$eras$common$checkstorage$CheckStorageIOException, CheckStorageIOException.FOR, "For " + this.fileName, new Object[]{this.fileName}, null);
                    throw new CheckStorageIOException(localizedString, (Throwable)fileNotFoundException);
                }
            } else {
                if (this.inputStreamRead) {
                    String string = MessageLocalizer.makeLMS(this, new MessageKey("Inputstreamcanonlybereadonce"), "Input stream can only be read once.", null, null);
                    throw new UnsupportedOperationException(string);
                }
                inputStream = this.inputStream;
                this.inputStreamRead = true;
            }
            boolean bl = false;
            Writer writer = null;
            try {
                ReadChecklistFromXml readChecklistFromXml = new ReadChecklistFromXml(inputStream, this.validating, this.entityHelper, bl, writer);
                CheckList checkList2 = readChecklistFromXml.getCheckList();
                this.expirationDate = readChecklistFromXml.getExpirationDate();
                this.generationDate = readChecklistFromXml.getGenerationDate();
                this.givenCRC = readChecklistFromXml.getGivenCRC();
                this.computedCRC = readChecklistFromXml.getComputedCRC();
                Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                long l = this.expirationDate.getTime() - calendar.getTime().getTime();
                this.daysToExpire = (int)(l / 86400000L);
                logger.fine("XmlCheckStorage : daysToExpire = " + this.daysToExpire);
                if (this.validateCRC) {
                    this.validateCRC();
                }
                if (this.validateExpirationDate) {
                    this.validateExpirationDate();
                }
                if (writer != null) {
                    try {
                        writer.flush();
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                }
                checkList = checkList2;
                Object var11_13 = null;
                if (writer == null) break block19;
            }
            catch (Throwable throwable) {
                IOException iOException32;
                Object var11_14 = null;
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException32) {
                        // empty catch block
                    }
                }
                if (this.inputStream != null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException32) {}
                throw throwable;
            }
            try {
                writer.close();
            }
            catch (IOException iOException4) {
                // empty catch block
            }
        }
        if (this.inputStream != null) return checkList;
        try {
            inputStream.close();
            return checkList;
        }
        catch (IOException iOException4) {
            // empty catch block
        }
        return checkList;
    }

    public void validateExpirationDate() throws CheckStorageException {
        if (this.expirationDate != null && this.expirationDate.before(new Date())) {
            LocalizedString localizedString = MessageLocalizer.makeLS(class$com$sun$eras$common$checkstorage$CheckStorageExpiredException == null ? (class$com$sun$eras$common$checkstorage$CheckStorageExpiredException = XmlCheckStorage.class$("com.sun.eras.common.checkstorage.CheckStorageExpiredException")) : class$com$sun$eras$common$checkstorage$CheckStorageExpiredException, CheckStorageExpiredException.EXPIREDCHECKLIST, "Expired checklist: " + this.expirationDate, new Object[]{this.expirationDate}, null);
            throw new CheckStorageExpiredException(localizedString);
        }
    }

    public void validateCRC() throws CheckStorageException {
        if (this.computedCRC != null && !this.computedCRC.equals(this.givenCRC)) {
            LocalizedString localizedString = MessageLocalizer.makeLS(class$com$sun$eras$common$checkstorage$CheckStorageCrcException == null ? (class$com$sun$eras$common$checkstorage$CheckStorageCrcException = XmlCheckStorage.class$("com.sun.eras.common.checkstorage.CheckStorageCrcException")) : class$com$sun$eras$common$checkstorage$CheckStorageCrcException, CheckStorageCrcException.CRCINVALID, "CRC invalid.", null, null);
            throw new CheckStorageCrcException(localizedString);
        }
    }

    public void storeChecks(CheckList checkList, boolean bl, Writer writer) throws CheckStorageException {
        String string = this.toXmlString(checkList, bl);
        try {
            writer.write(string);
        }
        catch (IOException iOException) {
            LocalizedString localizedString = MessageLocalizer.makeLS(class$com$sun$eras$common$checkstorage$CheckStorageIOException == null ? (class$com$sun$eras$common$checkstorage$CheckStorageIOException = XmlCheckStorage.class$("com.sun.eras.common.checkstorage.CheckStorageIOException")) : class$com$sun$eras$common$checkstorage$CheckStorageIOException, CheckStorageIOException.CANTWRITECHECKLISTTOWRITER, "can't write checklist to Writer.", null, null);
            throw new CheckStorageIOException(localizedString, (Throwable)iOException);
        }
    }

    public void storeChecks(CheckList checkList, boolean bl, PrintStream printStream) throws CheckStorageException {
        String string = this.toXmlString(checkList, bl);
        printStream.print(string);
        if (printStream.checkError()) {
            LocalizedString localizedString = MessageLocalizer.makeLS(class$com$sun$eras$common$checkstorage$CheckStorageIOException == null ? (class$com$sun$eras$common$checkstorage$CheckStorageIOException = XmlCheckStorage.class$("com.sun.eras.common.checkstorage.CheckStorageIOException")) : class$com$sun$eras$common$checkstorage$CheckStorageIOException, CheckStorageIOException.CANTWRITECHECKLISTTOPRINTSTREAM, "can't write checklist to PrintStream.", null, null);
            throw new CheckStorageIOException(localizedString, (Throwable)new IOException());
        }
    }

    /*
     * Loose catch block
     */
    public void storeChecks(CheckList checkList, boolean bl, String string) throws CheckStorageException {
        block14: {
            IOException iOException2222;
            OutputStreamWriter outputStreamWriter;
            FileOutputStream fileOutputStream;
            block13: {
                fileOutputStream = null;
                outputStreamWriter = null;
                fileOutputStream = new FileOutputStream(string);
                outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF8");
                this.storeChecks(checkList, bl, outputStreamWriter);
                Object var9_6 = null;
                if (outputStreamWriter == null) break block13;
                try {
                    outputStreamWriter.close();
                }
                catch (IOException iOException2222) {
                    // empty catch block
                }
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException2222) {}
            }
            break block14;
            {
                catch (IOException iOException3) {
                    LocalizedString localizedString = MessageLocalizer.makeLS(class$com$sun$eras$common$checkstorage$CheckStorageIOException == null ? (class$com$sun$eras$common$checkstorage$CheckStorageIOException = XmlCheckStorage.class$("com.sun.eras.common.checkstorage.CheckStorageIOException")) : class$com$sun$eras$common$checkstorage$CheckStorageIOException, CheckStorageIOException.FORCHECKLISTFILE, "For checklist file " + string, new Object[]{string}, null);
                    throw new CheckStorageIOException(localizedString, (Throwable)iOException3);
                }
            }
            catch (Throwable throwable) {
                IOException iOException42222;
                Object var9_7 = null;
                if (outputStreamWriter != null) {
                    try {
                        outputStreamWriter.close();
                    }
                    catch (IOException iOException42222) {
                        // empty catch block
                    }
                }
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException42222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    protected String toXmlString(CheckList checkList, boolean bl) throws CheckStorageException {
        StringBuffer stringBuffer = new StringBuffer();
        this.toXmlString(stringBuffer, checkList, bl);
        return stringBuffer.toString();
    }

    protected StringBuffer toXmlString(StringBuffer stringBuffer, CheckList checkList, boolean bl) throws CheckStorageException {
        if ("Entity-Resolver-Required:eras-common.jar!checklist.dtd".equals(this.doctype)) {
            if (!this.cdata && !this.allowGenerationWithBadDtd) {
                throw new CheckStorageIllegalDtdException(this.doctype, this.cdata);
            }
        } else if ("Entity-Resolver-Required:eras-common.jar!checklist1_1.dtd".equals(this.doctype)) {
            if (this.cdata && !this.allowGenerationWithBadDtd) {
                throw new CheckStorageIllegalDtdException(this.doctype, this.cdata);
            }
        } else if (!this.allowGenerationWithBadDtd) {
            throw new CheckStorageIllegalDtdException(this.doctype);
        }
        XmlCheckStorage.initializeToXmlStringBuffer(stringBuffer, this.doctype);
        this.checklistToXmlStringBuffer(stringBuffer, checkList, bl);
        XmlCheckStorage.finalizeToXmlStringBuffer(stringBuffer, this.daysToExpire);
        return stringBuffer;
    }

    protected static StringBuffer initializeToXmlStringBuffer(StringBuffer stringBuffer, String string) {
        if (string == null) {
            string = "Entity-Resolver-Required:eras-common.jar!checklist.dtd";
        }
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
        stringBuffer.append("<!DOCTYPE checklist ");
        String string2 = new EntityResolverHelper().publicIdForSystemId(string);
        if (string2 != null) {
            stringBuffer.append("PUBLIC ");
            stringBuffer.append("\"");
            stringBuffer.append(string2);
            stringBuffer.append("\" ");
        } else {
            stringBuffer.append("SYSTEM ");
        }
        stringBuffer.append("\"");
        stringBuffer.append(string);
        stringBuffer.append("\">\n");
        stringBuffer.append("<checklist>\n");
        return stringBuffer;
    }

    protected StringBuffer checklistToXmlStringBuffer(StringBuffer stringBuffer, CheckList checkList, boolean bl) throws CheckStorageException {
        CheckIterator checkIterator = checkList.checkIterator();
        while (checkIterator.hasNext()) {
            Check check = checkIterator.nextCheck();
            stringBuffer.append("\n");
            this.writeCheckToXmlString(check, stringBuffer, 1, bl, 2);
        }
        return stringBuffer;
    }

    protected static StringBuffer finalizeToXmlStringBuffer(StringBuffer stringBuffer, int n) throws CheckStorageCrcException {
        int n2 = stringBuffer.length();
        stringBuffer.append('\n');
        stringBuffer.append(DateUtil.genGenerationDateTag());
        stringBuffer.append(DateUtil.genExpirationDateTag((long)(n * 24 * 60) * 60L));
        stringBuffer.append("</checklist>\n");
        logger.fine("ready to stamp");
        if (!CRCFactory.stampStringWithCRC(stringBuffer, n2)) {
            String string = MessageLocalizer.makeLMS(class$com$sun$eras$common$checkstorage$XmlCheckStorage == null ? (class$com$sun$eras$common$checkstorage$XmlCheckStorage = XmlCheckStorage.class$("com.sun.eras.common.checkstorage.XmlCheckStorage")) : class$com$sun$eras$common$checkstorage$XmlCheckStorage, new MessageKey("CRCstampofchecklistfailed4"), "CRC stamp of checklist failed.", null, null);
            logger.severe(string);
            LocalizedString localizedString = MessageLocalizer.makeLS(class$com$sun$eras$common$checkstorage$CheckStorageCrcException == null ? (class$com$sun$eras$common$checkstorage$CheckStorageCrcException = XmlCheckStorage.class$("com.sun.eras.common.checkstorage.CheckStorageCrcException")) : class$com$sun$eras$common$checkstorage$CheckStorageCrcException, CheckStorageCrcException.CRCSTAMPOFCHECKLISTFAILED, "CRC stamp of checklist failed.", null, null);
            throw new CheckStorageCrcException(localizedString);
        }
        logger.fine("stamped.");
        return stringBuffer;
    }

    private StringBuffer writeCheckNoteToXmlString(CheckNote checkNote, StringBuffer stringBuffer, int n, boolean bl, int n2) throws CheckStorageException {
        this.xu.appendOpen(stringBuffer, n, "note", 1);
        String string = checkNote.getCreatedDate();
        this.xu.appendClause(stringBuffer, n + 1, "created_date", this.xu.notNull(string));
        string = checkNote.getNoteData();
        this.xu.appendClause(stringBuffer, n + 1, "note_data", this.xu.makeCdata(this.xu.notNull(string)));
        string = checkNote.getCreatedBy();
        this.xu.appendClause(stringBuffer, n + 1, "created_by", this.xu.makeCdata(this.xu.notNull(string)));
        string = checkNote.getNoteSeq();
        this.xu.appendClause(stringBuffer, n + 1, "note_seq", this.xu.makeCdata(this.xu.notNull(string)), 0);
        this.xu.appendClose(stringBuffer, n, "note", n2);
        return stringBuffer;
    }

    private StringBuffer writeCheckParamToXmlString(CheckParam checkParam, StringBuffer stringBuffer, int n, boolean bl, int n2) throws CheckStorageException {
        this.xu.appendOpen(stringBuffer, n, "check_param", 1);
        String string = checkParam.getParamName();
        this.xu.appendClause(stringBuffer, n + 1, "param_name", this.xu.notNull(string));
        string = checkParam.getParamValue();
        this.xu.appendClause(stringBuffer, n + 1, "param_value", this.xu.notNull(string));
        string = checkParam.getParamDesc();
        this.xu.appendClause(stringBuffer, n + 1, "param_desc", this.xu.notNull(string));
        string = checkParam.getParamId();
        this.xu.appendClause(stringBuffer, n + 1, "param_id", this.xu.notNull(string));
        string = checkParam.getParamCreatedBy();
        this.xu.appendClause(stringBuffer, n + 1, "param_created_by", this.xu.notNull(string));
        string = checkParam.getParamCreatedDate();
        this.xu.appendClause(stringBuffer, n + 1, "param_created_date", this.xu.notNull(string));
        string = checkParam.getParamUpdatedBy();
        this.xu.appendClause(stringBuffer, n + 1, "param_updated_by", this.xu.notNull(string));
        string = checkParam.getParamUpdatedDate();
        this.xu.appendClause(stringBuffer, n + 1, "param_updated_date", this.xu.notNull(string));
        this.xu.appendClose(stringBuffer, n, "check_param", n2);
        return stringBuffer;
    }

    private StringBuffer writeCheckKeywordToXmlString(CheckKeyword checkKeyword, StringBuffer stringBuffer, int n, boolean bl, int n2) throws CheckStorageException {
        this.xu.appendOpen(stringBuffer, n, "keyword", 1);
        String string = checkKeyword.getKeywordName();
        this.xu.appendClause(stringBuffer, n + 1, "keyword_name", this.xu.makeCdata(this.xu.notNull(string)));
        string = checkKeyword.getKeywordId();
        this.xu.appendClause(stringBuffer, n + 1, "keyword_id", this.xu.makeCdata(this.xu.notNull(string)));
        this.xu.appendClose(stringBuffer, n, "keyword", n2);
        return stringBuffer;
    }

    private StringBuffer writeCheckReportSectionToXmlString(CheckReportSection checkReportSection, StringBuffer stringBuffer, int n, boolean bl, int n2) throws CheckStorageException {
        this.xu.appendOpen(stringBuffer, n, "report_section", 1);
        String string = checkReportSection.getRepType();
        this.xu.appendClause(stringBuffer, n + 1, "rep_type", this.xu.makeCdata(this.xu.notNull(string)));
        string = checkReportSection.getRepSection();
        this.xu.appendClause(stringBuffer, n + 1, "rep_section", this.xu.makeCdata(this.xu.notNull(string)));
        string = checkReportSection.getRepSubsection();
        this.xu.appendClause(stringBuffer, n + 1, "rep_subsection", this.xu.makeCdata(this.xu.notNull(string)));
        string = checkReportSection.getRepId();
        this.xu.appendClause(stringBuffer, n + 1, "rep_id", this.xu.makeCdata(this.xu.notNull(string)));
        string = checkReportSection.getRepSubsectionId();
        this.xu.appendClause(stringBuffer, n + 1, "rep_subsection_id", this.xu.makeCdata(this.xu.notNull(string)));
        string = checkReportSection.getRepSectionId();
        this.xu.appendClause(stringBuffer, n + 1, "rep_section_id", this.xu.makeCdata(this.xu.notNull(string)));
        string = checkReportSection.getRepHeaderId();
        this.xu.appendClause(stringBuffer, n + 1, "rep_header_id", this.xu.makeCdata(this.xu.notNull(string)));
        this.xu.appendClose(stringBuffer, n, "report_section", n2);
        return stringBuffer;
    }

    private StringBuffer writeCheckProductToXmlString(CheckProduct checkProduct, StringBuffer stringBuffer, int n, boolean bl, int n2) throws CheckStorageException {
        this.xu.appendOpen(stringBuffer, n, "product", 1);
        String string = checkProduct.getProdCategory();
        this.xu.appendClause(stringBuffer, n + 1, "prod_category", this.xu.makeCdata(this.xu.notNull(string)));
        string = checkProduct.getProdName();
        this.xu.appendClause(stringBuffer, n + 1, "prod_name", this.xu.makeCdata(this.xu.notNull(string)));
        string = checkProduct.getProdId();
        this.xu.appendClause(stringBuffer, n + 1, "prod_id", this.xu.makeCdata(this.xu.notNull(string)));
        string = checkProduct.getProdDesc();
        this.xu.appendClause(stringBuffer, n + 1, "prod_desc", this.xu.makeCdata(this.xu.notNull(string)));
        this.xu.appendClose(stringBuffer, n, "product", n2);
        return stringBuffer;
    }

    private StringBuffer writeCheckRefdocToXmlString(CheckRefdoc checkRefdoc, StringBuffer stringBuffer, int n, boolean bl, int n2) throws CheckStorageException {
        this.xu.appendOpen(stringBuffer, n, "refdoc", 1);
        String string = checkRefdoc.getRefdocId();
        this.xu.appendClause(stringBuffer, n + 1, "refdoc_id", this.xu.makeCdata(this.xu.notNull(string)));
        string = checkRefdoc.getRefdocFilename();
        this.xu.appendClause(stringBuffer, n + 1, "refdoc_filename", this.xu.makeCdata(this.xu.notNull(string)));
        string = checkRefdoc.getRefdocDoctype();
        this.xu.appendClause(stringBuffer, n + 1, "refdoc_doctype", this.xu.makeCdata(this.xu.notNull(string)));
        string = checkRefdoc.getRefdocDocurl();
        this.xu.appendClause(stringBuffer, n + 1, "refdoc_docurl", this.xu.makeCdata(this.xu.notNull(string)));
        string = checkRefdoc.getRefdocDocid();
        this.xu.appendClause(stringBuffer, n + 1, "refdoc_docid", this.xu.makeCdata(this.xu.notNull(string)));
        string = checkRefdoc.getRefdocDoctitle();
        this.xu.appendClause(stringBuffer, n + 1, "refdoc_doctitle", this.xu.makeCdata(this.xu.notNull(string)));
        string = checkRefdoc.getRefdocExternal();
        this.xu.appendClause(stringBuffer, n + 1, "refdoc_external", this.xu.makeCdata(this.xu.notNull(string)));
        this.xu.appendClose(stringBuffer, n, "refdoc", n2);
        return stringBuffer;
    }

    private StringBuffer writeCheckSwordfishProductToXmlString(CheckSwordfishProduct checkSwordfishProduct, StringBuffer stringBuffer, int n, boolean bl, int n2) throws CheckStorageException {
        this.xu.appendOpenForAttributes(stringBuffer, n, "swordfish_product");
        String string = checkSwordfishProduct.getProdUuid();
        stringBuffer.append(" uuid='").append(string).append("' ");
        boolean bl2 = checkSwordfishProduct.isPrimaryLink();
        stringBuffer.append(" primary_link='");
        if (bl2) {
            stringBuffer.append("true");
        } else {
            stringBuffer.append("false");
        }
        stringBuffer.append("'>\n");
        string = checkSwordfishProduct.getProdName();
        this.xu.appendClause(stringBuffer, n + 1, "prod_name", this.xu.makeCdata(this.xu.notNull(string)));
        string = checkSwordfishProduct.getProdDescription();
        this.xu.appendClause(stringBuffer, n + 1, "prod_description", this.xu.makeCdata(this.xu.notNull(string)));
        string = checkSwordfishProduct.getProdParentUuid();
        if (string != null) {
            this.xu.appendOpenForAttributes(stringBuffer, n + 1, "prod_parent_id");
            stringBuffer.append(" uuid='").append(string).append("'/>\n");
        }
        this.xu.appendClose(stringBuffer, n, "swordfish_product", n2);
        return stringBuffer;
    }

    protected StringBuffer writeCheckToXmlString(Check check, StringBuffer stringBuffer, int n, boolean bl, int n2) throws CheckStorageException {
        Serializable serializable;
        Iterator iterator;
        Object object;
        String string;
        if (this.actingLikeExportToXml) {
            string = MessageLocalizer.makeLMS(this, new MessageKey("actingLikeExportToXmlisnolongersupported"), "actingLikeExportToXml is no longer supported.", null, null);
            logger.warning(string);
        }
        this.xu.appendOpen(stringBuffer, n, "check", 1);
        string = check.getId();
        this.xu.appendClause(stringBuffer, n + 1, "id", this.xu.notNull(string));
        string = check.getTitle();
        this.xu.appendClause(stringBuffer, n + 1, "title", string);
        string = check.getAuthor();
        this.xu.appendClause(stringBuffer, n + 1, "author", this.xu.notNull(string));
        Date date = check.getAuthorDate();
        this.xu.appendClause(stringBuffer, n + 1, "author_date", this.xu.notNull(date));
        string = check.getUpdated();
        this.xu.appendClause(stringBuffer, n + 1, "updated", this.xu.notNull(string));
        date = check.getUpdatedDate();
        this.xu.appendClause(stringBuffer, n + 1, "updated_date", this.xu.notNull(date));
        string = check.getApplication();
        this.xu.appendClause(stringBuffer, n + 1, "application", string);
        string = check.getProblem();
        if (this.cdata) {
            this.xu.appendClause(stringBuffer, n + 1, "problem", this.xu.makeCdata(this.xu.notNull(string)));
        } else {
            this.xu.appendClause(stringBuffer, n + 1, "problem", this.xu.notNull(string));
        }
        string = check.getHumanRule();
        if (this.cdata) {
            this.xu.appendClause(stringBuffer, n + 1, "human_rule", this.xu.makeCdata(string));
        } else {
            this.xu.appendClause(stringBuffer, n + 1, "human_rule", string);
        }
        List list = check.getExplorerPathList();
        if (list != null) {
            object = list.iterator();
            while (object.hasNext()) {
                iterator = (String)object.next();
                this.xu.appendClause(stringBuffer, n + 1, "explorer_path", (String)((Object)iterator));
            }
        }
        string = check.getCheckApplicability();
        this.xu.appendClause(stringBuffer, n + 1, "check_applicability", this.xu.makeCdata(this.xu.notNull(string)));
        object = check.getSeverity();
        string = String.valueOf(((CheckSeverity)object).intValue());
        this.xu.appendClause(stringBuffer, n + 1, "severity", string);
        string = check.getRecommendations();
        if (this.cdata) {
            this.xu.appendClause(stringBuffer, n + 1, "recommendations", this.xu.makeCdata(this.xu.notNull(string)));
        } else {
            this.xu.appendClause(stringBuffer, n + 1, "recommendations", this.xu.notNull(string));
        }
        string = check.getAnalysis();
        if (this.cdata) {
            this.xu.appendClause(stringBuffer, n + 1, "analysis", this.xu.makeCdata(this.xu.notNull(string)));
        } else {
            this.xu.appendClause(stringBuffer, n + 1, "analysis", this.xu.notNull(string));
        }
        if (bl) {
            string = check.getAutomationState();
            this.xu.appendClause(stringBuffer, n + 1, "automation_state", string);
        }
        if (bl) {
            string = check.getEnabledString();
            this.xu.appendClause(stringBuffer, n + 1, "enabled", string);
        }
        if (bl) {
            string = check.getCheckState();
            this.xu.appendClause(stringBuffer, n + 1, "check_state", string);
        }
        string = check.getDomain();
        this.xu.appendClause(stringBuffer, n + 1, "domain", string);
        string = check.getRestrictedString();
        this.xu.appendClause(stringBuffer, n + 1, "restricted", string, 1);
        string = check.getKceApplicability();
        this.xu.appendClause(stringBuffer, n + 1, "kce_applicability", this.xu.makeCdata(string));
        string = check.getKceRuleAuthor();
        this.xu.appendClause(stringBuffer, n + 1, "kce_rule_author", string);
        string = check.getKceConditions();
        this.xu.appendClause(stringBuffer, n + 1, "kce_conditions", this.xu.makeCdata(string));
        string = check.getKceSeverity();
        this.xu.appendClause(stringBuffer, n + 1, "kce_severity", this.xu.makeCdata(string));
        string = check.getKceAnalysis();
        if (this.cdata) {
            this.xu.appendClause(stringBuffer, n + 1, "kce_analysis", this.xu.makeCdata(string));
        } else {
            this.xu.appendClause(stringBuffer, n + 1, "kce_analysis", string);
        }
        string = check.getKceRecommendations();
        if (this.cdata) {
            this.xu.appendClause(stringBuffer, n + 1, "kce_recommendations", this.xu.makeCdata(string));
        } else {
            this.xu.appendClause(stringBuffer, n + 1, "kce_recommendations", string);
        }
        string = check.getKceRecommendationFacts();
        this.xu.appendClause(stringBuffer, n + 1, "kce_recommendation_facts", this.xu.makeCdata(string));
        string = check.getKceExecution();
        if (this.cdata) {
            this.xu.appendClause(stringBuffer, n + 1, "kce_execution", this.xu.makeCdata(string));
        } else {
            this.xu.appendClause(stringBuffer, n + 1, "kce_execution", string);
        }
        if (bl && (list = check.getNoteList()) != null) {
            iterator = list.iterator();
            while (iterator.hasNext()) {
                serializable = (CheckNote)iterator.next();
                this.writeCheckNoteToXmlString((CheckNote)serializable, stringBuffer, n + 1, bl, 1);
            }
        }
        if (bl && (list = check.getProductList()) != null) {
            iterator = list.iterator();
            while (iterator.hasNext()) {
                serializable = (CheckProduct)iterator.next();
                this.writeCheckProductToXmlString((CheckProduct)serializable, stringBuffer, n + 1, bl, 1);
            }
        }
        if (bl && (list = check.getReportSectionList()) != null) {
            iterator = list.iterator();
            while (iterator.hasNext()) {
                serializable = (CheckReportSection)iterator.next();
                this.writeCheckReportSectionToXmlString((CheckReportSection)serializable, stringBuffer, n + 1, bl, 1);
            }
        }
        if ((list = check.getKeywordList()) != null) {
            iterator = list.iterator();
            while (iterator.hasNext()) {
                serializable = (CheckKeyword)iterator.next();
                this.writeCheckKeywordToXmlString((CheckKeyword)serializable, stringBuffer, n + 1, bl, 1);
            }
        }
        if ((list = check.getRefdocList()) != null) {
            iterator = list.iterator();
            while (iterator.hasNext()) {
                serializable = (CheckRefdoc)iterator.next();
                this.writeCheckRefdocToXmlString((CheckRefdoc)serializable, stringBuffer, n + 1, bl, 1);
            }
        }
        if ((list = check.getCheckParamList()) != null) {
            iterator = list.iterator();
            while (iterator.hasNext()) {
                serializable = (CheckParam)iterator.next();
                this.writeCheckParamToXmlString((CheckParam)serializable, stringBuffer, n + 1, bl, 1);
            }
        }
        if ((list = check.getProductCategoryList()) != null) {
            iterator = list.iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                this.xu.appendClause(stringBuffer, n + 1, "product_category", string);
            }
        }
        string = check.getMinRequiredKaeVersion();
        this.xu.appendClause(stringBuffer, n + 1, "min_required_kae_version", string);
        string = check.getDbid();
        this.xu.appendClause(stringBuffer, n + 1, "dbid", string);
        string = check.getMetadbid();
        this.xu.appendClause(stringBuffer, n + 1, "metadbid", string);
        list = check.getSwordfishProductList();
        if (list != null) {
            iterator = list.iterator();
            while (iterator.hasNext()) {
                serializable = (CheckSwordfishProduct)iterator.next();
                this.writeCheckSwordfishProductToXmlString((CheckSwordfishProduct)serializable, stringBuffer, n + 1, bl, 1);
            }
        }
        string = check.getAudience();
        this.xu.appendClause(stringBuffer, n + 1, "audience", string);
        date = check.getValidDate();
        this.xu.appendClause(stringBuffer, n + 1, "valid_date", date);
        string = check.getRevisionNumberString();
        this.xu.appendClause(stringBuffer, n + 1, "revision_number", string);
        this.xu.appendClose(stringBuffer, n, "check", n2);
        return stringBuffer;
    }

    static XmlCheckStorage mainMakeXmlCheckStorage(String string) throws CheckStorageException {
        return new XmlCheckStorage(string);
    }

    static XmlCheckStorage mainMakeXmlCheckStorage(InputStream inputStream) throws CheckStorageException {
        return new XmlCheckStorage(inputStream);
    }

    public static void main(String[] stringArray) throws Exception {
        boolean bl;
        CheckStorageSecurityCredentials checkStorageSecurityCredentials = null;
        String string = null;
        boolean bl2 = stringArray.length > 2 && "yes".equals(stringArray[2]);
        boolean bl3 = bl = stringArray.length > 3 && "yes".equals(stringArray[3]);
        if (stringArray.length == 0) {
            System.err.println("Usage: java XmlCheckStorage in-file-name [out-file-name] [allDetails] [compat]");
            System.err.println("       if in-file-name == '-' then it reads from System.in.");
            System.err.println("       if out-file-name == '-' then it writes from System.out.");
            System.err.println("       if out-file-name == '+' then it dumps checklist.toString() to System.out.");
            System.err.println("       if out-file-name == '++' then it dumps all of the checks to System.out.");
            System.err.println("       if allDetails==yes, then outputs all properties.");
            System.err.println("       if compat==yes, then outputs in format of ExportToXml.");
            System.exit(1);
        }
        try {
            XmlCheckStorage xmlCheckStorage;
            XmlCheckStorage xmlCheckStorage2;
            int n = 0;
            int n2 = stringArray.length;
            boolean bl4 = false;
            if (stringArray[0].equals("-novalidation")) {
                logger.info("-novalidation detected");
                bl4 = true;
                ++n;
                --n2;
            }
            String string2 = stringArray[n];
            String string3 = "Entity-Resolver-Required:eras-common.jar!checklist.dtd";
            boolean bl5 = true;
            if ("-".equals(string2)) {
                logger.info("Reading checks from System.in");
                xmlCheckStorage2 = new XmlCheckStorage(System.in, string3);
            } else {
                logger.info("Reading checks from file \"" + string2 + "\"");
                xmlCheckStorage2 = new XmlCheckStorage(string2, string3);
            }
            if (bl4) {
                xmlCheckStorage = xmlCheckStorage2;
                xmlCheckStorage.validating = false;
                xmlCheckStorage.validateCRC = false;
                xmlCheckStorage.validateExpirationDate = false;
            }
            CheckStorageConnection checkStorageConnection = xmlCheckStorage2.getConnection(checkStorageSecurityCredentials);
            CheckList checkList = checkStorageConnection.getChecks();
            logger.info(checkList.size() + "checks read.");
            xmlCheckStorage = (XmlCheckStorage)checkStorageConnection;
            xmlCheckStorage.setCdata(bl5);
            if (bl) {
                xmlCheckStorage.setActingLikeExportToXml(true);
            }
            if (n2 > 1) {
                string = stringArray[n + 1];
            } else if (!"-".equals(string2)) {
                string = string2 + ".new";
            }
            if (string == null || "-".equals(string)) {
                logger.info("Writing checks to System.out.\n   allDetails=" + bl2 + ",  actingLikeExportToXml=" + bl);
                xmlCheckStorage.storeChecks(checkList, bl2, System.out);
            } else if ("+".equals(string)) {
                logger.info("Dumping checkList.toString to System.out");
                System.out.println(checkList.toString());
            } else if ("++".equals(string)) {
                logger.info("Dumping checkList contents to System.out");
                CheckIterator checkIterator = checkList.checkIterator();
                while (checkIterator.hasNext()) {
                    Check check = checkIterator.nextCheck();
                    System.out.println(check.toString());
                    System.out.println("\n\n");
                }
            } else {
                logger.info("Writing checks to file \"" + string + "\".\n" + "  allDetails=" + bl2 + ",  actingLikeExportToXml=" + bl);
                xmlCheckStorage.storeChecks(checkList, bl2, string);
            }
        }
        catch (Exception exception) {
            System.out.println("Exception in Main " + exception);
            exception.printStackTrace();
            throw exception;
        }
        logger.info("all done");
        System.exit(0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        DEFAULT_CDATA = CHECKLIST_CDATA = true;
    }
}

