/*
 * Decompiled with CFR 0.152.
 */
package com.sun.eras.common.checks.filters;

import com.sun.eras.common.checks.filters.CheckFilter;
import com.sun.eras.common.checks.filters.FilterOperators;
import com.sun.eras.common.util.MessageKey;
import com.sun.eras.common.util.MessageLocalizer;

public abstract class ComparableCheckFilter
extends CheckFilter {
    protected int operator;
    protected Comparable comparable;

    protected ComparableCheckFilter(int n, Comparable comparable) {
        if (!this.isLegalOperator(n)) {
            String string = MessageLocalizer.makeLMS(this, new MessageKey("illegaloperator"), "illegal operator", null, null);
            throw new IllegalArgumentException(string);
        }
        if (comparable == null) {
            String string = MessageLocalizer.makeLMS(this, new MessageKey("comparablecannotbenull"), "comparable cannot be null", null, null);
            throw new IllegalArgumentException(string);
        }
        this.comparable = comparable;
        this.operator = n;
    }

    public int getOperator() {
        return this.operator;
    }

    public Comparable getComparable() {
        return this.comparable;
    }

    public boolean isLegalOperator(int n) {
        return n >= 0 && n <= 5;
    }

    protected boolean matchComparable(Comparable comparable) {
        if (comparable == null) {
            return false;
        }
        int n = comparable.compareTo(this.comparable);
        switch (this.operator) {
            case 0: {
                return n == 0;
            }
            case 1: {
                return n >= 0;
            }
            case 2: {
                return n > 0;
            }
            case 3: {
                return n <= 0;
            }
            case 4: {
                return n < 0;
            }
            case 5: {
                return n != 0;
            }
        }
        return false;
    }

    protected void toStringBody(StringBuffer stringBuffer) {
        stringBuffer.append("op=").append(FilterOperators.toString(this.operator)).append(",");
        stringBuffer.append("operand=\"").append(this.comparable).append("\"");
    }
}

