/*
 * Decompiled with CFR 0.152.
 */
package com.sun.eras.common.checks;

import com.sun.eras.common.checks.Check;
import com.sun.eras.common.checks.CheckIterator;
import com.sun.eras.common.checks.filters.CheckFilter;
import com.sun.eras.common.logging4.Logger;
import com.sun.eras.common.util.MessageKey;
import com.sun.eras.common.util.MessageLocalizer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class CheckList
implements List,
Serializable {
    private static final Logger logger = Logger.getLogger((class$com$sun$eras$common$checks$CheckList == null ? (class$com$sun$eras$common$checks$CheckList = CheckList.class$("com.sun.eras.common.checks.CheckList")) : class$com$sun$eras$common$checks$CheckList).getName());
    static final long serialVersionUID = 715264954171179119L;
    private List servant = new ArrayList();
    private List largerServant = this.servant;
    static /* synthetic */ Class class$com$sun$eras$common$checks$CheckList;

    public CheckList(Collection collection, CheckFilter checkFilter) {
        if (collection != null) {
            this.addAll(collection, checkFilter);
        }
    }

    public CheckList(Collection collection) {
        this(collection, null);
    }

    public CheckList() {
        this(null, null);
    }

    public CheckList(CheckList checkList, int n, int n2) {
        this.servant = checkList.servant.subList(n, n2);
        this.largerServant = checkList.largerServant;
    }

    protected void validateIndex(int n, boolean bl) throws IndexOutOfBoundsException {
        if (n < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (bl) {
            --n;
        }
        if (n >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
    }

    boolean isAddOk(Check check) {
        String string = check.getId();
        Iterator iterator = this.largerServant.iterator();
        while (iterator.hasNext()) {
            Check check2 = (Check)iterator.next();
            if (!string.equals(check2.getId())) continue;
            return false;
        }
        return true;
    }

    boolean isSetOk(Check check, Check check2) {
        if (check == check2) {
            return true;
        }
        if (check.getId() == check2.getId()) {
            return true;
        }
        return this.isAddOk(check2);
    }

    protected void validateAdd(Object object) throws ClassCastException, IllegalArgumentException {
        Check check = (Check)object;
        String string = check.getId();
        if (!this.isAddOk(check)) {
            String string2 = MessageLocalizer.makeLMS(this, new MessageKey("newelementsidmustbeuniqueAdding"), "new element's id must be unique. Adding " + check.getId(), new Object[]{check.getId()}, null);
            throw new IllegalArgumentException(string2);
        }
    }

    protected void validateSet(Object object, int n) throws ClassCastException, IllegalArgumentException {
        Check check = (Check)object;
        String string = check.getId();
        if (!this.isSetOk(this.getCheck(n), check)) {
            String string2 = MessageLocalizer.makeLMS(this, new MessageKey("newelementsidmustbeuniqueSettingatindex"), "new element's id must be unique. Setting " + check.getId() + " at index " + n, new Object[]{check.getId(), new Integer(n)}, null);
            throw new IllegalArgumentException(string2);
        }
    }

    public boolean addAll(int n, Collection collection, CheckFilter checkFilter) {
        logger.fine("CheckList.addAll");
        this.validateIndex(n, true);
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Check check = (Check)iterator.next();
            if (checkFilter != null && !checkFilter.match(check)) continue;
            this.validateAdd(check);
            this.servant.add(n, check);
            ++n;
            bl = true;
        }
        return bl;
    }

    public boolean addAll(Collection collection, CheckFilter checkFilter) {
        return this.addAll(this.servant.size(), collection, checkFilter);
    }

    public boolean removeAll(CheckFilter checkFilter) {
        boolean bl = false;
        Iterator iterator = this.servant.iterator();
        while (iterator.hasNext()) {
            Check check = (Check)iterator.next();
            if (!checkFilter.match(check)) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public boolean retainAll(CheckFilter checkFilter) {
        boolean bl = false;
        Iterator iterator = this.servant.iterator();
        while (iterator.hasNext()) {
            Check check = (Check)iterator.next();
            if (checkFilter.match(check)) continue;
            bl = true;
            iterator.remove();
        }
        return bl;
    }

    public Check getCheck(int n) {
        return (Check)this.servant.get(n);
    }

    public Check removeCheck(int n) {
        return (Check)this.servant.remove(n);
    }

    public Check setCheck(int n, Check check) {
        this.validateIndex(n, false);
        this.validateSet(check, n);
        return this.servant.set(n, check);
    }

    public Check[] toCheckArray() {
        return (Check[])this.servant.toArray();
    }

    public void add(int n, Object object) {
        this.validateIndex(n, true);
        this.validateAdd(object);
        this.servant.add(n, object);
    }

    public boolean add(Object object) {
        this.add(this.servant.size(), object);
        return true;
    }

    public boolean addAll(Collection collection) {
        return this.addAll(this.servant.size(), collection, null);
    }

    public boolean addAll(int n, Collection collection) {
        return this.addAll(n, collection, null);
    }

    public void clear() {
        this.servant.clear();
    }

    public boolean contains(Object object) {
        return this.servant.contains(object);
    }

    public boolean containsAll(Collection collection) {
        return this.servant.containsAll(collection);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CheckList)) {
            return false;
        }
        return this.servant.equals(((CheckList)object).servant);
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    public Object get(int n) {
        return this.servant.get(n);
    }

    public int indexOf(Object object) {
        return this.servant.indexOf(object);
    }

    public boolean isEmpty() {
        return this.servant.isEmpty();
    }

    ListIterator underlyingIterator() {
        return this.servant.listIterator();
    }

    ListIterator underlyingIterator(int n) {
        return this.servant.listIterator(n);
    }

    public Iterator iterator() {
        return this.checkIterator();
    }

    public CheckIterator checkIterator(int n) {
        return new CheckIterator(this, n);
    }

    public CheckIterator checkIterator() {
        return new CheckIterator(this);
    }

    public int lastIndexOf(Object object) {
        return this.servant.lastIndexOf(object);
    }

    public ListIterator listIterator() {
        return this.checkIterator();
    }

    public ListIterator listIterator(int n) {
        return this.checkIterator(n);
    }

    public Object remove(int n) {
        return this.servant.remove(n);
    }

    public boolean remove(Object object) {
        return this.servant.remove(object);
    }

    public boolean removeAll(Collection collection) {
        return this.servant.removeAll(collection);
    }

    public boolean retainAll(Collection collection) {
        return this.servant.retainAll(collection);
    }

    public Object set(int n, Object object) {
        return this.setCheck(n, (Check)object);
    }

    public int size() {
        return this.servant.size();
    }

    public List subList(int n, int n2) {
        return new CheckList(this, n, n2);
    }

    public Object[] toArray() {
        return this.servant.toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        if (!(objectArray instanceof Check[])) {
            String string = MessageLocalizer.makeLMS(this, new MessageKey("mustbeCheck"), "must be Check[]", null, null);
            throw new ArrayStoreException(string);
        }
        return this.servant.toArray(objectArray);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("CheckList[");
        CheckIterator checkIterator = this.checkIterator();
        while (checkIterator.hasNext()) {
            Check check = checkIterator.nextCheck();
            stringBuffer.append(check.getId());
            if (!checkIterator.hasNext()) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

