/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import java.util.Hashtable;
import java.util.Properties;
import org.apache.xml.res.XMLMessages;
import org.apache.xml.serializer.SerializationHandler;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.utils.WrappedRuntimeException;
import org.xml.sax.ContentHandler;

public abstract class SerializerFactory {
    private static Hashtable m_formats = new Hashtable();

    public static Serializer getSerializer(Properties format) {
        Serializer ser;
        block6: {
            ser = null;
            try {
                String method = format.getProperty("method");
                if (method == null) {
                    throw new IllegalArgumentException("The output format has a null method name");
                }
                String className = format.getProperty("{http://xml.apache.org/xalan}content-handler");
                if (null == className) {
                    throw new IllegalArgumentException("The output format must have a '{http://xml.apache.org/xalan}content-handler' property!");
                }
                Class<?> cls = Class.forName(className);
                Object obj = cls.newInstance();
                if (obj instanceof SerializationHandler) {
                    ser = (Serializer)cls.newInstance();
                    ser.setOutputFormat(format);
                    break block6;
                }
                if (obj instanceof ContentHandler) {
                    className = "org.apache.xml.serializer.ToXMLSAXHandler";
                    cls = Class.forName(className);
                    SerializationHandler sh = (SerializationHandler)cls.newInstance();
                    sh.setContentHandler((ContentHandler)obj);
                    sh.setOutputFormat(format);
                    ser = sh;
                    break block6;
                }
                throw new Exception(XMLMessages.createXMLMessage("ER_SERIALIZER_NOT_CONTENTHANDLER", new Object[]{className}));
            }
            catch (Exception e) {
                throw new WrappedRuntimeException(e);
            }
        }
        return ser;
    }
}

