/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.compiler;

import java.util.Vector;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.GETFIELD;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.PUSH;
import org.apache.xalan.xsltc.compiler.CastExpr;
import org.apache.xalan.xsltc.compiler.Expression;
import org.apache.xalan.xsltc.compiler.FunctionCall;
import org.apache.xalan.xsltc.compiler.LiteralExpr;
import org.apache.xalan.xsltc.compiler.QName;
import org.apache.xalan.xsltc.compiler.Stylesheet;
import org.apache.xalan.xsltc.compiler.SymbolTable;
import org.apache.xalan.xsltc.compiler.util.ClassGenerator;
import org.apache.xalan.xsltc.compiler.util.ErrorMsg;
import org.apache.xalan.xsltc.compiler.util.MethodGenerator;
import org.apache.xalan.xsltc.compiler.util.Type;
import org.apache.xalan.xsltc.compiler.util.TypeCheckError;

final class DocumentCall
extends FunctionCall {
    private Expression _uri = null;
    private Expression _base = null;
    private Type _uriType;

    public DocumentCall(QName fname, Vector arguments) {
        super(fname, arguments);
    }

    public Type typeCheck(SymbolTable stable) throws TypeCheckError {
        LiteralExpr expr;
        int ac = this.argumentCount();
        if (ac < 1 || ac > 2) {
            ErrorMsg msg = new ErrorMsg("ILLEGAL_ARG_ERR", this);
            throw new TypeCheckError(msg);
        }
        this._uri = this.argument(0);
        if (this._uri instanceof LiteralExpr && (expr = (LiteralExpr)this._uri).getValue().equals("")) {
            Stylesheet stylesheet = this.getStylesheet();
            if (stylesheet == null) {
                ErrorMsg msg = new ErrorMsg("ILLEGAL_ARG_ERR", this);
                throw new TypeCheckError(msg);
            }
            this._uri = new LiteralExpr(stylesheet.getSystemId(), "");
        }
        this._uriType = this._uri.typeCheck(stable);
        if (this._uriType != Type.NodeSet && this._uriType != Type.String) {
            this._uri = new CastExpr(this._uri, Type.String);
        }
        if (ac == 2) {
            this._base = this.argument(1);
            Type baseType = this._base.typeCheck(stable);
            if (baseType.identicalTo(Type.Node)) {
                this._base = new CastExpr(this._base, Type.NodeSet);
            } else if (!baseType.identicalTo(Type.NodeSet)) {
                ErrorMsg msg = new ErrorMsg("DOCUMENT_ARG_ERR", this);
                throw new TypeCheckError(msg);
            }
        }
        this._type = Type.NodeSet;
        return this._type;
    }

    public void translate(ClassGenerator classGen, MethodGenerator methodGen) {
        ConstantPoolGen cpg = classGen.getConstantPool();
        InstructionList il = methodGen.getInstructionList();
        int domField = cpg.addFieldref(classGen.getClassName(), "_dom", "Lorg/apache/xalan/xsltc/DOM;");
        String docParamList = "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;Lorg/apache/xalan/xsltc/runtime/AbstractTranslet;Lorg/apache/xalan/xsltc/DOM;)Lorg/apache/xml/dtm/DTMAxisIterator;";
        int docIdx = cpg.addMethodref("org.apache.xalan.xsltc.dom.LoadDocument", "document", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;Lorg/apache/xalan/xsltc/runtime/AbstractTranslet;Lorg/apache/xalan/xsltc/DOM;)Lorg/apache/xml/dtm/DTMAxisIterator;");
        int uriIdx = cpg.addInterfaceMethodref("org.apache.xalan.xsltc.DOM", "getDocumentURI", "(I)Ljava/lang/String;");
        int nextIdx = cpg.addInterfaceMethodref("org.apache.xml.dtm.DTMAxisIterator", "next", "()I");
        this._uri.translate(classGen, methodGen);
        if (this._uriType == Type.NodeSet) {
            this._uri.startResetIterator(classGen, methodGen);
        }
        if (this._base != null) {
            il.append(methodGen.loadDOM());
            this._base.translate(classGen, methodGen);
            il.append(new INVOKEINTERFACE(nextIdx, 1));
            il.append(new INVOKEINTERFACE(uriIdx, 2));
        } else if (this._uriType == Type.NodeSet) {
            il.append(new PUSH(cpg, ""));
        } else {
            il.append(new PUSH(cpg, this.getStylesheet().getSystemId()));
        }
        il.append(new PUSH(cpg, this.getStylesheet().getSystemId()));
        il.append(classGen.loadTranslet());
        il.append(InstructionConstants.DUP);
        il.append(new GETFIELD(domField));
        il.append(new INVOKESTATIC(docIdx));
    }
}

