/*
 * Decompiled with CFR 0.152.
 */
package com.sun.eras.parsers.explorerDir;

import com.sun.eras.parsers.EntityParserImpl;
import com.sun.eras.parsers.ParsedBlock;
import com.sun.eras.parsers.ParserException;
import com.sun.eras.parsers.explorerDir.ExplorerDirEntityParser;
import com.sun.eras.parsers.explorerDir.FileIOException;
import com.sun.eras.parsers.explorerDir.FileParseException;
import com.sun.eras.parsers.inputFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;

public class EDParse_iPlanetHostPackage
extends ExplorerDirEntityParser
implements EntityParserImpl {
    private static final Set iPlanetServerFamily = new HashSet();
    private static final String ApplicationVersionPatternString = "^(\\d+[\\d.]*[a-rt-zA-RT-Z]?)\\s*(?:SP(\\d+[\\d.]*)([a-zA-Z]+\\d*)?)?";
    private static final String ApplicationServicepackPatternString = "^Service Pack\\s+(\\d+[\\d.]*[a-zA-Z]?)(?:\\s+Revision\\s+([a-zA-Z]+\\d*))?";
    private static final String PortalVersionPatternString = "^version (?:iPS)?(\\d+[\\d.]*[a-rt-zA-RT-Z]?)\\s*(?:(?:SP|sp)(\\d+[\\d.]*)([a-zA-Z]+\\d*)?)?";
    private static final String MessagingVersionPatternString = "^((\\w+)\\s+Messaging Server)\\s+(\\d[\\d.]*[a-rt-zA-RT-Z]?)\\s*(?:(?:SP|sp)(\\d[\\d.]*)([a-zA-Z]+\\d*)?)?";
    private static final String NetscapeMessagingVersionPatternString = "(Netscape\\s+Messaging\\s+Server)\\s+(?:STORE\\s+)?([\\d.]+)\\s+(?:Patch\\s+(\\d+))?";
    private static final String DirectoryVersionPatternString = "^((\\w+)[-\\s]Directory).*?/(\\d[\\d.]*[a-rt-zA-RT-Z]?)\\s*(?:(?:SP|ServicePack\\s*)(\\d[\\d.]*)([a-zA-Z]+\\d*)?)?";
    private static final String WebVersionPatternString = "^((\\w+)[-\\s]Web[-\\s]?Server)[-\\s].*?/(\\d[\\d.]*[a-rt-zA-RT-Z]?)\\s*(?:(?:SP|sp)(\\d[\\d.]*)([a-zA-Z]+\\d*)?)?";
    private static final String RegistryNamePatternString = "^\\d+\\s*([^\\d]+?)\\s*\\d+\\s*$";
    private static final String RegistryNameValuePatternString = "^\\d+\\s*([^\\d]+?)\\s*\\d+\\s*([^\\s]+)\\s*$";

    static {
        iPlanetServerFamily.add("Application");
        iPlanetServerFamily.add("Messaging");
        iPlanetServerFamily.add("Directory");
        iPlanetServerFamily.add("Portal");
        iPlanetServerFamily.add("Web");
    }

    public EDParse_iPlanetHostPackage(String string) {
        super(string);
    }

    public static void main(String[] stringArray) {
        ExplorerDirEntityParser.testExplorerDirEntityParser("EDParse_iPlanetHostPackage", stringArray);
    }

    public Vector parse() throws ParserException {
        String string;
        File file;
        Vector<ParsedBlock> vector = new Vector<ParsedBlock>();
        ParsedBlock parsedBlock = null;
        StringBuffer stringBuffer = null;
        if (this.trace) {
            parsedBlock = new ParsedBlock("TRACE");
            vector.add(parsedBlock);
            stringBuffer = new StringBuffer("EDParse_iPlanetHostPackage.parse() called for");
            stringBuffer.append(this.path());
            stringBuffer.append("\n");
        }
        if (!(file = new File(string = String.valueOf(this.path()) + File.separator + "iplanet")).isDirectory()) {
            if (this.trace) {
                stringBuffer.append("..no iPlanet directory found.\n");
            }
            return vector;
        }
        Map map = null;
        Iterator iterator = iPlanetServerFamily.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = String.valueOf(string) + File.separator + string2;
            File file2 = new File(string3);
            if (!file2.isDirectory()) {
                if (!this.trace) continue;
                stringBuffer.append("..no " + string2 + " family directory found.\n");
                continue;
            }
            if ("Application".equals(string2)) {
                this.parseApplicationServers(file2, vector, stringBuffer);
            } else if ("Messaging".equals(string2)) {
                this.parseMessagingServers(file2, vector, stringBuffer);
            } else if ("Portal".equals(string2)) {
                this.parsePortalServers(file2, vector, stringBuffer);
            } else if ("Directory".equals(string2)) {
                this.parseDirectoryServers(file2, vector, stringBuffer);
            } else if ("Web".equals(string2)) {
                this.parseWebServers(file2, vector, stringBuffer);
            }
            if (!"Directory".equals(string2) && !"Web".equals(string2)) continue;
            if (map == null) {
                map = this.parsePkginfoFile(this.path(), stringBuffer);
            }
            this.processPkgaddServers(file2, map, vector, stringBuffer);
        }
        if (this.trace) {
            parsedBlock.put("trace", stringBuffer.toString());
        }
        return vector;
    }

    private void parseApplicationServers(File file, Vector vector, StringBuffer stringBuffer) {
        boolean bl;
        boolean bl2 = bl = stringBuffer != null;
        if (bl) {
            stringBuffer.append("EDParse_iPlanetHostPackage.parseApplicationServers(,,) called");
        }
        String string = file.getPath();
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            ParsedBlock parsedBlock = new ParsedBlock("PackageInstance");
            File file2 = fileArray[n];
            String string2 = file2.getPath();
            if (bl) {
                stringBuffer.append("..Application Server instance " + string2 + "\n");
            }
            if (!file2.isDirectory()) {
                if (bl) {
                    stringBuffer.append(String.valueOf(string2) + " is not a directory\n");
                }
            } else {
                String string3 = file2.getName();
                parsedBlock.put("instanceName", string3);
                parsedBlock.put("instancePath", string2.substring(this.path().length() + 1));
                parsedBlock.put("installDirectory", String.valueOf(File.separator) + string3.replace('_', File.separatorChar));
                String string4 = String.valueOf(string2) + File.separator + "version_info";
                if (!this.parseVersionFiles(string4, parsedBlock, "Application", stringBuffer)) {
                    if (bl) {
                        stringBuffer.append("parseVersionFiles(\"" + string4 + "\",,\"Application\",) returns false\n");
                    }
                } else {
                    String string5;
                    if (bl) {
                        stringBuffer.append("..Found version=" + (String)parsedBlock.get("version"));
                        stringBuffer.append(", servicePack=" + (String)parsedBlock.get("servicePack") + "\n");
                    }
                    if (!this.parseRegistryFiles(string5 = String.valueOf(string2) + File.separator + "registry_files", parsedBlock, stringBuffer)) {
                        if (bl) {
                            stringBuffer.append("parseRegistryFiles(\"" + string5 + "\",,) returns false\n");
                        }
                    } else {
                        if (bl) {
                            stringBuffer.append("..Found vendor=" + (String)parsedBlock.get("vendor"));
                            stringBuffer.append(", name=" + (String)parsedBlock.get("name"));
                            stringBuffer.append(", installDirectory=" + (String)parsedBlock.get("installDirectory") + "\n");
                        }
                        vector.add(parsedBlock);
                    }
                }
            }
            ++n;
        }
    }

    private void parseDirectoryServers(File file, Vector vector, StringBuffer stringBuffer) {
        boolean bl;
        boolean bl2 = bl = stringBuffer != null;
        if (bl) {
            stringBuffer.append("EDParse_iPlanetHostPackage.parseDirectoryServers(,,) called\n");
        }
        String string = file.getPath();
        File[] fileArray = file.listFiles();
        if (fileArray.length == 0) {
            return;
        }
        int n = 0;
        while (n < fileArray.length) {
            block22: {
                String string2;
                String string3;
                File file2;
                block21: {
                    file2 = fileArray[n];
                    string3 = file2.getPath();
                    string2 = file2.getName();
                    if (bl) {
                        stringBuffer.append("..Server root " + string3 + "\n");
                    }
                    if (file2.isDirectory()) break block21;
                    if (bl) {
                        stringBuffer.append(String.valueOf(string3) + " is not a directory\n");
                    }
                    break block22;
                }
                if (bl) {
                    stringBuffer.append(String.valueOf(string3) + " is a Directory server root\n");
                }
                String string4 = null;
                String string5 = null;
                String string6 = null;
                String string7 = null;
                String string8 = null;
                ParsedBlock parsedBlock = new ParsedBlock("PackageInstance");
                if (this.parseVersionFiles(string3, parsedBlock, "Directory", stringBuffer)) {
                    string4 = (String)parsedBlock.get("packageId");
                    string5 = (String)parsedBlock.get("vendor");
                    string6 = (String)parsedBlock.get("version");
                    string7 = (String)parsedBlock.get("servicePack");
                    string8 = (String)parsedBlock.get("name");
                    if ("iPlanet-Directory".equals(string8)) {
                        string8 = "iPlanet Directory Server";
                    } else if ("Netscape-Directory".equals(string8)) {
                        string8 = "Netscape Directory Server";
                    }
                } else if (bl) {
                    stringBuffer.append("No server-root version found in " + string3 + "\n");
                }
                File[] fileArray2 = file2.listFiles();
                int n2 = 0;
                while (n2 < fileArray2.length) {
                    block23: {
                        ParsedBlock parsedBlock2;
                        block26: {
                            block24: {
                                String string9;
                                block25: {
                                    File file3 = fileArray2[n2];
                                    if (!file3.isDirectory()) break block23;
                                    String string10 = file3.getName();
                                    string9 = file3.getPath();
                                    if (bl) {
                                        stringBuffer.append("trying serverInstancePath=" + string9 + "\n");
                                    }
                                    String string11 = null;
                                    if (!string10.startsWith("slapd-")) break block23;
                                    string11 = String.valueOf(string2) + '_' + string10;
                                    if (bl) {
                                        stringBuffer.append("found serverInstanceName=" + string11 + "\n");
                                    }
                                    parsedBlock2 = new ParsedBlock("PackageInstance");
                                    parsedBlock2.put("instanceName", string11);
                                    parsedBlock2.put("instancePath", string9.substring(this.path().length() + 1));
                                    parsedBlock2.put("installDirectory", String.valueOf(File.separator) + string11.replace('_', File.separatorChar));
                                    if (string6 != null) break block24;
                                    if (!this.parseVersionFiles(string9, parsedBlock2, "Directory", stringBuffer)) break block25;
                                    string8 = (String)parsedBlock2.get("name");
                                    if (string8 != null) {
                                        if ("iPlanet-Directory".equals(string8)) {
                                            string8 = "iPlanet Directory Server";
                                        } else if ("Netscape-Directory".equals(string8)) {
                                            string8 = "Netscape Directory Server";
                                        }
                                        parsedBlock2.put("name", string8);
                                    }
                                    break block26;
                                }
                                if (bl) {
                                    stringBuffer.append("No server instance version in " + string9 + "\n");
                                }
                                break block23;
                            }
                            parsedBlock2.put("packageId", string4);
                            parsedBlock2.put("name", string8);
                            parsedBlock2.put("version", string6);
                            parsedBlock2.put("vendor", string5);
                            if (string7 != null) {
                                parsedBlock2.put("servicePack", string7);
                            }
                        }
                        vector.add(parsedBlock2);
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    private void parseMessagingServers(File file, Vector vector, StringBuffer stringBuffer) {
        boolean bl;
        boolean bl2 = bl = stringBuffer != null;
        if (bl) {
            stringBuffer.append("EDParse_iPlanetHostPackage.parseMessagingServers(,,) called");
        }
        String string = file.getPath();
        File[] fileArray = file.listFiles();
        if (fileArray.length == 0) {
            return;
        }
        int n = 0;
        while (n < fileArray.length) {
            File file2 = fileArray[n];
            String string2 = file2.getPath();
            String string3 = file2.getName();
            if (bl) {
                stringBuffer.append("..Server instance " + string2 + "\n");
            }
            if (!file2.isDirectory()) {
                if (bl) {
                    stringBuffer.append(String.valueOf(string2) + " is not a directory\n");
                }
            } else {
                File[] fileArray2 = file2.listFiles();
                int n2 = 0;
                while (n2 < fileArray2.length) {
                    File file3 = fileArray2[n2];
                    if (file3.isDirectory()) {
                        String string4 = file3.getName();
                        String string5 = file3.getPath();
                        String string6 = null;
                        if (string4.startsWith("msg-")) {
                            string6 = String.valueOf(string3) + File.separator + string4;
                            ParsedBlock parsedBlock = new ParsedBlock("PackageInstance");
                            parsedBlock.put("instanceName", string6);
                            parsedBlock.put("instancePath", file3.getPath().substring(this.path().length() + 1));
                            parsedBlock.put("installDirectory", String.valueOf(File.separator) + string6.replace('_', File.separatorChar));
                            if (!this.parseVersionFiles(string5, parsedBlock, "Messaging", stringBuffer)) {
                                if (bl) {
                                    stringBuffer.append("parseVersionFiles(\"" + string5 + "\",,\"Messaging\",) returns false\n");
                                }
                            } else {
                                vector.add(parsedBlock);
                            }
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    private Map parsePkginfoFile(String string, StringBuffer stringBuffer) throws ParserException {
        boolean bl;
        boolean bl2 = bl = stringBuffer != null;
        if (bl) {
            stringBuffer.append("Called EDParse_iPlanetHostPackage.parsePkginfoFile\nexplorerPath=");
            stringBuffer.append(string);
            stringBuffer.append("\n");
        }
        HashMap<String, ParsedBlock> hashMap = new HashMap<String, ParsedBlock>();
        String string2 = String.valueOf(string) + "/patch+pkg/pkginfo-l.out";
        try {
            inputFile inputFile2 = new inputFile(string2);
            BufferedReader bufferedReader = inputFile2.reader();
            String string3 = "";
            inputFile2.defineRegexp("PKGINST", "^\\s+PKGINST:\\s+(SUNWwt.*)$");
            inputFile2.defineRegexp("Keyword value", "^\\s+([A-Z]+):\\s+(.*)$");
            inputFile2.defineRegexp("EMPTY", "^\\s*$");
            inputFile2.defineRegexp("Version and SP", "^(\\d+[\\d.]*)\\s*SP(\\d+[\\d.]*)([^,]*)");
            ParsedBlock parsedBlock = null;
            boolean bl3 = false;
            while ((string3 = bufferedReader.readLine()) != null) {
                String string4;
                MatchResult matchResult;
                if (!bl3 && (matchResult = inputFile2.matchRegexp("PKGINST", string3)) != null) {
                    bl3 = true;
                    parsedBlock = new ParsedBlock("HostPackage");
                    string4 = matchResult.group(1);
                    hashMap.put(string4, parsedBlock);
                    parsedBlock.put("packageId", string4);
                    continue;
                }
                if (bl3 && (matchResult = inputFile2.matchRegexp("Keyword value", string3)) != null) {
                    string4 = matchResult.group(1).toLowerCase();
                    String string5 = matchResult.group(2).trim();
                    if ("name".equals(string4) || "vendor".equals(string4) || "basedir".equals(string4)) {
                        parsedBlock.put(string4, string5);
                        continue;
                    }
                    if (!"version".equals(string4)) continue;
                    matchResult = inputFile2.matchRegexp("Version and SP", string5);
                    if (matchResult != null) {
                        String string6 = matchResult.group(1);
                        String string7 = matchResult.group(2);
                        String string8 = matchResult.group(3);
                        if (string6 != null) {
                            parsedBlock.put("version", string6);
                        }
                        if (string7 != null) {
                            if (string8 != null) {
                                string7 = String.valueOf(string7) + matchResult.group(3).toUpperCase();
                            }
                        } else {
                            string7 = "";
                        }
                        parsedBlock.put("servicePack", string7);
                        continue;
                    }
                    if (!bl) continue;
                    stringBuffer.append("EDParse_iPlanetHostPackage.parsePkginfoFile: cannot parse version=");
                    stringBuffer.append(String.valueOf(string5) + "\n");
                    continue;
                }
                if (!bl3 || (matchResult = inputFile2.matchRegexp("EMPTY", string3)) == null) continue;
                if (bl) {
                    stringBuffer.append("ParsedBlock ");
                    stringBuffer.append(parsedBlock.toString());
                    stringBuffer.append("\n");
                }
                bl3 = false;
            }
            inputFile2.close();
        }
        catch (IOException iOException) {
            throw new FileIOException(string2, "EDParse_iPlanetHostPackage.parsePkginfoFile", iOException);
        }
        catch (MalformedPatternException malformedPatternException) {
            throw new FileParseException(string2, "EDParse_iPlanetHostPackage.parsePkginfoFile", malformedPatternException);
        }
        return hashMap;
    }

    private void parsePortalServers(File file, Vector vector, StringBuffer stringBuffer) {
        boolean bl;
        boolean bl2 = bl = stringBuffer != null;
        if (bl) {
            stringBuffer.append("EDParse_iPlanetHostPackage.parsePortalServers(,,) called");
        }
        String string = file.getPath();
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            ParsedBlock parsedBlock = new ParsedBlock("PackageInstance");
            File file2 = fileArray[n];
            String string2 = file2.getPath();
            if (bl) {
                stringBuffer.append("..Portal Server instance " + string2 + "\n");
            }
            if (!file2.isDirectory()) {
                if (bl) {
                    stringBuffer.append(String.valueOf(string2) + " is not a directory\n");
                }
            } else {
                String string3 = file2.getName();
                parsedBlock.put("instancePath", string2.substring(this.path().length() + 1));
                parsedBlock.put("baseDirectory", String.valueOf(File.separator) + string3.replace('_', File.separatorChar));
                String string4 = String.valueOf(string2) + File.separator + "version_info";
                if (!this.parseVersionFiles(string4, parsedBlock, "Portal", stringBuffer)) {
                    if (bl) {
                        stringBuffer.append("parseVersionFiles(\"" + string4 + "\",,\"Portal\",) returns false\n");
                    }
                } else {
                    if (bl) {
                        stringBuffer.append("..Found version=" + (String)parsedBlock.get("version"));
                        stringBuffer.append(", servicePack=" + (String)parsedBlock.get("servicePack") + "\n");
                    }
                    parsedBlock.put("vendor", "Sun Microsystems, Inc.");
                    parsedBlock.put("name", "iPlanet(TM) Portal Server");
                    File[] fileArray2 = file2.listFiles();
                    int n2 = 0;
                    while (n2 < fileArray2.length) {
                        String string5;
                        File file3;
                        File file4 = fileArray2[n2];
                        String string6 = file4.getPath();
                        String string7 = file4.getName();
                        if (!"config_files".equals(string7) && (file3 = new File(string5 = String.valueOf(string6) + File.separator + "platform.conf")).isFile()) {
                            parsedBlock.put("instanceName", String.valueOf(string3) + File.separator + string7);
                            parsedBlock.put("installDirectory", String.valueOf(File.separator) + string7.replace('_', File.separatorChar));
                            break;
                        }
                        ++n2;
                    }
                    if (bl) {
                        stringBuffer.append("..Found vendor=" + (String)parsedBlock.get("vendor"));
                        stringBuffer.append(", name=" + (String)parsedBlock.get("name"));
                        stringBuffer.append(", installDirectory=" + (String)parsedBlock.get("installDirectory") + "\n");
                    }
                    vector.add(parsedBlock);
                }
            }
            ++n;
        }
    }

    private boolean parseRegistryFiles(String string, ParsedBlock parsedBlock, StringBuffer stringBuffer) {
        boolean bl = stringBuffer != null;
        String string2 = String.valueOf(string) + File.separator + "reg.dat";
        try {
            String string3;
            inputFile inputFile2 = new inputFile(string2);
            inputFile2.defineRegexp("registry name", RegistryNamePatternString);
            inputFile2.defineRegexp("registry name value", RegistryNameValuePatternString);
            BufferedReader bufferedReader = inputFile2.reader();
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            String string4 = null;
            Object var14_13 = null;
            while ((string3 = bufferedReader.readLine()) != null) {
                String string5;
                MatchResult matchResult;
                if (!bl4 && (matchResult = inputFile2.matchRegexp("registry name", string3)) != null) {
                    string5 = matchResult.group(1);
                    if ("SOFTWARE".equals(string5)) {
                        bl2 = true;
                        continue;
                    }
                    if (bl2 && !bl3) {
                        string4 = string5;
                        if ("iPlanet".equals(string5)) {
                            parsedBlock.put("vendor", "Sun Microsystems, Inc.");
                        } else if ("Netscape".equals(string5)) {
                            parsedBlock.put("vendor", "Sun Microsystems, Inc.");
                        } else {
                            parsedBlock.put("vendor", string5);
                        }
                        bl3 = true;
                        continue;
                    }
                    if (!bl3 || bl4) continue;
                    if ("iPlanet".equals(string4)) {
                        parsedBlock.put("name", "iPlanet(TM) " + string5);
                    } else if ("Netscape".equals(string4)) {
                        parsedBlock.put("name", "Netscape " + string5);
                    } else {
                        parsedBlock.put("name", string5);
                    }
                    bl4 = true;
                    continue;
                }
                if (!bl4 || (matchResult = inputFile2.matchRegexp("registry name value", string3)) == null || !"BasePath".equals(string5 = matchResult.group(1))) continue;
                parsedBlock.put("baseDirectory", matchResult.group(2));
                break;
            }
            inputFile2.close();
            return true;
        }
        catch (Exception exception) {
            if (bl) {
                stringBuffer.append("Exception in parseRegistryFiles(\"" + string + "\",,)\n");
                stringBuffer.append(String.valueOf(exception.toString()) + "\n");
            }
            return false;
        }
    }

    private boolean parseVersionFiles(String string, ParsedBlock parsedBlock, String string2, StringBuffer stringBuffer) {
        boolean bl = stringBuffer != null;
        String string3 = String.valueOf(string) + File.separator + "version.out";
        try {
            String string4;
            inputFile inputFile2 = new inputFile(string3);
            boolean bl2 = "Application".equals(string2);
            boolean bl3 = "Directory".equals(string2);
            boolean bl4 = "Messaging".equals(string2);
            boolean bl5 = "Portal".equals(string2);
            boolean bl6 = "Web".equals(string2);
            if (bl2) {
                inputFile2.defineRegexp("versionPattern", ApplicationVersionPatternString);
                inputFile2.defineRegexp("servicePackPattern", ApplicationServicepackPatternString);
            } else if (bl5) {
                inputFile2.defineRegexp("versionPattern", PortalVersionPatternString);
            } else if (bl4) {
                inputFile2.defineRegexp("versionPattern", MessagingVersionPatternString);
                inputFile2.defineRegexp("netscapeVersionPattern", NetscapeMessagingVersionPatternString);
            } else if (bl3) {
                inputFile2.defineRegexp("versionPattern", DirectoryVersionPatternString);
            } else if (bl6) {
                inputFile2.defineRegexp("versionPattern", WebVersionPatternString);
            } else {
                if (bl) {
                    stringBuffer.append("parseVersionFiles: unknown Family=\"" + string2 + "\"\n");
                }
                return false;
            }
            BufferedReader bufferedReader = inputFile2.reader();
            while ((string4 = bufferedReader.readLine()) != null) {
                String string5;
                MatchResult matchResult;
                if (bl2 || bl5) {
                    matchResult = inputFile2.matchRegexp("versionPattern", string4);
                    if (matchResult != null) {
                        parsedBlock.put("version", matchResult.group(1));
                        string5 = matchResult.group(2);
                        if (string5 == null) continue;
                        String string6 = matchResult.group(3);
                        if (string6 != null) {
                            string5 = String.valueOf(string5) + string6.toUpperCase();
                        }
                        parsedBlock.put("servicePack", string5);
                        break;
                    }
                    matchResult = inputFile2.matchRegexp("servicePackPattern", string4);
                    if (matchResult == null) continue;
                    string5 = matchResult.group(1);
                    String string7 = matchResult.group(2);
                    if (string7 != null) {
                        string5 = String.valueOf(string5) + string7.toUpperCase();
                    }
                    parsedBlock.put("servicePack", string5);
                    break;
                }
                if (!bl4 && !bl3 && !bl6) continue;
                matchResult = inputFile2.matchRegexp("versionPattern", string4);
                if (matchResult != null) {
                    parsedBlock.put("name", matchResult.group(1));
                    parsedBlock.put("version", matchResult.group(3));
                    string5 = matchResult.group(4);
                    String string8 = matchResult.group(5);
                    parsedBlock.put("vendor", "Sun Microsystems, Inc.");
                    String string9 = null;
                    String string10 = matchResult.group(2);
                    if (string5 != null) {
                        if (string8 != null) {
                            string5 = String.valueOf(string5) + string8.toUpperCase();
                        }
                    } else {
                        matchResult = inputFile2.matchRegexp("netscapeVersionPattern", string4);
                        if (matchResult != null) {
                            string5 = matchResult.group(3);
                        }
                        if (string5 == null) {
                            string5 = "";
                        }
                    }
                    parsedBlock.put("servicePack", string5);
                    if ("iPlanet".equals(string10)) {
                        string9 = "SUNWwt";
                    } else if ("Netscape".equals(string10)) {
                        string9 = "NSCP";
                    } else {
                        if (!bl) break;
                        stringBuffer.append("ParseVersionFiles(,," + string2 + ",): Cannot determine vendor from ");
                        stringBuffer.append(String.valueOf(string3) + "\n");
                        break;
                    }
                    if (bl4) {
                        string9 = String.valueOf(string9) + "ms";
                    } else if (bl3) {
                        string9 = String.valueOf(string9) + "ds";
                    } else if (bl6) {
                        string9 = String.valueOf(string9) + "ws";
                    }
                    parsedBlock.put("packageId", string9);
                    break;
                }
                matchResult = inputFile2.matchRegexp("netscapeVersionPattern", string4);
                if (matchResult == null) continue;
                parsedBlock.put("name", matchResult.group(1));
                parsedBlock.put("version", matchResult.group(2));
                string5 = matchResult.group(3);
                if (string5 == null) {
                    string5 = "";
                }
                parsedBlock.put("servicePack", string5);
                parsedBlock.put("vendor", "Sun Microsystems, Inc.");
                parsedBlock.put("packageId", "NSCPms");
                break;
            }
            inputFile2.close();
        }
        catch (Exception exception) {
            return false;
        }
        return parsedBlock.containsKey("version");
    }

    private void parseWebServers(File file, Vector vector, StringBuffer stringBuffer) {
        boolean bl;
        boolean bl2 = bl = stringBuffer != null;
        if (bl) {
            stringBuffer.append("EDParse_iPlanetHostPackage.parseWebServers(,,) called\n");
        }
        String string = file.getPath();
        File[] fileArray = file.listFiles();
        if (fileArray.length == 0) {
            return;
        }
        int n = 0;
        while (n < fileArray.length) {
            File file2 = fileArray[n];
            String string2 = file2.getPath();
            String string3 = file2.getName();
            if (bl) {
                stringBuffer.append("..Server root " + string2 + "\n");
            }
            if (!file2.isDirectory()) {
                if (bl) {
                    stringBuffer.append(String.valueOf(string2) + " is not a directory\n");
                }
            } else {
                ParsedBlock parsedBlock;
                if (bl) {
                    stringBuffer.append(String.valueOf(string2) + " is a Web server root\n");
                }
                if (!this.parseVersionFiles(string2, parsedBlock = new ParsedBlock("PackageInstance"), "Web", stringBuffer)) {
                    if (bl) {
                        stringBuffer.append("No version found in " + string2 + "\n");
                    }
                } else {
                    String string4 = (String)parsedBlock.get("packageId");
                    String string5 = (String)parsedBlock.get("vendor");
                    String string6 = (String)parsedBlock.get("version");
                    String string7 = (String)parsedBlock.get("servicePack");
                    String string8 = (String)parsedBlock.get("name");
                    if ("iPlanet-WebServer".equals(string8)) {
                        string8 = "iPlanet Web Server";
                    } else if ("Netscape-WebServer".equals(string8)) {
                        string8 = "Netscape Web Server";
                    }
                    File[] fileArray2 = file2.listFiles();
                    int n2 = 0;
                    while (n2 < fileArray2.length) {
                        File file3 = fileArray2[n2];
                        if (file3.isDirectory()) {
                            String string9 = file3.getName();
                            String string10 = null;
                            if (string9.startsWith("https-")) {
                                string10 = String.valueOf(string3) + '_' + string9;
                                ParsedBlock parsedBlock2 = new ParsedBlock("PackageInstance");
                                parsedBlock2.put("packageId", string4);
                                parsedBlock2.put("instanceName", string10);
                                parsedBlock2.put("instancePath", file3.getPath().substring(this.path().length() + 1));
                                parsedBlock2.put("installDirectory", String.valueOf(File.separator) + string10.replace('_', File.separatorChar));
                                parsedBlock2.put("name", string8);
                                parsedBlock2.put("version", string6);
                                parsedBlock2.put("vendor", string5);
                                if (string7 != null) {
                                    parsedBlock2.put("servicePack", string7);
                                }
                                vector.add(parsedBlock2);
                            }
                        }
                        ++n2;
                    }
                }
            }
            ++n;
        }
    }

    private void processPkgaddServers(File file, Map map, Vector vector, StringBuffer stringBuffer) {
        boolean bl;
        boolean bl2 = bl = stringBuffer != null;
        if (bl) {
            stringBuffer.append("EDParse_iPlanetHostPackage.parsePkgAddServers(,,) called\n");
        }
        String string = file.getPath();
        File[] fileArray = file.listFiles();
        if (fileArray.length == 0) {
            return;
        }
        String string2 = null;
        String string3 = null;
        boolean bl3 = false;
        boolean bl4 = false;
        if (string.endsWith("/iplanet/Web")) {
            string2 = "SUNWwtws";
            bl3 = true;
            string3 = string.substring(0, string.length() - 12);
        } else if (string.endsWith("/iplanet/Directory")) {
            string2 = "SUNWwtds";
            bl4 = true;
            string3 = string.substring(0, string.length() - 18);
        }
        if (bl) {
            stringBuffer.append("processPkgaddServers: packageId=" + string2);
            stringBuffer.append("  explorerPath=" + string3 + "\n");
        }
        ParsedBlock parsedBlock = null;
        if (string2 != null && map != null && map.containsKey(string2)) {
            parsedBlock = (ParsedBlock)map.get(string2);
        }
        if (parsedBlock == null) {
            if (bl) {
                stringBuffer.append("EDParse_iPlanetHostPackage.processPkgaddServers: Cannot get common ParsedBlock for" + string2 + "\n");
            }
            return;
        }
        if (bl) {
            stringBuffer.append("pbCommon=" + parsedBlock.toString() + "\n");
        }
        String string4 = (String)parsedBlock.get("vendor");
        String string5 = (String)parsedBlock.get("version");
        String string6 = (String)parsedBlock.get("servicePack");
        String string7 = (String)parsedBlock.get("name");
        String string8 = (String)parsedBlock.get("basedir");
        int n = 0;
        while (n < fileArray.length) {
            File file2 = fileArray[n];
            String string9 = file2.getPath();
            String string10 = file2.getName();
            if (bl) {
                stringBuffer.append("..Server instance " + string9 + "\n");
            }
            if (!file2.isDirectory()) {
                if (bl) {
                    stringBuffer.append(String.valueOf(string9) + " is not a directory\n");
                }
            } else {
                File[] fileArray2 = file2.listFiles();
                int n2 = 0;
                while (n2 < fileArray2.length) {
                    File file3 = fileArray2[n2];
                    if (file3.isDirectory()) {
                        String string11 = file3.getName();
                        String string12 = null;
                        if (bl3 && string11.startsWith("https-")) {
                            string12 = String.valueOf(string10) + File.separator + string11;
                        } else if (bl4 && string11.startsWith("slapd-")) {
                            string12 = String.valueOf(string10) + '_' + string11;
                        }
                        if (string12 != null) {
                            ParsedBlock parsedBlock2 = new ParsedBlock("PackageInstance");
                            parsedBlock2.put("instanceName", string12);
                            parsedBlock2.put("packageId", string2);
                            parsedBlock2.put("name", string7);
                            parsedBlock2.put("vendor", string4);
                            parsedBlock2.put("version", string5);
                            if (string6 != null) {
                                parsedBlock2.put("servicePack", string6);
                            }
                            parsedBlock2.put("instancePath", file3.getPath().substring(this.path().length() + 1));
                            parsedBlock2.put("installDirectory", String.valueOf(File.separator) + string12.replace('_', File.separatorChar));
                            if (string8 != null) {
                                parsedBlock2.put("baseDirectory", string8);
                            }
                            vector.add(parsedBlock2);
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }
}

