/*
 * Decompiled with CFR 0.152.
 */
package com.sun.eras.parsers.explorerDir;

import com.sun.eras.common.util.MessageKey;
import com.sun.eras.common.util.MessageLocalizer;
import com.sun.eras.parsers.EntityParserImpl;
import com.sun.eras.parsers.ParsedBlock;
import com.sun.eras.parsers.ParserException;
import com.sun.eras.parsers.explorerDir.ExplorerDirEntityParser;
import com.sun.eras.parsers.explorerDir.FileIOException;
import com.sun.eras.parsers.explorerDir.FileParseException;
import com.sun.eras.parsers.inputFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;

public class EDParse_Sonoma
extends ExplorerDirEntityParser
implements EntityParserImpl {
    private static final MessageKey NO_PATTERN = new MessageKey("no_pattern");
    private static final String ladContentPattern = "\\s*^(c\\S+)\\s+(\\S+)\\s+(LUNS:.+)\\s*$";
    private static final String raidutil_iLUNs_foundPattern = "^\\s*LUNs.*found\\s+on\\s+(\\S+)\\.\\S*$";
    private static final String raidutil_iLUNPattern = "^\\s*(LUN\\s+\\d+\\s+RAID\\s+\\d+\\s+\\d+\\s+MB)\\s*$";
    private static final String raidutil_iNoLUNsPattern = "^\\s*No existing LUNs were found on\\s+(\\S+)\\.\\S*$";
    private static final String raidutil_iAttValPattern = "^(Vendor ID|ProductID|Product Revision|Boot Level Date|Boot Level|Firmware Level|Software Version|Firmware Date|Fibre Level)\\s+(.*)$";
    private static final String emptyLinePattern = "^\\s*$";
    private static final Map raidutil_iSlotName = new HashMap();
    private static final int raidutil_iNone = 0;
    private static final int raidutil_iLUNsfoundFound = 1;
    private static final int raidutil_iRAIDdata = 2;
    private static final String drivutil_iHeadingPattern = "^(\\s*Location\\s+)(Capacity\\s+)(Status\\s+)(Vendor\\s+)(Product\\s+)(Firmware\\s+)Serial";
    private static final String rdacutil_iRaidModulePattern = "^(\\S+):\\s*(\\S+)";
    private static final String rdacutil_iAxxRaidModulePattern = "^(\\S+)\\s+(\\S+):\\s*(\\S+)";
    private static final String rdacutil_iContentPattern = "^\\s*(\\S+)\\s+controller\\s+(\\S+)\\s+\\(([^\\(\\)]+)\\)\\s+units:\\s+([\\d+\\s+]+)";

    static {
        raidutil_iSlotName.put("Vendor ID", "vendorId");
        raidutil_iSlotName.put("ProductID", "productId");
        raidutil_iSlotName.put("Product Revision", "productRev");
        raidutil_iSlotName.put("Boot Level", "bootLevel");
        raidutil_iSlotName.put("Boot Level Date", "bootLevelDate");
        raidutil_iSlotName.put("Firmware Level", "firmLevel");
        raidutil_iSlotName.put("Software Version", "softwareVersion");
        raidutil_iSlotName.put("Firmware Date", "firmDate");
        raidutil_iSlotName.put("Fibre Level", "fibreLevel");
    }

    public EDParse_Sonoma(String string) {
        super(string);
    }

    private String generateContentPattern(MatchResult matchResult) {
        StringBuffer stringBuffer = new StringBuffer("^(\\[(\\d+),(\\d+)\\])\\s+");
        int n = 2;
        while (n < 7) {
            String string = matchResult.group(n);
            if (string == null) {
                return null;
            }
            stringBuffer.append("(.{");
            stringBuffer.append(new Integer(string.length()).toString());
            stringBuffer.append("})");
            ++n;
        }
        stringBuffer.append("(.+)$");
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        ExplorerDirEntityParser.testExplorerDirEntityParser("EDParse_Sonoma", stringArray);
    }

    public Vector parse() throws ParserException {
        Object object;
        Object object2;
        Object object3;
        ArrayList<Object> arrayList;
        Object object4;
        Object object5;
        Object object6;
        String string;
        Object object7;
        Object object8;
        Object object9;
        Vector<Object> vector = new Vector<Object>();
        ParsedBlock parsedBlock = null;
        StringBuffer stringBuffer = null;
        if (this.trace) {
            parsedBlock = new ParsedBlock("TRACE");
            vector.add(parsedBlock);
            stringBuffer = new StringBuffer("EDParse_Sonoma.parse() called for explorer path ");
            stringBuffer.append(this.path());
            stringBuffer.append("\n");
        }
        String string2 = null;
        MatchResult matchResult = null;
        String string3 = String.valueOf(this.path()) + "/disks/sonoma/lad.out";
        try {
            object9 = new inputFile(string3);
            object8 = ((inputFile)object9).reader();
            ((inputFile)object9).defineRegexp("lad data", ladContentPattern);
            while ((string2 = ((BufferedReader)object8).readLine()) != null) {
                matchResult = ((inputFile)object9).matchRegexp("lad data", string2);
                if (matchResult == null) continue;
                object7 = new ParsedBlock("SonomaLad");
                vector.add(object7);
                ((ParsedBlock)object7).put("sonomaCTDId", matchResult.group(1));
                ((ParsedBlock)object7).put("data", matchResult.group(2));
                ((ParsedBlock)object7).put("luns", matchResult.group(3));
            }
            ((inputFile)object9).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (this.trace) {
                stringBuffer.append("FileNotFound: ");
                stringBuffer.append(string3);
                stringBuffer.append("\n");
            }
        }
        catch (IOException iOException) {
            throw new FileIOException(string3, "EDParse_Sonoma.parse", iOException);
        }
        catch (MalformedPatternException malformedPatternException) {
            throw new FileParseException(string3, "EDParse_Sonoma.parse", malformedPatternException);
        }
        object9 = String.valueOf(this.path()) + "/disks/sonoma/raidutil-i";
        object8 = new File((String)object9);
        object7 = ((File)object8).list();
        ParsedBlock parsedBlock2 = null;
        int n = 0;
        while (object7 != null && n < ((String[])object7).length) {
            string = object7[n];
            string3 = String.valueOf(object9) + "/" + string;
            try {
                object6 = new inputFile(string3);
                object5 = ((inputFile)object6).reader();
                ((inputFile)object6).defineRegexp("LUNs found", raidutil_iLUNs_foundPattern);
                ((inputFile)object6).defineRegexp("LUN data", raidutil_iLUNPattern);
                ((inputFile)object6).defineRegexp("No LUNs", raidutil_iNoLUNsPattern);
                ((inputFile)object6).defineRegexp("RAID att-val", raidutil_iAttValPattern);
                ((inputFile)object6).defineRegexp("empty", emptyLinePattern);
                int n2 = 0;
                StringBuffer stringBuffer2 = new StringBuffer();
                boolean bl = false;
                while ((string2 = ((BufferedReader)object5).readLine()) != null) {
                    if (n2 == 0 && (matchResult = ((inputFile)object6).matchRegexp("LUNs found", string2)) != null) {
                        parsedBlock2 = new ParsedBlock("SonomaRaidutilCtd");
                        vector.add(parsedBlock2);
                        parsedBlock2.put("sonomaCTDId", matchResult.group(1));
                        n2 = 1;
                        continue;
                    }
                    if (n2 == 0 && (matchResult = ((inputFile)object6).matchRegexp("No LUNs", string2)) != null) {
                        parsedBlock2 = new ParsedBlock("SonomaRaidutilCtd");
                        vector.add(parsedBlock2);
                        parsedBlock2.put("sonomaCTDId", matchResult.group(1));
                        n2 = 2;
                        continue;
                    }
                    if (n2 == 1 && (matchResult = ((inputFile)object6).matchRegexp("LUN data", string2)) != null) {
                        bl = true;
                        stringBuffer2.append(matchResult.group(1));
                        stringBuffer2.append("\n");
                        continue;
                    }
                    if (n2 == 1 && (matchResult = ((inputFile)object6).matchRegexp("empty", string2)) != null) {
                        parsedBlock2.put("lunsWithRaid", stringBuffer2.toString());
                        n2 = 2;
                        continue;
                    }
                    if (n2 != 2 || (matchResult = ((inputFile)object6).matchRegexp("RAID att-val", string2)) == null) continue;
                    parsedBlock2.put((String)raidutil_iSlotName.get(matchResult.group(1)), matchResult.group(2).trim());
                }
                ((inputFile)object6).close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (this.trace) {
                    stringBuffer.append("FileNotFound exception for ");
                    stringBuffer.append(string3);
                    stringBuffer.append("\n");
                }
            }
            catch (IOException iOException) {
                throw new FileIOException(string3, "EDParse_Sonoma.parse", iOException);
            }
            catch (MalformedPatternException malformedPatternException) {
                throw new FileParseException(string3, "EDParse_Sonoma.parse", malformedPatternException);
            }
            ++n;
        }
        string = String.valueOf(this.path()) + "/disks/sonoma/drivutil-i";
        object6 = new File(string);
        object5 = ((File)object6).list();
        Object var15_20 = null;
        int n3 = 0;
        while (object5 != null && n3 < ((String[])object5).length) {
            String string4 = object5[n3];
            object4 = string4;
            if (string4.endsWith(".out")) {
                object4 = string4.substring(0, string4.length() - 4);
            }
            string3 = String.valueOf(string) + "/" + string4;
            ParsedBlock parsedBlock3 = new ParsedBlock("enclosure");
            vector.add(parsedBlock3);
            parsedBlock3.put("name", object4);
            arrayList = new ArrayList<Object>();
            parsedBlock3.put("disks", arrayList);
            try {
                object3 = new inputFile(string3);
                object2 = ((inputFile)object3).reader();
                ((inputFile)object3).defineRegexp("column headings", drivutil_iHeadingPattern);
                boolean bl = false;
                while ((string2 = ((BufferedReader)object2).readLine()) != null) {
                    if (!bl && (matchResult = ((inputFile)object3).matchRegexp("column headings", string2)) != null) {
                        object = this.generateContentPattern(matchResult);
                        if (this.trace) {
                            stringBuffer.append("..for filepath ");
                            stringBuffer.append(string3);
                            stringBuffer.append(" contentPattern=\"");
                            stringBuffer.append((String)object);
                            stringBuffer.append("\"\n");
                        }
                        if (object == null) {
                            throw new IOException(MessageLocalizer.makeLMS((Object)this, (MessageKey)NO_PATTERN, (String)("Cannot generate content pattern for file " + string3), (Object[])new Object[]{string3}, null));
                        }
                        ((inputFile)object3).defineRegexp("drive content", this.generateContentPattern(matchResult));
                        bl = true;
                        continue;
                    }
                    if (!bl || (matchResult = ((inputFile)object3).matchRegexp("drive content", string2)) == null) continue;
                    object = new ParsedBlock("drivutil");
                    ((ParsedBlock)object).put("location", matchResult.group(1));
                    ((ParsedBlock)object).put("sonomaDriveId", matchResult.group(1));
                    ((ParsedBlock)object).put("tray", matchResult.group(2));
                    ((ParsedBlock)object).put("target", matchResult.group(3));
                    ((ParsedBlock)object).put("capacity", matchResult.group(4).trim());
                    ((ParsedBlock)object).put("status", matchResult.group(5).trim());
                    ((ParsedBlock)object).put("vendor", matchResult.group(6).trim());
                    ((ParsedBlock)object).put("productId", matchResult.group(7).trim());
                    ((ParsedBlock)object).put("firmwareVer", matchResult.group(8).trim());
                    ((ParsedBlock)object).put("serialNum", matchResult.group(9).trim());
                    arrayList.add(object);
                }
                ((inputFile)object3).close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (this.trace) {
                    stringBuffer.append("FileNotFound exception for ");
                    stringBuffer.append(string3);
                }
            }
            catch (IOException iOException) {
                throw new FileIOException(string3, "EDParse_Sonoma.parse", iOException);
            }
            catch (MalformedPatternException malformedPatternException) {
                throw new FileParseException(string3, "EDParse_Sonoma.parse", malformedPatternException);
            }
            ++n3;
        }
        String string5 = String.valueOf(this.path()) + "/disks/sonoma/rdacutil-i";
        object4 = new File(string5);
        object5 = ((File)object4).list();
        string2 = null;
        matchResult = null;
        int n4 = 0;
        while (object5 != null && n4 < ((String[])object5).length) {
            arrayList = object5[n4];
            object3 = arrayList;
            if (((String)((Object)arrayList)).endsWith(".out")) {
                object3 = ((String)((Object)arrayList)).substring(0, ((String)((Object)arrayList)).length() - 4);
            }
            string3 = String.valueOf(string5) + "/" + arrayList;
            if (this.trace) {
                stringBuffer.append("..Parsing rdacutil-i/");
                stringBuffer.append((String)((Object)arrayList));
            }
            object2 = null;
            Iterator iterator = ((AbstractList)vector).iterator();
            while (iterator.hasNext()) {
                object = (ParsedBlock)iterator.next();
                if (!"enclosure".equals(((ParsedBlock)object).name()) || !((String)object3).equals((String)((ParsedBlock)object).get("name"))) continue;
                if (this.trace) {
                    stringBuffer.append(" reusing enclosure ParsedBlock for ");
                    stringBuffer.append((String)object3);
                    stringBuffer.append("\n");
                }
                object2 = object;
                break;
            }
            if (object2 == null) {
                if (this.trace) {
                    stringBuffer.append("..creating new enclosure ParsedBlock for ");
                    stringBuffer.append((String)object3);
                    stringBuffer.append("\n");
                }
                object2 = new ParsedBlock("enclosure");
                vector.add(object2);
                ((ParsedBlock)object2).put("name", object3);
            }
            object = new ArrayList();
            ((ParsedBlock)object2).put("controllers", object);
            try {
                inputFile inputFile2 = new inputFile(string3);
                BufferedReader bufferedReader = inputFile2.reader();
                inputFile2.defineRegexp("controller data", rdacutil_iContentPattern);
                inputFile2.defineRegexp("Raid module", rdacutil_iRaidModulePattern);
                inputFile2.defineRegexp("AxxRaid module", rdacutil_iAxxRaidModulePattern);
                while ((string2 = bufferedReader.readLine()) != null) {
                    ParsedBlock parsedBlock4;
                    matchResult = inputFile2.matchRegexp("Raid module", string2);
                    if (matchResult != null) {
                        parsedBlock4 = new ParsedBlock("raidModule");
                        parsedBlock4.put("name", matchResult.group(1));
                        parsedBlock4.put("controllerType", matchResult.group(2));
                        ((ParsedBlock)object2).put("raidModule", parsedBlock4);
                        continue;
                    }
                    matchResult = inputFile2.matchRegexp("AxxRaid module", string2);
                    if (matchResult != null) {
                        parsedBlock4 = new ParsedBlock("raidModule");
                        parsedBlock4.put("name", matchResult.group(2));
                        parsedBlock4.put("controllerType", matchResult.group(3));
                        parsedBlock4.put("raidType", matchResult.group(1));
                        ((ParsedBlock)object2).put("raidModule", parsedBlock4);
                        continue;
                    }
                    matchResult = inputFile2.matchRegexp("controller data", string2);
                    if (matchResult == null) continue;
                    parsedBlock4 = new ParsedBlock("rdacutil");
                    parsedBlock4.put("status", matchResult.group(1));
                    parsedBlock4.put("name", matchResult.group(2));
                    parsedBlock4.put("ctd", matchResult.group(3));
                    parsedBlock4.put("sonomaControllerId", matchResult.group(3));
                    parsedBlock4.put("luns", matchResult.group(4).trim());
                    object.add(parsedBlock4);
                }
                inputFile2.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (this.trace) {
                    stringBuffer.append("FileNotFound exception for ");
                    stringBuffer.append(string3);
                }
            }
            catch (IOException iOException) {
                throw new FileIOException(string3, "EDParse_Sonoma.parse", iOException);
            }
            catch (MalformedPatternException malformedPatternException) {
                throw new FileParseException(string3, "EDParse_Sonoma.parse", malformedPatternException);
            }
            ++n4;
        }
        if (this.trace) {
            parsedBlock.put("trace", stringBuffer.toString());
        }
        return vector;
    }
}

