/*
 * Decompiled with CFR 0.152.
 */
package com.sun.eras.parsers.explorerDir;

import com.sun.eras.parsers.EntityParserImpl;
import com.sun.eras.parsers.ParsedBlock;
import com.sun.eras.parsers.ParserException;
import com.sun.eras.parsers.explorerDir.ExplorerDirEntityParser;
import com.sun.eras.parsers.explorerDir.FileIOException;
import com.sun.eras.parsers.explorerDir.FileParseException;
import com.sun.eras.parsers.inputFile;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import org.apache.oro.text.regex.MalformedPatternException;

public class EDParse_HostCpu
extends ExplorerDirEntityParser
implements EntityParserImpl {
    private static String CPUColumnHeader_1 = "^Brd\\s+CPU\\s+Module\\s+MHz\\s+MB\\s+Impl\\.\\s+Mask";
    private static String CPUColumnHeader_2 = "^FRU Name\\s+ID\\s+MHz\\s+MB\\s+Impl\\.\\s+Mask";
    private static String CPUColumnHeader_3 = "^Brd\\s+CPU\\s+MHz\\s+MB\\s+Impl\\.\\s+Mask";
    private static String CPUColumnHeader_4a = "^\\s*CPU Units: Frequency Cache-Size Version";
    private static String CPUColumnHeader_4b = "^\\s*A: MHz  MB  Impl. Mask  B: MHz  MB  Impl. Mask";
    private static String SixColumnUnderlines = "^\\s*-+\\s+-+\\s+-+\\s+-+\\s+-+\\s+-+\\s*$";
    private static String SevenColumnUnderlines = "^\\s*-+\\s+-+\\s+-+\\s+-+\\s+-+\\s+-+\\s+-+\\s*$";
    private static String SpacesAndUnderlines = "^\\s*-+[\\s-]*$";
    private static String CPUContent_1 = "^\\s*(\\S+)\\s+(\\d+)\\s+\\d+\\s+(\\d+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)";
    private static String CPUContent_2 = "^\\s*(\\S+)\\s+(\\d+)\\s+(\\d+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)";
    private static String CPUContent_4_2 = "^\\s*Board\\s*(\\d+):\\s+(\\d+)\\s+([\\d.]+)\\s+(\\d+)\\s+([\\d.]+)\\s+(\\d+)\\s+([\\d.]+)\\s+(\\d+)\\s+([\\d.]+)";
    private static String CPUContent_4_1 = "^\\s*Board\\s*(\\d+):\\s+(\\d+)\\s+([\\d.]+)\\s+(\\d+)\\s+([\\d.]+)\\s*$";
    private static String PROMRevisionsHeader = "^System PROM revisions";
    private static String PROMRevisionContent_2 = "^\\s*(OBP|POST)\\s+([\\d.]+)[ \\d\\/:]*(POST|OBP)\\s+([\\d.]+)\\s";
    private static String PROMRevisionContent_1 = "^\\s*(OBP|POST)\\s+([\\d.]+)\\s";
    private static String BoardPROMRevisionsHeader = "^System Board PROM revisions";
    private static String BoardPROMRevisionContent_2 = "^Board\\s*(\\d+):\\s*(OBP|POST)\\s+([\\d.]+)[ \\d\\/:]*(OBP|POST)\\s+([\\d.]+)\\s";
    private static String BoardPROMRevisionContent_1 = "^Board\\s*(\\d+):\\s*(OBP|POST)\\s+([\\d.]+)\\s";
    private static String BoardPROMRevisionContent_0 = "^Board\\s*(\\d+):\\s";
    private static String ProcessorHeader = "Status of processor (\\d+)";
    private static String ProcessorStatus = "^\\s*Processor has been (\\S+) since";
    private static String ProcessorFrequency = "processor operates at (\\d+) MHz";
    private static String FloatingPointProcessor = "has a (\\S+) floating point processor";
    private static final int initial = 0;
    private static final int cpuColumnHeads = 1;
    private static final int cpuColumnHeads4a = 2;
    private static final int cpuColumnHeads4b = 3;
    private static final int sixColumnCpuData = 4;
    private static final int promRevisons = 1;
    private static final int boardPromRevisions = 2;
    private static final int finished = 99;

    public EDParse_HostCpu(String string) {
        super(string);
    }

    public Vector parse() throws ParserException {
        Object object;
        String string;
        Object object2;
        Object object3;
        Object object4;
        Vector<Object> vector = new Vector<Object>();
        String string2 = String.valueOf(this.path()) + "/sysconfig/prtdiag-v.out";
        ParsedBlock parsedBlock = null;
        StringBuffer stringBuffer = null;
        if (this.trace) {
            parsedBlock = new ParsedBlock("TRACE");
            vector.add(parsedBlock);
            stringBuffer = new StringBuffer("EDParse_HostCpu.parse() called\n");
        }
        boolean bl = true;
        try {
            if (this.trace) {
                stringBuffer.append("Processing HostCpu content in sysconfig/prtdiag-v.out:\n");
            }
            inputFile inputFile2 = new inputFile(string2);
            object4 = inputFile2.reader();
            inputFile2.defineRegexp("CPU Column Header 1", CPUColumnHeader_1);
            inputFile2.defineRegexp("CPU Column Header 2", CPUColumnHeader_2);
            inputFile2.defineRegexp("CPU Column Header 3", CPUColumnHeader_3);
            inputFile2.defineRegexp("CPU Column Header 4a", CPUColumnHeader_4a);
            inputFile2.defineRegexp("CPU Column Header 4b", CPUColumnHeader_4b);
            inputFile2.defineRegexp("Six Column Underlines", SixColumnUnderlines);
            inputFile2.defineRegexp("Seven Column Underlines", SevenColumnUnderlines);
            inputFile2.defineRegexp("Spaces And Underlines", SpacesAndUnderlines);
            inputFile2.defineRegexp("CPU Content 1", CPUContent_1);
            inputFile2.defineRegexp("CPU Content 2", CPUContent_2);
            inputFile2.defineRegexp("CPU Content 4/2", CPUContent_4_2);
            inputFile2.defineRegexp("CPU Content 4/1", CPUContent_4_1);
            inputFile2.defineRegexp("PROM Revisions Header", PROMRevisionsHeader);
            inputFile2.defineRegexp("PROM Revision Content 2", PROMRevisionContent_2);
            inputFile2.defineRegexp("PROM Revision Content 1", PROMRevisionContent_1);
            inputFile2.defineRegexp("Board PROM Revisions Header", BoardPROMRevisionsHeader);
            inputFile2.defineRegexp("Board PROM Revision Content 2", BoardPROMRevisionContent_2);
            inputFile2.defineRegexp("Board PROM Revision Content 1", BoardPROMRevisionContent_1);
            inputFile2.defineRegexp("Board PROM Revision Content 0", BoardPROMRevisionContent_0);
            object3 = "";
            object2 = null;
            int n = 0;
            int n2 = 0;
            while ((object3 = ((BufferedReader)object4).readLine()) != null) {
                int n3;
                if (n == 0 && ((string = inputFile2.matchRegexp("CPU Column Header 1", (String)object3)) != null || (string = inputFile2.matchRegexp("CPU Column Header 2", (String)object3)) != null || (string = inputFile2.matchRegexp("CPU Column Header 3", (String)object3)) != null)) {
                    n = 1;
                    continue;
                }
                if (n == 1 && (string = inputFile2.matchRegexp("Spaces And Underlines", (String)object3)) != null) continue;
                string = inputFile2.matchRegexp("CPU Column Header 4a", (String)object3);
                if (string != null) {
                    n = 2;
                    continue;
                }
                if (n == 2 && (string = inputFile2.matchRegexp("CPU Column Header 4b", (String)object3)) != null) {
                    n = 3;
                    continue;
                }
                if (n == 3 && (string = inputFile2.matchRegexp("Six Column Underlines", (String)object3)) != null) {
                    n = 4;
                    continue;
                }
                if (n == 1 && ((string = inputFile2.matchRegexp("CPU Content 1", (String)object3)) != null || (string = inputFile2.matchRegexp("CPU Content 2", (String)object3)) != null)) {
                    object2 = new ParsedBlock("HostCpu");
                    vector.add(object2);
                    ((ParsedBlock)object2).put("boardNumber", string.group(1));
                    ((ParsedBlock)object2).put("cpuNumber", string.group(2));
                    ((ParsedBlock)object2).put("cpuFrequency", string.group(3));
                    ((ParsedBlock)object2).put("ecacheSize", string.group(4));
                    ((ParsedBlock)object2).put("cpuType", string.group(5));
                    ((ParsedBlock)object2).put("cpuMask", string.group(6));
                    continue;
                }
                if (n == 4 && (string = inputFile2.matchRegexp("CPU Content 4/2", (String)object3)) != null) {
                    block45: {
                        object2 = new ParsedBlock("HostCpu");
                        vector.add(object2);
                        n3 = -1;
                        object = string.group(1);
                        try {
                            n3 = 2 * Integer.parseInt((String)object);
                        }
                        catch (NumberFormatException numberFormatException) {
                            if (!this.trace) break block45;
                            stringBuffer.append("CPU board \"" + (String)object + "\" NumberFormatException\n");
                        }
                    }
                    ((ParsedBlock)object2).put("boardNumber", object);
                    if (n3 >= 0) {
                        ((ParsedBlock)object2).put("cpuNumber", Integer.toString(n3));
                    }
                    ((ParsedBlock)object2).put("cpuLetter", "A");
                    ((ParsedBlock)object2).put("cpuFrequency", string.group(2));
                    ((ParsedBlock)object2).put("ecacheSize", string.group(3));
                    ((ParsedBlock)object2).put("cpuType", string.group(4));
                    ((ParsedBlock)object2).put("cpuMask", string.group(5));
                    object2 = new ParsedBlock("HostCpu");
                    vector.add(object2);
                    ((ParsedBlock)object2).put("boardNumber", object);
                    if (n3 >= 0) {
                        ((ParsedBlock)object2).put("cpuNumber", Integer.toString(n3 + 1));
                    }
                    ((ParsedBlock)object2).put("cpuLetter", "B");
                    ((ParsedBlock)object2).put("cpuFrequency", string.group(6));
                    ((ParsedBlock)object2).put("ecacheSize", string.group(7));
                    ((ParsedBlock)object2).put("cpuType", string.group(8));
                    ((ParsedBlock)object2).put("cpuMask", string.group(9));
                    continue;
                }
                if (n == 4 && (string = inputFile2.matchRegexp("CPU Content 4/1", (String)object3)) != null) {
                    block46: {
                        object2 = new ParsedBlock("HostCpu");
                        vector.add(object2);
                        n3 = -1;
                        object = string.group(1);
                        try {
                            n3 = 2 * Integer.parseInt((String)object);
                        }
                        catch (NumberFormatException numberFormatException) {
                            if (!this.trace) break block46;
                            stringBuffer.append("CPU board \"" + (String)object + "\" NumberFormatException\n");
                        }
                    }
                    ((ParsedBlock)object2).put("boardNumber", object);
                    if (n3 >= 0) {
                        ((ParsedBlock)object2).put("cpuNumber", Integer.toString(n3));
                    }
                    ((ParsedBlock)object2).put("cpuLetter", "A");
                    ((ParsedBlock)object2).put("cpuFrequency", string.group(2));
                    ((ParsedBlock)object2).put("ecacheSize", string.group(3));
                    ((ParsedBlock)object2).put("cpuType", string.group(4));
                    ((ParsedBlock)object2).put("cpuMask", string.group(5));
                    continue;
                }
                if (n > 0 && n < 99 && (string = inputFile2.matchRegexp("Spaces And Underlines", (String)object3)) == null) {
                    n = 99;
                    continue;
                }
                if (n2 == 0 && (string = inputFile2.matchRegexp("PROM Revisions Header", (String)object3)) != null) {
                    n2 = 1;
                    continue;
                }
                if (n2 == 0 && (string = inputFile2.matchRegexp("Board PROM Revisions Header", (String)object3)) != null) {
                    n2 = 2;
                    continue;
                }
                if (n2 == 1 && (string = inputFile2.matchRegexp("PROM Revision Content 2", (String)object3)) != null) {
                    object2 = new ParsedBlock("HostCpuBoard");
                    vector.add(object2);
                    ((ParsedBlock)object2).put("boardNumber", "ALL");
                    ((ParsedBlock)object2).put(string.group(1), string.group(2));
                    ((ParsedBlock)object2).put(string.group(3), string.group(4));
                    continue;
                }
                if (n2 == 1 && (string = inputFile2.matchRegexp("PROM Revision Content 1", (String)object3)) != null) {
                    object2 = new ParsedBlock("HostCpuBoard");
                    vector.add(object2);
                    ((ParsedBlock)object2).put("boardNumber", "ALL");
                    ((ParsedBlock)object2).put(string.group(1), string.group(2));
                    continue;
                }
                if (n2 == 2 && (string = inputFile2.matchRegexp("Board PROM Revision Content 2", (String)object3)) != null) {
                    object2 = new ParsedBlock("HostCpuBoard");
                    vector.add(object2);
                    ((ParsedBlock)object2).put("boardNumber", string.group(1));
                    ((ParsedBlock)object2).put(string.group(2), string.group(3));
                    ((ParsedBlock)object2).put(string.group(4), string.group(5));
                    continue;
                }
                if (n2 == 2 && (string = inputFile2.matchRegexp("Board PROM Revision Content 1", (String)object3)) != null) {
                    object2 = new ParsedBlock("HostCpuBoard");
                    vector.add(object2);
                    ((ParsedBlock)object2).put("boardNumber", string.group(1));
                    ((ParsedBlock)object2).put(string.group(2), string.group(3));
                    continue;
                }
                if (n2 == 2 && (string = inputFile2.matchRegexp("Board PROM Revision Content 0", (String)object3)) != null || n2 <= 0 || n2 >= 99 || (string = inputFile2.matchRegexp("Spaces And Underlines", (String)object3)) != null) continue;
                n2 = 99;
            }
            ((BufferedReader)object4).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            bl = false;
            if (this.trace) {
                stringBuffer.append("EDParse_HostCpu FileNotFoundException for sysconfig/prtdiag-v.out:\n");
            }
        }
        catch (IOException iOException) {
            throw new FileIOException(string2, "EDParse_HostCpu.parse", iOException);
        }
        catch (MalformedPatternException malformedPatternException) {
            throw new FileParseException(string2, "EDParse_HostCpu.parse", malformedPatternException);
        }
        boolean bl2 = true;
        try {
            if (this.trace) {
                stringBuffer.append("Processing HostCpu content in sysconfig/psrinfo-v.out:\n");
            }
            string2 = String.valueOf(this.path()) + "/sysconfig/psrinfo-v.out";
            object4 = new inputFile(string2);
            object3 = ((inputFile)object4).reader();
            ((inputFile)object4).defineRegexp("Processor Header", ProcessorHeader);
            ((inputFile)object4).defineRegexp("Processor Status", ProcessorStatus);
            ((inputFile)object4).defineRegexp("Processor Frequency", ProcessorFrequency);
            ((inputFile)object4).defineRegexp("Floating Point Processor", FloatingPointProcessor);
            string = "";
            ParsedBlock parsedBlock2 = null;
            while ((string = ((BufferedReader)object3).readLine()) != null) {
                object2 = ((inputFile)object4).matchRegexp("Processor Header", string);
                if (object2 != null) {
                    String string3 = object2.group(1);
                    parsedBlock2 = null;
                    Iterator iterator = ((AbstractList)vector).iterator();
                    while (iterator.hasNext()) {
                        object = (ParsedBlock)iterator.next();
                        if (!((ParsedBlock)object).containsKey("cpuNumber") || !((String)((ParsedBlock)object).get("cpuNumber")).equals(string3)) continue;
                        if (this.trace) {
                            stringBuffer.append("..Updating current HostCpu for cpuNumber=\"");
                            stringBuffer.append(String.valueOf(string3) + "\"\n");
                        }
                        parsedBlock2 = object;
                        break;
                    }
                    if (parsedBlock2 != null) continue;
                    if (this.trace) {
                        stringBuffer.append("..Creating new HostCpu for cpuNumber=\"");
                        stringBuffer.append(String.valueOf(string3) + "\"\n");
                    }
                    parsedBlock2 = new ParsedBlock("HostCpu");
                    vector.add(parsedBlock2);
                    parsedBlock2.put("cpuNumber", string3);
                    continue;
                }
                object2 = ((inputFile)object4).matchRegexp("Processor Status", string);
                if (object2 != null && parsedBlock2 != null) {
                    parsedBlock2.put("cpuStatus", object2.group(1));
                    continue;
                }
                object2 = ((inputFile)object4).matchRegexp("Processor Frequency", string);
                if (object2 != null && parsedBlock2 != null) {
                    parsedBlock2.put("cpuFrequency", object2.group(1));
                    continue;
                }
                object2 = ((inputFile)object4).matchRegexp("Floating Point Processor", string);
                if (object2 == null || parsedBlock2 == null) continue;
                parsedBlock2.put("fppType", object2.group(1));
            }
            ((BufferedReader)object3).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            bl2 = false;
            if (this.trace) {
                stringBuffer.append("EDParse_HostCpu FileNotFoundException for sysconfig/psrinfo-v.out:\n");
            }
        }
        catch (IOException iOException) {
            throw new FileIOException(string2, "EDParse_HostCpu.parse", iOException);
        }
        catch (MalformedPatternException malformedPatternException) {
            throw new FileParseException(string2, "EDParse_HostCpu.parse", malformedPatternException);
        }
        if (!bl && !bl2) {
            if (this.trace) {
                stringBuffer.append("EDParse_HostCpu: Neither sysconfig/prtdiag-v.out nor sysconfig/psrinfo-v.out was found.\n");
            }
            throw new FileIOException(FileIOException.NOT_FOUND, "Neither sysconfig/prtdiag-v.out nor sysconfig/psrinfo-v.out was found.", new Object[]{"sysconfig/prtdiag-v.out, sysconfig/psrinfo-v.out", "EDParse_HostCpu.parse"}, null, null);
        }
        if (this.trace) {
            parsedBlock.put("trace", stringBuffer.toString());
        }
        return vector;
    }
}

