/*
 * Decompiled with CFR 0.152.
 */
package com.sun.eras.parsers.explorerDir;

import com.sun.eras.parsers.EntityParserImpl;
import com.sun.eras.parsers.ParsedBlock;
import com.sun.eras.parsers.ParserException;
import com.sun.eras.parsers.explorerDir.ExplorerDirEntityParser;
import com.sun.eras.parsers.explorerDir.FileIOException;
import com.sun.eras.parsers.explorerDir.FileParseException;
import com.sun.eras.parsers.inputFile;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Vector;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;

public class EDParseT3DiskversionOut
extends ExplorerDirEntityParser
implements EntityParserImpl {
    public EDParseT3DiskversionOut(String string) {
        super(string);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.err.println("Usage: java VerOut explorerPath");
            System.exit(1);
            return;
        }
        try {
            EDParseT3DiskversionOut eDParseT3DiskversionOut = new EDParseT3DiskversionOut(stringArray[0]);
            Vector vector = eDParseT3DiskversionOut.parse("/disks/t3/t301/disk_version_u2d1-9.out");
            EDParseT3DiskversionOut.printBlocks(vector);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
            return;
        }
    }

    public Vector parse(String string) throws ParserException {
        Vector<ParsedBlock> vector = new Vector<ParsedBlock>();
        String string2 = this.path().concat(string);
        try {
            inputFile inputFile2 = new inputFile(string2);
            inputFile2.defineRegexp("line", "^(u\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)$");
            BufferedReader bufferedReader = inputFile2.reader();
            String string3 = "";
            while ((string3 = bufferedReader.readLine()) != null) {
                MatchResult matchResult = inputFile2.matchRegexp("line", string3);
                if (matchResult == null) continue;
                ParsedBlock parsedBlock = new ParsedBlock("T3Diskversion");
                vector.add(parsedBlock);
                parsedBlock.put("diskId", matchResult.group(1));
                parsedBlock.put("vendor", matchResult.group(2));
                parsedBlock.put("product", matchResult.group(3));
                parsedBlock.put("revision", matchResult.group(4));
                parsedBlock.put("serial_no", matchResult.group(5).trim());
                parsedBlock.put("fw_rev", matchResult.group(6));
                parsedBlock.put("rom_rev", matchResult.group(7));
            }
        }
        catch (IOException iOException) {
            throw new FileIOException(string2, "EDParseT3DiskversionOut.parse", iOException);
        }
        catch (MalformedPatternException malformedPatternException) {
            throw new FileParseException(string2, "EDParseT3DiskversionOut.parse", malformedPatternException);
        }
        return vector;
    }

    public static void printBlocks(Vector vector) {
        if (vector == null || vector.size() == 0) {
            System.out.println("No blocks!");
            return;
        }
        System.out.println(String.valueOf(vector.size()) + " blocks parsed.");
        int n = 0;
        while (n < vector.size()) {
            ParsedBlock parsedBlock = (ParsedBlock)vector.elementAt(n);
            System.out.println(parsedBlock.toString());
            ++n;
        }
    }
}

