/*
 * Decompiled with CFR 0.152.
 */
package com.sun.eras.parsers.explorerDir;

import com.sun.eras.parsers.EntityParserImpl;
import com.sun.eras.parsers.ParsedBlock;
import com.sun.eras.parsers.ParserException;
import com.sun.eras.parsers.explorerDir.ExplorerDirEntityParser;
import com.sun.eras.parsers.explorerDir.FileIOException;
import com.sun.eras.parsers.explorerDir.FileParseException;
import com.sun.eras.parsers.inputFile;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Vector;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;

public class EDParseSsadisklist
extends ExplorerDirEntityParser
implements EntityParserImpl {
    public EDParseSsadisklist(String string) {
        super(string);
    }

    public Vector parse() throws ParserException {
        Vector<ParsedBlock> vector = new Vector<ParsedBlock>();
        try {
            inputFile inputFile2 = new inputFile(this.path());
            inputFile2.defineRegexp("device Line", "^\\s*DEVICE PROPERTIES for device\\s+.*(c\\d+t\\d+d\\d+)s\\d+");
            inputFile2.defineRegexp("SCSI Port/Target Line", "^\\s*SCSI Port\\s+(\\d+)\\s+Target\\s+(\\d+)");
            inputFile2.defineRegexp("attribute-value Line", "^\\s*([^:]+):\\s*(([\\d.]+)?.*?)\\s*$");
            BufferedReader bufferedReader = inputFile2.reader();
            String string = "";
            ParsedBlock parsedBlock = new ParsedBlock("HostDiskSSA");
            vector.add(parsedBlock);
            while ((string = bufferedReader.readLine()) != null) {
                MatchResult matchResult = inputFile2.matchRegexp("device Line", string);
                if (matchResult != null) {
                    parsedBlock.put("device", matchResult.group(1));
                    continue;
                }
                matchResult = inputFile2.matchRegexp("SCSI Port/Target Line", string);
                if (matchResult != null) {
                    parsedBlock.put("SCSI Port", matchResult.group(1));
                    parsedBlock.put("Target", matchResult.group(2));
                    continue;
                }
                matchResult = inputFile2.matchRegexp("attribute-value Line", string);
                if (matchResult == null) continue;
                String string2 = matchResult.group(1);
                if (string2.equals("Status") || string2.equals("Vendor") || string2.equals("Product ID") || string2.equals("Firmware Rev") || string2.equals("Serial Num") || string2.equals("Fast Writes")) {
                    parsedBlock.put(string2, matchResult.group(2));
                    continue;
                }
                if (!string2.equalsIgnoreCase("unformatted capacity")) continue;
                parsedBlock.put("Unformatted Capacity", matchResult.group(3));
            }
        }
        catch (IOException iOException) {
            throw new FileIOException("unknown", "EDParseSsadisklist.parse", iOException);
        }
        catch (MalformedPatternException malformedPatternException) {
            throw new FileParseException("unknown", "EDParseSsadisklist.parse", malformedPatternException);
        }
        return vector;
    }
}

