/*
 * Decompiled with CFR 0.152.
 */
package com.sun.eras.parsers.explorerDir;

import com.sun.eras.parsers.BlockActionImpl;
import com.sun.eras.parsers.ParsedBlock;
import com.sun.eras.parsers.ParserException;
import com.sun.eras.parsers.explorerDir.ExplorerDirEntityParser;
import com.sun.eras.parsers.explorerDir.FileIOException;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import org.apache.oro.text.perl.Perl5Util;

public class EDParseSCPlatform
extends ExplorerDirEntityParser {
    private String relative_filename;
    private String dataType;
    private String perl_reg_exp = "";

    public EDParseSCPlatform(String string) {
        super(string);
    }

    public Vector parse(BlockActionImpl blockActionImpl, Object object) throws ParserException {
        Vector vector = new Vector();
        String string = String.valueOf(this.path()) + this.relative_filename;
        try {
            String string2;
            FileReader fileReader = new FileReader(string);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            Perl5Util perl5Util = new Perl5Util();
            while ((string2 = bufferedReader.readLine()) != null) {
                if (!perl5Util.match(this.perl_reg_exp, string2)) continue;
                ParsedBlock parsedBlock = new ParsedBlock(this.dataType);
                if (this.dataType.equals("domains")) {
                    parsedBlock.put("name", perl5Util.group(1).trim());
                    parsedBlock.put("node", perl5Util.group(2).trim());
                    parsedBlock.put("status", perl5Util.group(3).trim());
                    parsedBlock.put("keyswitch", perl5Util.group(4).trim());
                } else if (this.dataType.equals("configuredDomains")) {
                    String string3 = perl5Util.group(1).trim();
                    String string4 = perl5Util.group(2).trim();
                    String string5 = "yes";
                    if (string4.equals("ff:ff:ff:ff:ff:ff")) {
                        string5 = "no";
                    }
                    parsedBlock.put("name", string3);
                    parsedBlock.put("configured", string5);
                    parsedBlock.put("macAddress", string4);
                    parsedBlock.put("hostId", perl5Util.group(3).trim());
                } else if (this.dataType.equals("systemSerialNumber")) {
                    parsedBlock.put("systemSerialNumber", perl5Util.group(2).trim());
                }
                if (ExplorerDirEntityParser.doBlockAction(parsedBlock, vector, blockActionImpl, object)) continue;
                return vector;
            }
        }
        catch (IOException iOException) {
            throw new FileIOException(string, "EDParseSCPlatform.parse", iOException);
        }
        return vector;
    }

    public void setDataType(String string) {
        this.dataType = string;
        this.perl_reg_exp = this.dataType.equals("domains") ? "/^(\\S+)\\s+(\\S+)\\s+(.{23})\\s+(on|off|secure)\\s+$/" : (this.dataType.equals("systemSerialNumber") ? "/(System Serial Number:)\\s(\\S+)$/" : (this.dataType.equals("configuredDomains") ? "/Domain\\s+(\\S+)\\s+(.{17})\\s+(.{8})$/" : ""));
    }

    public void setFilename(String string) {
        this.relative_filename = string;
    }
}

