/*
 * Decompiled with CFR 0.152.
 */
package com.sun.eras.parsers.explorerDir;

import com.sun.eras.parsers.EntityParserImpl;
import com.sun.eras.parsers.ParsedBlock;
import com.sun.eras.parsers.ParserException;
import com.sun.eras.parsers.explorerDir.ExplorerDirEntityParser;
import com.sun.eras.parsers.explorerDir.FileIOException;
import com.sun.eras.parsers.explorerDir.FileParseException;
import com.sun.eras.parsers.inputFile;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Vector;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;

public class EDParsePsrinfovOut
extends ExplorerDirEntityParser
implements EntityParserImpl {
    public EDParsePsrinfovOut(String string) {
        super(string);
    }

    public Vector parse() throws ParserException {
        Vector<ParsedBlock> vector = new Vector<ParsedBlock>();
        String string = String.valueOf(this.path()) + "/sysconfig/psrinfo-v.out";
        try {
            inputFile inputFile2 = new inputFile(string);
            inputFile2.defineRegexp("processor header Line", "Status of processor (\\d+)");
            inputFile2.defineRegexp("status Line", "^\\s*Processor has been (\\S+) since");
            inputFile2.defineRegexp("frequency Line", "processor operates at (\\d+) MHz");
            inputFile2.defineRegexp("floating point processor Line", "has a (\\S+) floating point processor");
            BufferedReader bufferedReader = inputFile2.reader();
            String string2 = "";
            ParsedBlock parsedBlock = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                MatchResult matchResult = inputFile2.matchRegexp("processor header Line", string2);
                if (matchResult != null) {
                    parsedBlock = new ParsedBlock("HostCpu");
                    vector.add(parsedBlock);
                    parsedBlock.put("cpuNumber", matchResult.group(1));
                    continue;
                }
                matchResult = inputFile2.matchRegexp("status Line", string2);
                if (matchResult != null) {
                    parsedBlock.put("cpuStatus", matchResult.group(1));
                    continue;
                }
                matchResult = inputFile2.matchRegexp("frequency Line", string2);
                if (matchResult != null) {
                    parsedBlock.put("cpuFrequency", matchResult.group(1));
                    continue;
                }
                matchResult = inputFile2.matchRegexp("floating point processor Line", string2);
                if (matchResult == null) continue;
                parsedBlock.put("fppType", matchResult.group(1));
            }
        }
        catch (IOException iOException) {
            throw new FileIOException(string, "EDParsePsrinfovOut.parse", iOException);
        }
        catch (MalformedPatternException malformedPatternException) {
            throw new FileParseException(string, "EDParsePsrinfovOut.parse", malformedPatternException);
        }
        return vector;
    }
}

