/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.asn1;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.mozilla.jss.asn1.ASN1Header;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BOOLEAN;
import org.mozilla.jss.asn1.CountingStream;
import org.mozilla.jss.asn1.Form;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.util.Assert;

public class SET
implements ASN1Value {
    public static final Tag TAG = new Tag(Tag.Class.UNIVERSAL, 17L);
    protected static final Form FORM = Form.CONSTRUCTED;
    protected Vector elements = new Vector();

    public Tag getTag() {
        return TAG;
    }

    private void addElement(Element element) {
        this.elements.addElement(element);
    }

    private void insertElementAt(Element element, int n) {
        this.elements.insertElementAt(element, n);
    }

    public void addElement(ASN1Value aSN1Value) {
        this.addElement(new Element(aSN1Value));
    }

    public void addElement(Tag tag, ASN1Value aSN1Value) {
        this.addElement(new Element(tag, aSN1Value));
    }

    public void insertElementAt(ASN1Value aSN1Value, int n) {
        this.insertElementAt(new Element(aSN1Value), n);
    }

    public void insertElementAt(Tag tag, ASN1Value aSN1Value, int n) {
        this.insertElementAt(new Element(tag, aSN1Value), n);
    }

    public ASN1Value elementAt(int n) {
        return ((Element)this.elements.elementAt(n)).getValue();
    }

    public Tag tagAt(int n) {
        Tag tag = ((Element)this.elements.elementAt(n)).getImplicitTag();
        if (tag != null) {
            return tag;
        }
        return this.elementAt(n).getTag();
    }

    public ASN1Value elementWithTag(Tag tag) {
        int n = this.elements.size();
        int n2 = 0;
        while (n2 < n) {
            Element element = (Element)this.elements.elementAt(n2);
            if (element.getTag().equals(tag)) {
                return element.getValue();
            }
            ++n2;
        }
        return null;
    }

    public int size() {
        return this.elements.size();
    }

    public void removeAllElements() {
        this.elements.removeAllElements();
    }

    public void removeElementAt(int n) {
        this.elements.removeElementAt(n);
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(this.getTag(), outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        Object object;
        boolean bl = this.elements.size() < 2 ? true : this.tagAt(0).equals(this.tagAt(1));
        int n = this.elements.size();
        int n2 = 0;
        Vector vector = new Vector(n);
        Vector vector2 = new Vector(n);
        int n3 = 0;
        while (n3 < n) {
            if (this.elementAt(n3) != null) {
                object = ASN1Util.encode(this.tagAt(n3), this.elementAt(n3));
                n2 += ((Object)object).length;
                if (bl) {
                    SET.insertInOrder(vector, (byte[])object);
                } else {
                    SET.insertInOrder(vector, (byte[])object, vector2, (int)this.tagAt(n3).getNum());
                }
            }
            ++n3;
        }
        object = new ASN1Header(tag, FORM, n2);
        ((ASN1Header)object).encode(outputStream);
        n3 = 0;
        while (n3 < n) {
            outputStream.write((byte[])vector.elementAt(n3));
            ++n3;
        }
    }

    public void BERencode(Tag tag, OutputStream outputStream) throws IOException {
        Object object;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = this.elements.size();
        int n2 = 0;
        while (n2 < n) {
            object = this.elementAt(n2);
            if (object != null) {
                object.encode(this.tagAt(n2), byteArrayOutputStream);
            }
            ++n2;
        }
        object = byteArrayOutputStream.toByteArray();
        ASN1Header aSN1Header = new ASN1Header(tag, FORM, ((byte[])object).length);
        aSN1Header.encode(outputStream);
        outputStream.write((byte[])object);
    }

    private static void insertInOrder(Vector vector, byte[] byArray) {
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            if (SET.compare(byArray, (byte[])vector.elementAt(n2)) < 1) break;
            ++n2;
        }
        vector.insertElementAt(byArray, n2);
    }

    private static void insertInOrder(Vector vector, byte[] byArray, Vector vector2, int n) {
        int n2 = vector.size();
        int n3 = 0;
        while (n3 < n2) {
            if (n <= (Integer)vector2.elementAt(n3)) break;
            ++n3;
        }
        vector.insertElementAt(byArray, n3);
        vector2.insertElementAt(new Integer(n3), n3);
    }

    private static int compare(byte[] byArray, byte[] byArray2) {
        int n = byArray.length < byArray2.length ? byArray.length : byArray2.length;
        int n2 = 0;
        while (n2 < n) {
            if ((byArray[n2] & 0xFF) < (byArray2[n2] & 0xFF)) {
                return -1;
            }
            if ((byArray[n2] & 0xFF) > (byArray2[n2] & 0xFF)) {
                return 1;
            }
            ++n2;
        }
        if (byArray.length > n) {
            Assert._assert(byArray2.length == n);
            return 1;
        }
        if (byArray2.length > n) {
            Assert._assert(byArray.length == n);
            return -1;
        }
        return 0;
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length > 0) {
                FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
                Template template = new Template();
                template.addElement(new Tag(0L), new INTEGER.Template());
                template.addElement(new Tag(3L), new INTEGER.Template());
                template.addOptionalElement(new Tag(4L), new INTEGER.Template());
                template.addElement(new Tag(5L), new INTEGER.Template(), new INTEGER(67L));
                template.addElement(new Tag(29L), new BOOLEAN.Template());
                template.addElement(new Tag(30L), new BOOLEAN.Template(), new BOOLEAN(false));
                template.addElement(new Tag(1L), new INTEGER.Template());
                template.addElement(new Tag(2L), new INTEGER.Template());
                SET sET = (SET)template.decode(new BufferedInputStream(fileInputStream));
                int n = 0;
                while (n < sET.size()) {
                    ASN1Value aSN1Value;
                    ASN1Value aSN1Value2 = sET.elementAt(n);
                    if (aSN1Value2 instanceof INTEGER) {
                        aSN1Value = (INTEGER)sET.elementAt(n);
                        System.out.println("INTEGER: " + aSN1Value);
                    } else if (aSN1Value2 instanceof BOOLEAN) {
                        aSN1Value = (BOOLEAN)sET.elementAt(n);
                        System.out.println("BOOLEAN: " + aSN1Value);
                    } else {
                        System.out.println("Unknown value");
                    }
                    ++n;
                }
            } else {
                SET sET = new SET();
                sET.addElement(new Tag(0L), new INTEGER(255L));
                sET.addElement(new Tag(29L), new BOOLEAN(true));
                sET.addElement(new Tag(1L), new INTEGER(-322L));
                sET.addElement(new Tag(2L), new INTEGER(0L));
                sET.addElement(new Tag(3L), new INTEGER("623423948273"));
                sET.encode(System.out);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static class OF_Template
    implements ASN1Template {
        private Template template;

        private OF_Template() {
        }

        public OF_Template(ASN1Template aSN1Template) {
            this.template = new Template();
            Template.Element element = new Template.Element(null, aSN1Template, false);
            element.makeRepeatable();
            this.template.addElement(element);
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        public ASN1Value decode(InputStream inputStream) throws IOException, InvalidBERException {
            return this.template.decode(inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws IOException, InvalidBERException {
            return this.template.decode(tag, inputStream);
        }
    }

    public static class Template
    implements ASN1Template {
        private Vector elements = new Vector();

        private void addElement(Element element) {
            this.elements.addElement(element);
        }

        private void insertElementAt(Element element, int n) {
            this.elements.insertElementAt(element, n);
        }

        public void addElement(ASN1Template aSN1Template) {
            this.addElement(new Element(TAG, aSN1Template, false));
        }

        public void insertElementAt(ASN1Template aSN1Template, int n) {
            this.insertElementAt(new Element(TAG, aSN1Template, false), n);
        }

        public void addElement(Tag tag, ASN1Template aSN1Template) {
            this.addElement(new Element(tag, aSN1Template, false));
        }

        public void insertElementAt(Tag tag, ASN1Template aSN1Template, int n) {
            this.insertElementAt(new Element(tag, aSN1Template, false), n);
        }

        public void addOptionalElement(ASN1Template aSN1Template) {
            this.addElement(new Element(TAG, aSN1Template, true));
        }

        public void insertOptionalElementAt(ASN1Template aSN1Template, int n) {
            this.insertElementAt(new Element(null, aSN1Template, true), n);
        }

        public void addOptionalElement(Tag tag, ASN1Template aSN1Template) {
            this.addElement(new Element(tag, aSN1Template, true));
        }

        public void insertOptionalElementAt(Tag tag, ASN1Template aSN1Template, int n) {
            this.insertElementAt(new Element(tag, aSN1Template, true), n);
        }

        public void addElement(ASN1Template aSN1Template, ASN1Value aSN1Value) {
            this.addElement(new Element(TAG, aSN1Template, aSN1Value));
        }

        public void insertElementAt(ASN1Template aSN1Template, ASN1Value aSN1Value, int n) {
            this.insertElementAt(new Element(null, aSN1Template, aSN1Value), n);
        }

        public void addElement(Tag tag, ASN1Template aSN1Template, ASN1Value aSN1Value) {
            this.addElement(new Element(tag, aSN1Template, aSN1Value));
        }

        public void insertElementAt(Tag tag, ASN1Template aSN1Template, ASN1Value aSN1Value, int n) {
            this.insertElementAt(new Element(tag, aSN1Template, aSN1Value), n);
        }

        public Tag implicitTagAt(int n) {
            return ((Element)this.elements.elementAt(n)).getImplicitTag();
        }

        public ASN1Template templateAt(int n) {
            return ((Element)this.elements.elementAt(n)).getTemplate();
        }

        public boolean isOptionalAt(int n) {
            return ((Element)this.elements.elementAt(n)).isOptional();
        }

        private boolean isRepeatableAt(int n) {
            return ((Element)this.elements.elementAt(n)).isRepeatable();
        }

        public ASN1Value defaultAt(int n) {
            return ((Element)this.elements.elementAt(n)).getDefault();
        }

        public int size() {
            return this.elements.size();
        }

        public void removeAllElements() {
            this.elements.removeAllElements();
        }

        public void removeElementAt(int n) {
            this.elements.removeElementAt(n);
        }

        private Tag getTag() {
            return TAG;
        }

        public boolean tagMatch(Tag tag) {
            return tag.equals(TAG);
        }

        public ASN1Value decode(InputStream inputStream) throws IOException, InvalidBERException {
            return this.decode(this.getTag(), inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws IOException, InvalidBERException {
            try {
                int n;
                ASN1Header aSN1Header = new ASN1Header(inputStream);
                aSN1Header.validate(tag, Form.CONSTRUCTED);
                long l = aSN1Header.getContentLength();
                SET sET = new SET();
                boolean[] blArray = new boolean[this.elements.size()];
                while (l > 0L || l == -1L) {
                    ASN1Header aSN1Header2 = ASN1Header.lookAhead(inputStream);
                    if (aSN1Header2.isEOC()) {
                        if (l != -1L) {
                            throw new InvalidBERException("Unexpected end-of-contentmarker");
                        }
                        aSN1Header2 = new ASN1Header(inputStream);
                        break;
                    }
                    n = this.findElementByTag(aSN1Header2.getTag());
                    if (n == -1) {
                        throw new InvalidBERException("Unexpected Tag in SET: " + aSN1Header2.getTag());
                    }
                    Element element = (Element)this.elements.elementAt(n);
                    if (blArray[n] && !element.isRepeatable()) {
                        throw new InvalidBERException("Duplicate Tag in SET: " + aSN1Header2.getTag());
                    }
                    blArray[n] = true;
                    ASN1Template aSN1Template = element.getTemplate();
                    CountingStream countingStream = new CountingStream(inputStream);
                    ASN1Value aSN1Value = element.getImplicitTag() == null ? aSN1Template.decode(countingStream) : aSN1Template.decode(element.getImplicitTag(), countingStream);
                    long l2 = countingStream.getNumRead();
                    if (l != -1L) {
                        if (l < l2) {
                            throw new InvalidBERException("Item went " + (l2 - l) + " bytes past the end of" + " the SET");
                        }
                        l -= l2;
                    }
                    org.mozilla.jss.asn1.SET$Element element2 = element.getImplicitTag() == null ? new org.mozilla.jss.asn1.SET$Element(aSN1Value) : new org.mozilla.jss.asn1.SET$Element(element.getImplicitTag(), aSN1Value);
                    sET.addElement(element2);
                }
                Assert._assert(l == 0L || l == -1L);
                n = this.elements.size();
                int n2 = 0;
                while (n2 < n) {
                    if (!(blArray[n2] || this.isOptionalAt(n2) || this.isRepeatableAt(n2))) {
                        if (this.defaultAt(n2) != null) {
                            sET.addElement(new org.mozilla.jss.asn1.SET$Element(this.defaultAt(n2)));
                        } else {
                            throw new InvalidBERException("Field not found in SET");
                        }
                    }
                    ++n2;
                }
                return sET;
            }
            catch (InvalidBERException invalidBERException) {
                throw new InvalidBERException(invalidBERException, "SET");
            }
        }

        private int findElementByTag(Tag tag) {
            int n = this.elements.size();
            int n2 = 0;
            while (n2 < n) {
                Element element = (Element)this.elements.elementAt(n2);
                if (element.tagMatch(tag)) {
                    return n2;
                }
                ++n2;
            }
            return -1;
        }

        public static class Element {
            private boolean repeatable;
            private boolean optional;
            private Tag implicitTag = null;
            private ASN1Template type;
            private ASN1Value defaultVal = null;

            public Element(Tag tag, ASN1Template aSN1Template, boolean bl) {
                this.type = aSN1Template;
                this.defaultVal = null;
                this.optional = bl;
                this.implicitTag = tag;
            }

            public Element(Tag tag, ASN1Template aSN1Template, ASN1Value aSN1Value) {
                this.type = aSN1Template;
                this.defaultVal = aSN1Value;
                this.optional = false;
                this.implicitTag = tag;
            }

            void makeRepeatable() {
                this.repeatable = true;
            }

            boolean isRepeatable() {
                return this.repeatable;
            }

            public boolean isOptional() {
                return this.optional;
            }

            public Tag getImplicitTag() {
                return this.implicitTag;
            }

            public boolean tagMatch(Tag tag) {
                if (this.implicitTag != null) {
                    return this.implicitTag.equals(tag);
                }
                return this.type.tagMatch(tag);
            }

            public ASN1Template getTemplate() {
                return this.type;
            }

            public ASN1Value getDefault() {
                return this.defaultVal;
            }
        }
    }

    static class Element {
        private ASN1Value val;
        private Tag implicitTag = null;

        public Element(ASN1Value aSN1Value) {
            this.val = aSN1Value;
        }

        public Element(Tag tag, ASN1Value aSN1Value) {
            this.val = aSN1Value;
            this.implicitTag = tag;
        }

        public ASN1Value getValue() {
            return this.val;
        }

        public Tag getTag() {
            if (this.implicitTag != null) {
                return this.implicitTag;
            }
            return this.val.getTag();
        }

        public Tag getImplicitTag() {
            return this.implicitTag;
        }
    }
}

