/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Enumeration;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.KeyPairAlgorithm;
import org.mozilla.jss.crypto.KeyPairGenerator;
import org.mozilla.jss.crypto.RSAParameterSpec;
import org.mozilla.jss.tests.FilePasswordCallback;
import org.mozilla.jss.util.Assert;

public class TestKeyGen {
    public static void main(String[] stringArray) {
        try {
            if (stringArray.length != 2) {
                System.err.println("Usage: java org.mozilla.jss.tests.TestKeyGen <dbdir> <pwFile>");
                System.exit(1);
                return;
            }
            CryptoManager.InitializationValues initializationValues = new CryptoManager.InitializationValues(stringArray[0]);
            CryptoManager.initialize(initializationValues);
            CryptoManager cryptoManager = CryptoManager.getInstance();
            cryptoManager.setPasswordCallback(new FilePasswordCallback(stringArray[1]));
            Enumeration enumeration = cryptoManager.getTokensSupportingAlgorithm(KeyPairAlgorithm.RSA);
            System.out.println("The following tokens support RSA keygen:");
            while (enumeration.hasMoreElements()) {
                System.out.println("\t" + ((CryptoToken)enumeration.nextElement()).getName());
            }
            enumeration = cryptoManager.getTokensSupportingAlgorithm(KeyPairAlgorithm.DSA);
            System.out.println("The following tokens support DSA keygen:");
            while (enumeration.hasMoreElements()) {
                System.out.println("\t" + ((CryptoToken)enumeration.nextElement()).getName());
            }
            CryptoToken cryptoToken = cryptoManager.getInternalKeyStorageToken();
            KeyPairGenerator keyPairGenerator = cryptoToken.getKeyPairGenerator(KeyPairAlgorithm.RSA);
            keyPairGenerator.initialize(512);
            KeyPair keyPair = keyPairGenerator.genKeyPair();
            Assert._assert(keyPair.getPublic() instanceof RSAPublicKey);
            RSAPublicKey rSAPublicKey = (RSAPublicKey)keyPair.getPublic();
            System.out.println("Generated 512-bit RSA KeyPair!");
            System.out.println("Modulus: " + rSAPublicKey.getModulus());
            System.out.println("Exponent: " + rSAPublicKey.getPublicExponent());
            keyPairGenerator.initialize(1024);
            keyPair = keyPairGenerator.genKeyPair();
            Assert._assert(keyPair.getPublic() instanceof RSAPublicKey);
            rSAPublicKey = (RSAPublicKey)keyPair.getPublic();
            System.out.println("Generated 1024-bit RSA KeyPair!");
            System.out.println("Modulus: " + rSAPublicKey.getModulus());
            System.out.println("Exponent: " + rSAPublicKey.getPublicExponent());
            RSAParameterSpec rSAParameterSpec = new RSAParameterSpec(512, BigInteger.valueOf(3L));
            keyPairGenerator.initialize(rSAParameterSpec);
            keyPair = keyPairGenerator.genKeyPair();
            Assert._assert(keyPair.getPublic() instanceof RSAPublicKey);
            rSAPublicKey = (RSAPublicKey)keyPair.getPublic();
            System.out.println("Generated 512-bit RSA KeyPair with public exponent=3!");
            System.out.println("Modulus: " + rSAPublicKey.getModulus());
            System.out.println("Exponent: " + rSAPublicKey.getPublicExponent());
            keyPairGenerator = cryptoToken.getKeyPairGenerator(KeyPairAlgorithm.DSA);
            keyPairGenerator.initialize(512);
            keyPair = keyPairGenerator.genKeyPair();
            Assert._assert(keyPair.getPublic() instanceof DSAPublicKey);
            DSAPublicKey dSAPublicKey = (DSAPublicKey)keyPair.getPublic();
            System.out.println("Generated 512-bit DSA KeyPair!");
            DSAParams dSAParams = dSAPublicKey.getParams();
            System.out.println("P: " + dSAParams.getP());
            System.out.println("Q: " + dSAParams.getQ());
            System.out.println("G: " + dSAParams.getG());
            System.out.println("Y: " + dSAPublicKey.getY());
            keyPairGenerator.initialize(1024);
            keyPair = keyPairGenerator.genKeyPair();
            Assert._assert(keyPair.getPublic() instanceof DSAPublicKey);
            dSAPublicKey = (DSAPublicKey)keyPair.getPublic();
            System.out.println("Generated 1024-bit DSA KeyPair!");
            dSAParams = dSAPublicKey.getParams();
            System.out.println("P: " + dSAParams.getP());
            System.out.println("Q: " + dSAParams.getQ());
            System.out.println("G: " + dSAParams.getG());
            System.out.println("Y: " + dSAPublicKey.getY());
            System.out.println("TestKeyGen passed");
            System.exit(0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }
}

