/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs11;

import java.io.CharConversionException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.spec.AlgorithmParameterSpec;
import org.mozilla.jss.crypto.KeyGenAlgorithm;
import org.mozilla.jss.crypto.KeyGenerator;
import org.mozilla.jss.crypto.PBEKeyGenParams;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.pkcs11.PK11SymKey;
import org.mozilla.jss.pkcs11.PK11Token;
import org.mozilla.jss.util.Password;
import org.mozilla.jss.util.UTF8Converter;

public final class PK11KeyGenerator
implements KeyGenerator {
    private PK11Token token;
    private KeyGenAlgorithm algorithm;
    private int strength = 0;
    private AlgorithmParameterSpec parameters;
    private KeyGenerator.CharToByteConverter charToByte;
    static /* synthetic */ Class class$org$mozilla$jss$crypto$PBEKeyGenParams;

    private PK11KeyGenerator() {
    }

    PK11KeyGenerator(PK11Token pK11Token, KeyGenAlgorithm keyGenAlgorithm) {
        if (pK11Token == null || keyGenAlgorithm == null) {
            throw new NullPointerException();
        }
        this.token = pK11Token;
        this.algorithm = keyGenAlgorithm;
        this.charToByte = new KeyGenerator.CharToByteConverter(){

            public byte[] convert(char[] cArray) throws CharConversionException {
                return UTF8Converter.UnicodeToUTF8(cArray);
            }
        };
    }

    public void setCharToByteConverter(KeyGenerator.CharToByteConverter charToByteConverter) {
        if (charToByteConverter == null) {
            throw new IllegalArgumentException("CharToByteConverter is null");
        }
        this.charToByte = charToByteConverter;
    }

    public void initialize(int n) throws InvalidAlgorithmParameterException {
        if ((class$org$mozilla$jss$crypto$PBEKeyGenParams == null ? (class$org$mozilla$jss$crypto$PBEKeyGenParams = PK11KeyGenerator.class$("org.mozilla.jss.crypto.PBEKeyGenParams")) : class$org$mozilla$jss$crypto$PBEKeyGenParams).equals(this.algorithm.getParameterClass())) {
            throw new InvalidAlgorithmParameterException("PBE keygen algorithms require PBEKeyGenParams ");
        }
        if (!this.algorithm.isValidStrength(n)) {
            throw new InvalidAlgorithmParameterException(n + " is not a valid strength for " + this.algorithm);
        }
        if (n % 8 != 0) {
            throw new InvalidAlgorithmParameterException("Key strength must be divisible by 8");
        }
        this.strength = n;
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if ((class$org$mozilla$jss$crypto$PBEKeyGenParams == null ? (class$org$mozilla$jss$crypto$PBEKeyGenParams = PK11KeyGenerator.class$("org.mozilla.jss.crypto.PBEKeyGenParams")) : class$org$mozilla$jss$crypto$PBEKeyGenParams).equals(this.algorithm.getParameterClass())) {
            if (!(algorithmParameterSpec instanceof PBEKeyGenParams)) {
                throw new InvalidAlgorithmParameterException("PBE keygen algorithms require PBEKeyGenParams");
            }
        } else {
            throw new InvalidAlgorithmParameterException(this.algorithm + " does not take any parameters");
        }
        this.parameters = algorithmParameterSpec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SymmetricKey generate() throws IllegalStateException, TokenException, CharConversionException {
        if ((class$org$mozilla$jss$crypto$PBEKeyGenParams == null ? (class$org$mozilla$jss$crypto$PBEKeyGenParams = PK11KeyGenerator.class$("org.mozilla.jss.crypto.PBEKeyGenParams")) : class$org$mozilla$jss$crypto$PBEKeyGenParams).equals(this.algorithm.getParameterClass())) {
            SymmetricKey symmetricKey;
            block7: {
                if (this.parameters == null || !(this.parameters instanceof PBEKeyGenParams)) {
                    throw new IllegalStateException("PBE keygen algorithms require PBEKeyGenParams");
                }
                PBEKeyGenParams pBEKeyGenParams = (PBEKeyGenParams)this.parameters;
                byte[] byArray = null;
                try {
                    byArray = this.charToByte.convert(pBEKeyGenParams.getPassword().getChars());
                    symmetricKey = PK11KeyGenerator.generatePBE(this.token, this.algorithm, byArray, pBEKeyGenParams.getSalt(), pBEKeyGenParams.getIterations());
                    Object var5_4 = null;
                    if (byArray == null) break block7;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    if (byArray != null) {
                        Password.wipeBytes(byArray);
                    }
                    throw throwable;
                }
                Password.wipeBytes(byArray);
            }
            return symmetricKey;
        }
        if (this.algorithm == KeyGenAlgorithm.RC4) {
            if (this.strength == 0) {
                throw new IllegalStateException("RC4 keygen must be initialized with a strength");
            }
            return PK11KeyGenerator.generateNormal(this.token, this.algorithm, this.strength);
        }
        return PK11KeyGenerator.generateNormal(this.token, this.algorithm, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] generatePBE_IV() throws TokenException, CharConversionException {
        if ((class$org$mozilla$jss$crypto$PBEKeyGenParams == null ? (class$org$mozilla$jss$crypto$PBEKeyGenParams = PK11KeyGenerator.class$("org.mozilla.jss.crypto.PBEKeyGenParams")) : class$org$mozilla$jss$crypto$PBEKeyGenParams).equals(this.algorithm.getParameterClass())) {
            byte[] byArray;
            block5: {
                if (this.parameters == null || !(this.parameters instanceof PBEKeyGenParams)) {
                    throw new IllegalStateException("PBE keygen algorithms require PBEKeyGenParams");
                }
                PBEKeyGenParams pBEKeyGenParams = (PBEKeyGenParams)this.parameters;
                byte[] byArray2 = null;
                try {
                    byArray2 = this.charToByte.convert(pBEKeyGenParams.getPassword().getChars());
                    byArray = PK11KeyGenerator.generatePBE_IV(this.algorithm, byArray2, pBEKeyGenParams.getSalt(), pBEKeyGenParams.getIterations());
                    Object var5_4 = null;
                    if (byArray2 == null) break block5;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    if (byArray2 != null) {
                        Password.wipeBytes(byArray2);
                    }
                    throw throwable;
                }
                Password.wipeBytes(byArray2);
            }
            return byArray;
        }
        throw new IllegalStateException("IV generation can only be performed by PBE algorithms");
    }

    private static native byte[] generatePBE_IV(KeyGenAlgorithm var0, byte[] var1, byte[] var2, int var3) throws TokenException;

    public SymmetricKey clone(SymmetricKey symmetricKey) throws SymmetricKey.NotExtractableException, InvalidKeyException, TokenException {
        return PK11KeyGenerator.clone(symmetricKey, this.token);
    }

    public static SymmetricKey clone(SymmetricKey symmetricKey, PK11Token pK11Token) throws SymmetricKey.NotExtractableException, InvalidKeyException, TokenException {
        if (!(symmetricKey instanceof PK11SymKey)) {
            throw new InvalidKeyException("Key is not a PKCS #11 key");
        }
        return PK11KeyGenerator.nativeClone(pK11Token, symmetricKey);
    }

    private static native SymmetricKey nativeClone(PK11Token var0, SymmetricKey var1) throws SymmetricKey.NotExtractableException, TokenException;

    private static native SymmetricKey generateNormal(PK11Token var0, KeyGenAlgorithm var1, int var2) throws TokenException;

    private static native SymmetricKey generatePBE(PK11Token var0, KeyGenAlgorithm var1, byte[] var2, byte[] var3, int var4) throws TokenException;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

