/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.crypto;

import java.security.NoSuchAlgorithmException;
import java.util.Hashtable;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.crypto.Algorithm;

public class EncryptionAlgorithm
extends Algorithm {
    private int blockSize;
    private boolean padded;
    private static Hashtable oidMap = new Hashtable();
    public static final EncryptionAlgorithm RC4 = new EncryptionAlgorithm(8, "RC4", null, 1, false, OBJECT_IDENTIFIER.RSA_CIPHER.subBranch(4L));
    public static final EncryptionAlgorithm DES_ECB = new EncryptionAlgorithm(9, "DES/ECB", null, 8, false, OBJECT_IDENTIFIER.ALGORITHM.subBranch(6L));
    public static final EncryptionAlgorithm DES_CBC = new EncryptionAlgorithm(10, "DES/CBC", class$org$mozilla$jss$crypto$IVParameterSpec == null ? (class$org$mozilla$jss$crypto$IVParameterSpec = EncryptionAlgorithm.class$("org.mozilla.jss.crypto.IVParameterSpec")) : class$org$mozilla$jss$crypto$IVParameterSpec, 8, false, OBJECT_IDENTIFIER.ALGORITHM.subBranch(7L));
    public static final EncryptionAlgorithm DES_CBC_PAD = new EncryptionAlgorithm(11, "DES/CBC/Pad", class$org$mozilla$jss$crypto$IVParameterSpec == null ? (class$org$mozilla$jss$crypto$IVParameterSpec = EncryptionAlgorithm.class$("org.mozilla.jss.crypto.IVParameterSpec")) : class$org$mozilla$jss$crypto$IVParameterSpec, 8, true, null);
    public static final EncryptionAlgorithm DES3_ECB = new EncryptionAlgorithm(12, "DES3/ECB", null, 8, false, null);
    public static final EncryptionAlgorithm DES3_CBC = new EncryptionAlgorithm(13, "DES3/CBC", class$org$mozilla$jss$crypto$IVParameterSpec == null ? (class$org$mozilla$jss$crypto$IVParameterSpec = EncryptionAlgorithm.class$("org.mozilla.jss.crypto.IVParameterSpec")) : class$org$mozilla$jss$crypto$IVParameterSpec, 8, false, OBJECT_IDENTIFIER.RSA_CIPHER.subBranch(7L));
    public static final EncryptionAlgorithm DES3_CBC_PAD = new EncryptionAlgorithm(14, "DES3/CBC/Pad", class$org$mozilla$jss$crypto$IVParameterSpec == null ? (class$org$mozilla$jss$crypto$IVParameterSpec = EncryptionAlgorithm.class$("org.mozilla.jss.crypto.IVParameterSpec")) : class$org$mozilla$jss$crypto$IVParameterSpec, 8, true, null);
    public static final EncryptionAlgorithm RC2_CBC = new EncryptionAlgorithm(30, "RC2/CBC", class$org$mozilla$jss$crypto$IVParameterSpec == null ? (class$org$mozilla$jss$crypto$IVParameterSpec = EncryptionAlgorithm.class$("org.mozilla.jss.crypto.IVParameterSpec")) : class$org$mozilla$jss$crypto$IVParameterSpec, 8, false, OBJECT_IDENTIFIER.RSA_CIPHER.subBranch(2L));
    static /* synthetic */ Class class$org$mozilla$jss$crypto$IVParameterSpec;

    protected EncryptionAlgorithm(int n, String string, Class clazz, int n2, boolean bl, OBJECT_IDENTIFIER oBJECT_IDENTIFIER) {
        super(n, string, oBJECT_IDENTIFIER, clazz);
        this.blockSize = n2;
        this.padded = bl;
        if (oBJECT_IDENTIFIER != null) {
            oidMap.put(oBJECT_IDENTIFIER, this);
        }
    }

    public static EncryptionAlgorithm fromOID(OBJECT_IDENTIFIER oBJECT_IDENTIFIER) throws NoSuchAlgorithmException {
        Object v = oidMap.get(oBJECT_IDENTIFIER);
        if (v == null) {
            throw new NoSuchAlgorithmException();
        }
        return (EncryptionAlgorithm)v;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public boolean isPadded() {
        return this.padded;
    }

    public native int getIVLength();

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

