/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.util;

import java.io.CharConversionException;
import org.mozilla.jss.util.Assert;
import org.mozilla.jss.util.Debug;

public class UTF8Converter {
    public static byte[] UnicodeToUTF8(char[] cArray) throws CharConversionException {
        return UTF8Converter.UnicodeToUTF8(cArray, false);
    }

    public static byte[] UnicodeToUTF8NullTerm(char[] cArray) throws CharConversionException {
        return UTF8Converter.UnicodeToUTF8(cArray, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static byte[] UnicodeToUTF8(char[] cArray, boolean bl) throws CharConversionException {
        byte[] byArray;
        int n;
        block30: {
            byte[] byArray2 = null;
            byte[] byArray3 = null;
            boolean bl2 = true;
            boolean bl3 = false;
            Assert._assert(cArray != null);
            if (cArray == null) {
                return null;
            }
            try {
                block29: {
                    int n2 = cArray.length * 3;
                    if (bl) {
                        ++n2;
                    }
                    byArray2 = new byte[n2];
                    int n3 = 0;
                    int n4 = 0;
                    block4: while (true) {
                        if (n3 >= cArray.length) {
                            if (bl) {
                                byArray2[n4++] = 0;
                            }
                            try {
                                byArray3 = new byte[n4];
                                int n5 = 0;
                                while (true) {
                                    if (n5 >= n4) {
                                        byArray2 = byArray3;
                                        byArray3 = null;
                                        Object var13_15 = null;
                                        if (byArray3 != null) {
                                            break block4;
                                        }
                                        break block29;
                                    }
                                    byArray3[n5] = byArray2[n5];
                                    byArray2[n5] = 0;
                                    ++n5;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var13_16 = null;
                                if (byArray3 != null) {
                                    UTF8Converter.wipeBytes(byArray3);
                                }
                                throw throwable;
                            }
                        }
                        char c = cArray[n3];
                        if (c >= '\ud800' && c <= '\udbff') {
                            n = c - 55296 << 10;
                            if (n3 == cArray.length - 1) {
                                throw new CharConversionException();
                            }
                            if ((c = cArray[++n3]) < '\udc00' || c > '\udfff') {
                                throw new CharConversionException();
                            }
                            n |= c - 56320;
                            n += 65536;
                        } else {
                            if (c >= '\udc00' && c <= '\udfff') {
                                bl3 = true;
                                throw new CharConversionException();
                            }
                            n = cArray[n3];
                        }
                        if (n < 128) {
                            byArray2[n4++] = (byte)n;
                        } else if (n < 2048) {
                            byArray2[n4++] = (byte)(0xC0 | n >> 6);
                            byArray2[n4++] = (byte)(0x80 | n & 0x3F);
                        } else if (n < 65536) {
                            byArray2[n4++] = (byte)(0xE0 | n >> 12);
                            byArray2[n4++] = (byte)(0x80 | n >> 6 & 0x3F);
                            byArray2[n4++] = (byte)(0x80 | n & 0x3F);
                        } else if (n < 0x200000) {
                            byArray2[n4++] = (byte)(0xF0 | n >> 18);
                            byArray2[n4++] = (byte)(0x80 | n >> 12 & 0x3F);
                            byArray2[n4++] = (byte)(0x80 | n >> 6 & 0x3F);
                            byArray2[n4++] = (byte)(0x80 | n & 0x3F);
                        } else if (n < 0x200000) {
                            byArray2[n4++] = (byte)(0xF8 | n >> 24);
                            byArray2[n4++] = (byte)(0x80 | n >> 18 & 0x3F);
                            byArray2[n4++] = (byte)(0x80 | n >> 12 & 0x3F);
                            byArray2[n4++] = (byte)(0x80 | n >> 6 & 0x3F);
                            byArray2[n4++] = (byte)(0x80 | n & 0x3F);
                        } else {
                            byArray2[n4++] = (byte)(0xFC | n >> 30);
                            byArray2[n4++] = (byte)(0x80 | n >> 24 & 0x3F);
                            byArray2[n4++] = (byte)(0x80 | n >> 18 & 0x3F);
                            byArray2[n4++] = (byte)(0x80 | n >> 12 & 0x3F);
                            byArray2[n4++] = (byte)(0x80 | n >> 6 & 0x3F);
                            byArray2[n4++] = (byte)(0x80 | n & 0x3F);
                        }
                        ++n3;
                    }
                    UTF8Converter.wipeBytes(byArray3);
                }
                bl2 = false;
                byArray = byArray2;
                if (!bl2 || byArray2 == null) break block30;
            }
            catch (Throwable throwable) {
                if (bl2 && byArray2 != null) {
                    UTF8Converter.wipeBytes(byArray2);
                    byArray2 = null;
                }
                boolean bl4 = false;
                boolean bl5 = false;
                throw throwable;
            }
            UTF8Converter.wipeBytes(byArray2);
            byArray2 = null;
        }
        n = 0;
        return byArray;
    }

    public static void wipeBytes(byte[] byArray) {
        Assert._assert(byArray != null);
        if (byArray == null) {
            return;
        }
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = 0;
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        Debug.setLevel(10);
        System.out.println("***WARNING***");
        System.out.println("Debugging mode is disabled. This code only checks itself in debug mode. The test is almost worthless in optimized mode.");
        try {
            try {
                System.out.println("ASCII Test:");
                char[] cArray = new char[128];
                int n = 0;
                while (n < 128) {
                    cArray[n] = (char)n;
                    ++n;
                }
                byte[] byArray = UTF8Converter.UnicodeToUTF8(cArray);
                n = 0;
                while (n < 128) {
                    int n2 = n;
                    while (n2 < 128 && n2 < n + 20) {
                        System.out.print(cArray[n2] + " ");
                        ++n2;
                    }
                    System.out.println();
                    n2 = n;
                    while (n2 < 128 && n2 < n + 20) {
                        System.out.print(byArray[n2] + " ");
                        ++n2;
                    }
                    System.out.println("\n");
                    n = n2;
                }
                System.out.println("UCS2 test:");
                cArray = new char[]{'\u0000', '\u007f', '\u0080', '\u0400', '\u07ff', '\u0800', '\u3167', '\ud7ff', '\ue000', '\uffff'};
                byArray = UTF8Converter.UnicodeToUTF8(cArray);
                n = 0;
                while (n < 10) {
                    System.out.print(Integer.toHexString(cArray[n]) + " ");
                    ++n;
                }
                System.out.println();
                n = 0;
                while (n < byArray.length) {
                    System.out.print(Integer.toHexString(byArray[n]) + " ");
                    ++n;
                }
                System.out.println();
                System.out.println("Maximum buffer size test:");
                cArray = new char[]{'\uffff', '\uffff', '\uffff', '\uffff'};
                byArray = UTF8Converter.UnicodeToUTF8(cArray);
                Assert._assert(byArray.length == 12);
                System.out.println("8 bytes of unicode --> " + byArray.length + " bytes of utf8\n");
                System.out.println("Empty input test:");
                cArray = new char[]{};
                byArray = UTF8Converter.UnicodeToUTF8(cArray);
                Assert._assert(byArray != null);
                Assert._assert(byArray.length == 0);
                System.out.println("given 0 bytes Unicode, produces 0 length utf8\n");
                System.out.println("UCS4 Test:");
                cArray = new char[]{'\ud800', '\udc00', '\uda85', '\ude47', '\udbff', '\udfff'};
                byArray = UTF8Converter.UnicodeToUTF8(cArray);
                n = 0;
                while (n < 6) {
                    System.out.print(Integer.toHexString(cArray[n]) + " ");
                    ++n;
                }
                System.out.println();
                n = 0;
                while (n < byArray.length) {
                    System.out.print(Integer.toHexString(byArray[n]) + " ");
                    ++n;
                }
                System.out.println("\n");
                System.out.println("high half at end of input:");
                try {
                    cArray = new char[]{'\ud800'};
                    byArray = UTF8Converter.UnicodeToUTF8(cArray);
                    Assert.notReached("should have failed on bad UCS4");
                }
                catch (CharConversionException charConversionException) {
                    System.out.println("Correctly caught bad UCS4\n");
                }
                System.out.println("high half with something other than low half:");
                try {
                    cArray = new char[]{'\ud800', '\u007f'};
                    byArray = UTF8Converter.UnicodeToUTF8(cArray);
                    Assert.notReached("should have failed on bad UCS4");
                }
                catch (CharConversionException charConversionException) {
                    System.out.println("Correctly caught bad UCS4\n");
                }
                System.out.println("orphaned low half test:");
                try {
                    cArray = new char[]{'2', '\udc01', '3'};
                    byArray = UTF8Converter.UnicodeToUTF8(cArray);
                    Assert.notReached("should have failed on bad UCS4");
                }
                catch (CharConversionException charConversionException) {
                    System.out.println("Correctly caught bad UCS4\n");
                }
                System.out.println("null-terminating:");
                cArray = new char[]{'f', 'o', 'o', 'b', 'a', 'r'};
                byArray = UTF8Converter.UnicodeToUTF8NullTerm(cArray);
                n = 0;
                while (n < cArray.length) {
                    System.out.print(cArray[n] + " ");
                    ++n;
                }
                System.out.println();
                n = 0;
                while (n < byArray.length) {
                    System.out.print(byArray[n] + " ");
                    ++n;
                }
                System.out.println("\n");
            }
            catch (CharConversionException charConversionException) {
                System.out.println("Error converting Unicode " + charConversionException);
                Object var7_11 = null;
                System.out.println("***WARNING***");
                System.out.println("Debugging mode is disabled. This code only checks itself in debug mode. The test is almost worthless in optimized mode.");
            }
            Object var7_10 = null;
            System.out.println("***WARNING***");
            System.out.println("Debugging mode is disabled. This code only checks itself in debug mode. The test is almost worthless in optimized mode.");
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            System.out.println("***WARNING***");
            System.out.println("Debugging mode is disabled. This code only checks itself in debug mode. The test is almost worthless in optimized mode.");
            throw throwable;
        }
    }
}

