/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs7;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkcs7.EncryptedContentInfo;
import org.mozilla.jss.pkcs7.RecipientInfo;
import org.mozilla.jss.pkcs7.SignerInfo;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;

public class SignedAndEnvelopedData
implements ASN1Value {
    private INTEGER version;
    private SET recipientInfos;
    private SET digestAlgorithms;
    private EncryptedContentInfo encryptedContentInfo;
    private SET certificates;
    private SET crls;
    private SET signerInfos;
    private SEQUENCE sequence;
    private static final Tag TAG = SEQUENCE.TAG;

    public INTEGER getVersion() {
        return this.version;
    }

    public SET getRecipientInfos() {
        return this.recipientInfos;
    }

    public SET getDigestAlgorithms() {
        return this.digestAlgorithms;
    }

    public EncryptedContentInfo getEncryptedContentInfo() {
        return this.encryptedContentInfo;
    }

    public SET getCertificates() {
        return this.certificates;
    }

    public SET getCrls() {
        return this.crls;
    }

    public SET getSignerInfos() {
        return this.signerInfos;
    }

    private SignedAndEnvelopedData() {
    }

    public SignedAndEnvelopedData(INTEGER iNTEGER, SET sET, SET sET2, EncryptedContentInfo encryptedContentInfo, SET sET3, SET sET4, SET sET5) {
        if (iNTEGER == null || sET == null || sET2 == null || encryptedContentInfo == null || sET5 == null) {
            throw new IllegalArgumentException("SignedAndEnvelopedData constructor parameter is null");
        }
        this.version = iNTEGER;
        this.recipientInfos = sET;
        this.digestAlgorithms = sET2;
        this.encryptedContentInfo = encryptedContentInfo;
        this.certificates = sET3;
        this.crls = sET4;
        this.signerInfos = sET5;
        this.sequence = new SEQUENCE();
        this.sequence.addElement(iNTEGER);
        this.sequence.addElement(sET);
        this.sequence.addElement(sET2);
        this.sequence.addElement(encryptedContentInfo);
        if (sET3 != null) {
            this.sequence.addElement(sET3);
        }
        if (sET4 != null) {
            this.sequence.addElement(sET4);
        }
        this.sequence.addElement(sET5);
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.sequence.encode(outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        this.sequence.encode(tag, outputStream);
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(INTEGER.getTemplate());
            this.seqt.addElement(new SET.OF_Template(RecipientInfo.getTemplate()));
            this.seqt.addElement(new SET.OF_Template(AlgorithmIdentifier.getTemplate()));
            this.seqt.addElement(EncryptedContentInfo.getTemplate());
            this.seqt.addOptionalElement(new Tag(0L), new SET.OF_Template(ANY.getTemplate()));
            this.seqt.addOptionalElement(new Tag(1L), new SET.OF_Template(ANY.getTemplate()));
            this.seqt.addElement(new SET.OF_Template(SignerInfo.getTemplate()));
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        public ASN1Value decode(InputStream inputStream) throws InvalidBERException, IOException {
            return this.decode(TAG, inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws InvalidBERException, IOException {
            SEQUENCE sEQUENCE = (SEQUENCE)this.seqt.decode(tag, inputStream);
            return new SignedAndEnvelopedData((INTEGER)sEQUENCE.elementAt(0), (SET)sEQUENCE.elementAt(1), (SET)sEQUENCE.elementAt(2), (EncryptedContentInfo)sEQUENCE.elementAt(3), (SET)sEQUENCE.elementAt(4), (SET)sEQUENCE.elementAt(5), (SET)sEQUENCE.elementAt(6));
        }
    }
}

