/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs12;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.DigestAlgorithm;
import org.mozilla.jss.crypto.HMACAlgorithm;
import org.mozilla.jss.crypto.JSSMessageDigest;
import org.mozilla.jss.crypto.KeyGenAlgorithm;
import org.mozilla.jss.crypto.PBEKeyGenParams;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.pkcs12.PasswordConverter;
import org.mozilla.jss.pkcs7.DigestInfo;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.util.Assert;
import org.mozilla.jss.util.Password;

public class MacData
implements ASN1Value {
    private DigestInfo mac;
    private OCTET_STRING macSalt;
    private INTEGER macIterationCount;
    private static final int DEFAULT_ITERATIONS = 1;
    private static final int SALT_LENGTH = 20;
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    public DigestInfo getMac() {
        return this.mac;
    }

    public OCTET_STRING getMacSalt() {
        return this.macSalt;
    }

    public INTEGER getMacIterationCount() {
        return this.macIterationCount;
    }

    public MacData() {
    }

    public MacData(DigestInfo digestInfo, OCTET_STRING oCTET_STRING, INTEGER iNTEGER) {
        if (digestInfo == null || oCTET_STRING == null || iNTEGER == null) {
            throw new IllegalArgumentException("null parameter");
        }
        this.mac = digestInfo;
        this.macSalt = oCTET_STRING;
        this.macIterationCount = iNTEGER;
    }

    public MacData(Password password, byte[] byArray, int n, byte[] byArray2) throws CryptoManager.NotInitializedException, DigestException, TokenException, CharConversionException {
        try {
            Object object;
            CryptoManager cryptoManager = CryptoManager.getInstance();
            CryptoToken cryptoToken = cryptoManager.getInternalCryptoToken();
            if (byArray == null) {
                object = cryptoManager.createPseudoRandomNumberGenerator();
                byArray = new byte[20];
                object.nextBytes(byArray);
            }
            object = cryptoToken.getKeyGenerator(KeyGenAlgorithm.PBA_SHA1_HMAC);
            PBEKeyGenParams pBEKeyGenParams = new PBEKeyGenParams(password, byArray, n);
            object.setCharToByteConverter(new PasswordConverter());
            object.initialize(pBEKeyGenParams);
            SymmetricKey symmetricKey = object.generate();
            JSSMessageDigest jSSMessageDigest = cryptoToken.getDigestContext(HMACAlgorithm.SHA1);
            jSSMessageDigest.initHMAC(symmetricKey);
            byte[] byArray3 = jSSMessageDigest.digest(byArray2);
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(DigestAlgorithm.SHA1.toOID());
            this.mac = new DigestInfo(algorithmIdentifier, new OCTET_STRING(byArray3));
            this.macSalt = new OCTET_STRING(byArray);
            this.macIterationCount = new INTEGER(n);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Assert.notReached("SHA-1 HMAC algorithm not found on internal  token (" + noSuchAlgorithmException.toString() + ")");
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            Assert.notReached("Invalid PBE algorithm parameters");
        }
        catch (IllegalStateException illegalStateException) {
            Assert.notReached("IllegalStateException");
        }
        catch (InvalidKeyException invalidKeyException) {
            Assert.notReached("Invalid key exception");
        }
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(TAG, outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addElement(this.mac);
        sEQUENCE.addElement(this.macSalt);
        if (!this.macIterationCount.equals(new INTEGER(1L))) {
            sEQUENCE.addElement(this.macIterationCount);
        }
        sEQUENCE.encode(tag, outputStream);
    }

    public static final Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(DigestInfo.getTemplate());
            this.seqt.addElement(OCTET_STRING.getTemplate());
            this.seqt.addElement(INTEGER.getTemplate(), new INTEGER(1L));
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        public ASN1Value decode(InputStream inputStream) throws InvalidBERException, IOException {
            return this.decode(TAG, inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws InvalidBERException, IOException {
            SEQUENCE sEQUENCE = (SEQUENCE)this.seqt.decode(tag, inputStream);
            return new MacData((DigestInfo)sEQUENCE.elementAt(0), (OCTET_STRING)sEQUENCE.elementAt(1), (INTEGER)sEQUENCE.elementAt(2));
        }
    }
}

