/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs11;

import java.io.ByteArrayOutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import org.mozilla.jss.crypto.Algorithm;
import org.mozilla.jss.crypto.NoSuchItemOnTokenException;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.SignatureAlgorithm;
import org.mozilla.jss.crypto.SignatureSpi;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.pkcs11.KeyType;
import org.mozilla.jss.pkcs11.PK11Key;
import org.mozilla.jss.pkcs11.PK11PrivKey;
import org.mozilla.jss.pkcs11.PK11PubKey;
import org.mozilla.jss.pkcs11.PK11Token;
import org.mozilla.jss.pkcs11.SigContextProxy;
import org.mozilla.jss.pkcs11.TokenProxy;
import org.mozilla.jss.util.Assert;

final class PK11Signature
extends SignatureSpi {
    protected PK11Token token;
    protected TokenProxy tokenProxy;
    protected Algorithm algorithm;
    protected PK11Key key;
    protected int state;
    protected SigContextProxy sigContext;
    protected boolean raw = false;
    protected ByteArrayOutputStream rawInput;
    public static final int UNINITIALIZED = 0;
    public static final int SIGN = 1;
    public static final int VERIFY = 2;

    public PK11Signature(PK11Token pK11Token, SignatureAlgorithm signatureAlgorithm) throws NoSuchAlgorithmException, TokenException {
        Assert._assert(pK11Token != null && signatureAlgorithm != null);
        if (!pK11Token.doesAlgorithm(signatureAlgorithm) && !pK11Token.doesAlgorithm(signatureAlgorithm.getSigningAlg())) {
            throw new NoSuchAlgorithmException();
        }
        this.tokenProxy = pK11Token.getProxy();
        this.token = pK11Token;
        this.algorithm = signatureAlgorithm;
        if (signatureAlgorithm.getRawAlg() == signatureAlgorithm) {
            this.raw = true;
            this.rawInput = new ByteArrayOutputStream();
        }
        this.state = 0;
    }

    public void engineInitSign(PrivateKey privateKey) throws InvalidKeyException, TokenException {
        Assert._assert(privateKey != null);
        if (privateKey == null) {
            throw new InvalidKeyException("private key is null");
        }
        if (!(privateKey instanceof PK11PrivKey)) {
            throw new InvalidKeyException("privateKey is not a PKCS #11 private key");
        }
        PK11PrivKey pK11PrivKey = (PK11PrivKey)privateKey;
        try {
            pK11PrivKey.verifyKeyIsOnToken(this.token);
        }
        catch (NoSuchItemOnTokenException noSuchItemOnTokenException) {
            throw new InvalidKeyException(noSuchItemOnTokenException.toString());
        }
        try {
            if (KeyType.getKeyTypeFromAlgorithm(this.algorithm) != pK11PrivKey.getKeyType()) {
                throw new InvalidKeyException("Key type is inconsistent with algorithm");
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Assert.notReached("unknown algorithm: " + this.algorithm);
            throw new InvalidKeyException();
        }
        this.key = pK11PrivKey;
        if (!this.raw) {
            this.sigContext = null;
            this.initSigContext();
        }
        this.state = 1;
    }

    public void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException, TokenException {
        Assert.notReached("This function is not supported");
        this.engineInitSign(privateKey);
    }

    protected native void initSigContext() throws TokenException;

    public void engineInitVerify(PublicKey publicKey) throws InvalidKeyException, TokenException {
        Assert._assert(publicKey != null);
        if (!(publicKey instanceof PK11PubKey)) {
            throw new InvalidKeyException("publicKey is not a PKCS #11 public key");
        }
        PK11PubKey pK11PubKey = (PK11PubKey)publicKey;
        try {
            if (KeyType.getKeyTypeFromAlgorithm(this.algorithm) != pK11PubKey.getKeyType()) {
                throw new InvalidKeyException("Key type is inconsistent with algorithm");
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Assert.notReached("unknown algorithm: " + this.algorithm);
            throw new InvalidKeyException();
        }
        this.key = pK11PubKey;
        if (!this.raw) {
            this.sigContext = null;
            this.initVfyContext();
        }
        this.state = 2;
    }

    protected native void initVfyContext() throws TokenException;

    public void engineUpdate(byte by) throws SignatureException, TokenException {
        this.engineUpdate(new byte[]{by}, 0, 1);
    }

    public void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException, TokenException {
        Assert._assert(byArray != null);
        if (this.state == 1 || this.state == 2) {
            if (!this.raw && this.sigContext == null) {
                Assert.notReached("signature has no context");
                throw new SignatureException("Signature has no context");
            }
            if (this.raw && this.rawInput == null) {
                Assert.notReached("raw signature has no input stream");
                throw new SignatureException("raw signature has no input stream");
            }
        } else {
            Assert._assert(this.state == 0);
            throw new SignatureException("Signature is not initialized");
        }
        Assert._assert(this.token != null);
        Assert._assert(this.tokenProxy != null);
        Assert._assert(this.algorithm != null);
        Assert._assert(this.key != null);
        if (this.raw) {
            this.rawInput.write(byArray, n, n2);
        } else {
            this.engineUpdateNative(byArray, n, n2);
        }
    }

    protected native void engineUpdateNative(byte[] var1, int var2, int var3) throws TokenException;

    public byte[] engineSign() throws SignatureException, TokenException {
        byte[] byArray;
        if (this.state != 1) {
            throw new SignatureException("Signature is not initialized");
        }
        if (!this.raw && this.sigContext == null) {
            throw new SignatureException("Signature has no context");
        }
        if (this.raw && this.rawInput == null) {
            throw new SignatureException("Signature has no input");
        }
        Assert._assert(this.token != null);
        Assert._assert(this.tokenProxy != null);
        Assert._assert(this.algorithm != null);
        Assert._assert(this.key != null);
        if (this.raw) {
            byArray = PK11Signature.engineRawSignNative(this.token, (PK11PrivKey)this.key, this.rawInput.toByteArray());
            this.rawInput.reset();
        } else {
            byArray = this.engineSignNative();
        }
        this.state = 0;
        this.sigContext = null;
        return byArray;
    }

    public int engineSign(byte[] byArray, int n, int n2) throws SignatureException, TokenException {
        byte[] byArray2;
        Assert._assert(byArray != null);
        if (this.raw) {
            byArray2 = PK11Signature.engineRawSignNative(this.token, (PK11PrivKey)this.key, this.rawInput.toByteArray());
            this.rawInput.reset();
        } else {
            byArray2 = this.engineSign();
        }
        if (byArray == null || byArray.length <= n || n2 < byArray2.length || n + n2 > byArray.length) {
            throw new SignatureException("outbuf is not sufficient to hold signature");
        }
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        return byArray2.length;
    }

    private static native byte[] engineRawSignNative(PK11Token var0, PrivateKey var1, byte[] var2) throws SignatureException, TokenException;

    private native byte[] engineSignNative() throws SignatureException, TokenException;

    public boolean engineVerify(byte[] byArray) throws SignatureException, TokenException {
        boolean bl;
        Assert._assert(byArray != null);
        if (this.state != 2) {
            throw new SignatureException("Signature is not initialized properly");
        }
        if (!this.raw && this.sigContext == null) {
            Assert.notReached("Signature has no context");
            throw new SignatureException("Signature has no context");
        }
        if (this.raw && this.rawInput == null) {
            Assert.notReached("Signature has no input");
            throw new SignatureException("Signature has no input");
        }
        Assert._assert(this.token != null);
        Assert._assert(this.tokenProxy != null);
        Assert._assert(this.algorithm != null);
        Assert._assert(this.key != null);
        if (byArray == null) {
            return false;
        }
        if (this.raw) {
            bl = PK11Signature.engineRawVerifyNative(this.token, (PK11PubKey)this.key, this.rawInput.toByteArray(), byArray);
            this.rawInput.reset();
        } else {
            bl = this.engineVerifyNative(byArray);
        }
        this.state = 0;
        this.sigContext = null;
        return bl;
    }

    protected static native boolean engineRawVerifyNative(PK11Token var0, PublicKey var1, byte[] var2, byte[] var3) throws SignatureException, TokenException;

    protected native boolean engineVerifyNative(byte[] var1) throws SignatureException, TokenException;

    public void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException, TokenException {
        Assert.notYetImplemented("PK11Signature.engineSetParameter");
    }
}

