/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Iterator;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.pkix.cert.Certificate;
import org.mozilla.jss.pkix.cert.CertificateInfo;
import org.mozilla.jss.util.Password;

public class VerifyCert {
    public void showCert(String string) {
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            Certificate certificate = (Certificate)Certificate.getTemplate().decode(bufferedInputStream);
            CertificateInfo certificateInfo = certificate.getInfo();
            certificateInfo.print(System.out);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void usage() {
        System.out.println("Usage: java org.mozilla.jss.tests.VerifyCert");
        System.out.println("\noptions:\n\n<dbdir> <passwd> <nicknameOfCertinDB> <OCSPResponderURL> <OCSPCertNickname>\n");
        System.out.println("<dbdir> <passwd> <DerEncodeCertFile> <OCSPResponderURL> <OCSPCertNickname>\n");
        System.out.println("Note: <OCSPResponderURL> and <OCSPCertNickname> are optional.\n      But if used, both Url/nickname must be specified.");
    }

    public static void main(String[] stringArray) {
        try {
            VerifyCert verifyCert = new VerifyCert();
            if (stringArray.length < 3) {
                verifyCert.usage();
                return;
            }
            String string = stringArray[0];
            String string2 = stringArray[1];
            String string3 = stringArray[2];
            String string4 = null;
            String string5 = null;
            if (stringArray.length == 4 || stringArray.length > 5) {
                verifyCert.usage();
            } else if (stringArray.length == 5) {
                string4 = stringArray[3];
                string5 = stringArray[4];
            }
            CryptoManager.InitializationValues initializationValues = new CryptoManager.InitializationValues(string);
            initializationValues.ocspCheckingEnabled = true;
            if (string4 != null && string5 != null) {
                initializationValues.ocspResponderCertNickname = string5;
                initializationValues.ocspResponderURL = string4;
            }
            CryptoManager.initialize(initializationValues);
            CryptoManager cryptoManager = CryptoManager.getInstance();
            Password password = new Password(string2.toCharArray());
            cryptoManager.setPasswordCallback(password);
            try {
                FileInputStream fileInputStream = new FileInputStream(string3);
                byte[] byArray = new byte[fileInputStream.available()];
                fileInputStream.read(byArray);
                verifyCert.showCert(string3);
                verifyCert.validateDerCert(byArray, cryptoManager);
            }
            catch (FileNotFoundException fileNotFoundException) {
                verifyCert.validateCertInDB(string3, cryptoManager);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void validateDerCert(byte[] byArray, CryptoManager cryptoManager) {
        Iterator iterator;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            iterator = CryptoManager.CertUsage.getCertUsages();
            while (iterator.hasNext()) {
                CryptoManager.CertUsage certUsage = (CryptoManager.CertUsage)iterator.next();
                if (certUsage.equals(CryptoManager.CertUsage.UserCertImport) || certUsage.equals(CryptoManager.CertUsage.ProtectedObjectSigner) || certUsage.equals(CryptoManager.CertUsage.AnyCA) || !cryptoManager.isCertValid(byArray, true, certUsage)) continue;
                arrayList.add(certUsage.toString());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (arrayList.isEmpty()) {
            System.out.println("The certificate is not valid.");
        } else {
            System.out.println("The certificate is valid for the following usages:\n");
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                System.out.println("                       " + iterator.next());
            }
        }
    }

    public void validateCertInDB(String string, CryptoManager cryptoManager) {
        Iterator iterator;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            iterator = CryptoManager.CertUsage.getCertUsages();
            while (iterator.hasNext()) {
                CryptoManager.CertUsage certUsage = (CryptoManager.CertUsage)iterator.next();
                if (certUsage.equals(CryptoManager.CertUsage.UserCertImport) || certUsage.equals(CryptoManager.CertUsage.ProtectedObjectSigner) || certUsage.equals(CryptoManager.CertUsage.AnyCA) || !cryptoManager.isCertValid(string, true, certUsage)) continue;
                arrayList.add(certUsage.toString());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (arrayList.isEmpty()) {
            System.out.println("The certificate is not valid.");
        } else {
            System.out.println("The certificate is valid for the following usages:\n");
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                System.out.println("                       " + iterator.next());
            }
        }
    }
}

