/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.asn1;

import java.io.CharConversionException;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.CharConverter;
import org.mozilla.jss.asn1.CharacterString;
import org.mozilla.jss.asn1.Tag;

public class IA5String
extends CharacterString
implements ASN1Value {
    public static final Tag TAG = new Tag(Tag.Class.UNIVERSAL, 22L);
    private static final Template templateInstance = new Template();

    public IA5String(char[] cArray) throws CharConversionException {
        super(cArray);
    }

    public IA5String(String string) throws CharConversionException {
        super(string);
    }

    CharConverter getCharConverter() {
        return new IA5Converter();
    }

    public Tag getTag() {
        return TAG;
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    private static class IA5Converter
    implements CharConverter {
        private IA5Converter() {
        }

        public char[] byteToChar(byte[] byArray, int n, int n2) throws CharConversionException {
            char[] cArray = new char[n2];
            int n3 = n;
            int n4 = 0;
            while (n4 < n2) {
                if ((byArray[n3] & 0x80) != 0) {
                    throw new CharConversionException("Invalid character: " + byArray[n3]);
                }
                cArray[n4] = (char)(byArray[n3] & 0x7F);
                ++n3;
                ++n4;
            }
            return cArray;
        }

        public byte[] charToByte(char[] cArray, int n, int n2) throws CharConversionException {
            byte[] byArray = new byte[n2];
            int n3 = n;
            int n4 = 0;
            while (n4 < n2) {
                if ((cArray[n3] & 0x7F) != cArray[n3]) {
                    throw new CharConversionException("Invalid character: " + cArray[n3]);
                }
                byArray[n4] = (byte)(cArray[n3] & 0x7F);
                ++n3;
                ++n4;
            }
            return byArray;
        }
    }

    public static class Template
    extends CharacterString.Template
    implements ASN1Template {
        public Tag getTag() {
            return TAG;
        }

        public boolean tagMatch(Tag tag) {
            return tag.equals(TAG);
        }

        protected CharConverter getCharConverter() {
            return new IA5Converter();
        }

        protected CharacterString generateInstance(char[] cArray) throws CharConversionException {
            return new IA5String(cArray);
        }

        protected String typeName() {
            return "IA5String";
        }
    }
}

