/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs7;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.primitive.Name;
import org.mozilla.jss.util.Assert;

public class IssuerAndSerialNumber
implements ASN1Value {
    private Name issuer;
    private INTEGER serialNumber;
    private SEQUENCE sequence;
    static Tag TAG = SEQUENCE.TAG;
    private static Template templateInstance = new Template();

    private IssuerAndSerialNumber() {
    }

    public IssuerAndSerialNumber(Name name, INTEGER iNTEGER) {
        if (name == null || iNTEGER == null) {
            throw new IllegalArgumentException();
        }
        this.sequence = new SEQUENCE();
        this.issuer = name;
        this.sequence.addElement(name);
        this.serialNumber = iNTEGER;
        this.sequence.addElement(iNTEGER);
    }

    public Name getIssuer() {
        return this.issuer;
    }

    public INTEGER getSerialNumber() {
        return this.serialNumber;
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(TAG, outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        this.sequence.encode(tag, outputStream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(Name.getTemplate());
            this.seqt.addElement(INTEGER.getTemplate());
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        public ASN1Value decode(InputStream inputStream) throws InvalidBERException, IOException {
            return this.decode(TAG, inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws InvalidBERException, IOException {
            SEQUENCE sEQUENCE = (SEQUENCE)this.seqt.decode(tag, inputStream);
            Assert._assert(sEQUENCE.size() == 2);
            return new IssuerAndSerialNumber((Name)sEQUENCE.elementAt(0), (INTEGER)sEQUENCE.elementAt(1));
        }
    }
}

