/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs11;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import org.mozilla.jss.crypto.KeyPairAlgorithm;
import org.mozilla.jss.crypto.KeyPairGeneratorSpi;
import org.mozilla.jss.crypto.PQGParams;
import org.mozilla.jss.crypto.RSAParameterSpec;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.pkcs11.PK11Token;
import org.mozilla.jss.util.Assert;

public final class PK11KeyPairGenerator
extends KeyPairGeneratorSpi {
    private static final int DEFAULT_RSA_KEY_SIZE = 2048;
    private static final BigInteger DEFAULT_RSA_PUBLIC_EXPONENT = BigInteger.valueOf(65537L);
    private static final String p1024 = "135839652435190934085800139191680301864221874900900696919010316554114342871389066526982023513828891845682496590926522957486592076092819515303251959435284578074745022943475516750500021440278782993316814165831392449756706958779266394680687474113495272524355075654433600922751920548192539119568200162784715902571";
    private static final String q1024 = "1289225024022202541601051225376429063716419728261";
    private static final String g1024 = "9365079229044517973775853147905914670746128595481021901304748201231245287028018351117994470223961367498481071639148009750748608477086914440940765659773400233006204556380834403997210445996745757996115285802608489502160956380238739417382954486304730446079375880915926936667959108637040861595671319957190194969";
    private static final String h1024 = "52442921523337940900621893014039829709890959980326720828933601226740749524581606283131306291278616835323956710592993182613544059214633911716533418368425327413628234095671352084418677611348898811691107611640282098605730539089258655659910952545940615065321018163879856499128636989240131903260975031351698627473";
    private static final String seed1024 = "99294487279227522120410987308721952265545668206337642687581596155167227884587528576179879564731162765515189527566190299324927751299864501359105446993895763527646668003992063667962831489586752303126546478655915858883436326503676798267446073013163508014466163441488290854738816489359449082537210762470653355837";
    private static final int counter1024 = 159;
    public static final PQGParams PQG1024 = new PQGParams(new BigInteger("135839652435190934085800139191680301864221874900900696919010316554114342871389066526982023513828891845682496590926522957486592076092819515303251959435284578074745022943475516750500021440278782993316814165831392449756706958779266394680687474113495272524355075654433600922751920548192539119568200162784715902571"), new BigInteger("1289225024022202541601051225376429063716419728261"), new BigInteger("9365079229044517973775853147905914670746128595481021901304748201231245287028018351117994470223961367498481071639148009750748608477086914440940765659773400233006204556380834403997210445996745757996115285802608489502160956380238739417382954486304730446079375880915926936667959108637040861595671319957190194969"), new BigInteger("99294487279227522120410987308721952265545668206337642687581596155167227884587528576179879564731162765515189527566190299324927751299864501359105446993895763527646668003992063667962831489586752303126546478655915858883436326503676798267446073013163508014466163441488290854738816489359449082537210762470653355837"), 159, new BigInteger("52442921523337940900621893014039829709890959980326720828933601226740749524581606283131306291278616835323956710592993182613544059214633911716533418368425327413628234095671352084418677611348898811691107611640282098605730539089258655659910952545940615065321018163879856499128636989240131903260975031351698627473"));
    private static final String p768 = "1334591549939035619289567230283054603122655003980178118026955029363553392594293499178687789871628588392413078786977899109276604404053531960657701920766542891720144660923735290663050045086516783083489369477138289683344192203747015183";
    private static final String q768 = "1356132865877303155992130272917916166541739006871";
    private static final String g768 = "1024617924160404238802957719732914916383807485923819254303813897112921288261546213295904612554364830820266594592843780972915270096284099079324418834215265083315386166747220804977600828688227714319518802565604893756612386174125343163";
    private static final String seed768 = "818335465751997015393064637168438154352349887221925302425470688493624428407506863871577128315308555744979456856342994235252156194662586703244255741598129996211081771019031721876068721218509213355334043303099174315838637885951947797";
    private static final int counter768 = 80;
    private static final String h768 = "640382699969409389484886950168366372251172224987648937408021020040753785108834000620831523080773231719549705102680417704245010958792653770817759388668805215557594892534053348624875390588773257372677159854630106242075665177245698591";
    public static final PQGParams PQG768 = new PQGParams(new BigInteger("1334591549939035619289567230283054603122655003980178118026955029363553392594293499178687789871628588392413078786977899109276604404053531960657701920766542891720144660923735290663050045086516783083489369477138289683344192203747015183"), new BigInteger("1356132865877303155992130272917916166541739006871"), new BigInteger("1024617924160404238802957719732914916383807485923819254303813897112921288261546213295904612554364830820266594592843780972915270096284099079324418834215265083315386166747220804977600828688227714319518802565604893756612386174125343163"), new BigInteger("818335465751997015393064637168438154352349887221925302425470688493624428407506863871577128315308555744979456856342994235252156194662586703244255741598129996211081771019031721876068721218509213355334043303099174315838637885951947797"), 80, new BigInteger("640382699969409389484886950168366372251172224987648937408021020040753785108834000620831523080773231719549705102680417704245010958792653770817759388668805215557594892534053348624875390588773257372677159854630106242075665177245698591"));
    private static final String p512 = "6966483207285155416780416172202915863379050665227482416115451434656043093992853756903066653962454938528584622842487778598918381346739078775480034378802841";
    private static final String q512 = "1310301134281640075932276656367326462518739803527";
    private static final String g512 = "1765808308320938820731237312304158486199455718816858489736043318496656574508696475222741642343469219895005992985361010111736160340009944528784078083324884";
    private static final String h512 = "1166033533097555931825481846268490827226947692615252570752313574243187654088977281409544725210974913958636100321681636002587474728477655589742540645702652";
    private static final String seed512 = "1823071686803672528716836609217295942310764795778335243232708299998660956064222751939859670873282519585591423918449571513004815205037154878988595168291600";
    private static final int counter512 = 186;
    public static final PQGParams PQG512 = new PQGParams(new BigInteger("6966483207285155416780416172202915863379050665227482416115451434656043093992853756903066653962454938528584622842487778598918381346739078775480034378802841"), new BigInteger("1310301134281640075932276656367326462518739803527"), new BigInteger("1765808308320938820731237312304158486199455718816858489736043318496656574508696475222741642343469219895005992985361010111736160340009944528784078083324884"), new BigInteger("1823071686803672528716836609217295942310764795778335243232708299998660956064222751939859670873282519585591423918449571513004815205037154878988595168291600"), 186, new BigInteger("1166033533097555931825481846268490827226947692615252570752313574243187654088977281409544725210974913958636100321681636002587474728477655589742540645702652"));
    private static boolean defaultsTested = false;
    private PK11Token token;
    private AlgorithmParameterSpec params;
    private KeyPairAlgorithm algorithm;
    private boolean mKeygenOnInternalToken;
    private boolean temporaryPairMode = false;

    public PK11KeyPairGenerator(PK11Token pK11Token, KeyPairAlgorithm keyPairAlgorithm) throws NoSuchAlgorithmException, TokenException {
        Assert._assert(pK11Token != null && keyPairAlgorithm != null);
        this.mKeygenOnInternalToken = false;
        if (!pK11Token.doesAlgorithm(keyPairAlgorithm)) {
            if (pK11Token.doesAlgorithm(keyPairAlgorithm.getAlgFamily()) && pK11Token.isWritable()) {
                this.mKeygenOnInternalToken = true;
            } else {
                throw new NoSuchAlgorithmException();
            }
        }
        this.token = pK11Token;
        this.algorithm = keyPairAlgorithm;
    }

    public void initialize(int n, SecureRandom secureRandom) throws InvalidParameterException {
        if (this.algorithm == KeyPairAlgorithm.RSA) {
            this.params = new RSAParameterSpec(n, DEFAULT_RSA_PUBLIC_EXPONENT);
        } else {
            Assert._assert(this.algorithm == KeyPairAlgorithm.DSA);
            if (n == 512) {
                this.params = PQG512;
            } else if (n == 768) {
                this.params = PQG768;
            } else if (n == 1024) {
                this.params = PQG1024;
            } else {
                throw new InvalidParameterException("In order to use pre-cooked PQG values, key strength mustbe 512, 768, or 1024.");
            }
        }
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec == null) {
            Assert.notReached("Don't pass in null parameters");
            throw new InvalidAlgorithmParameterException();
        }
        if (this.algorithm == KeyPairAlgorithm.RSA) {
            if (!(algorithmParameterSpec instanceof RSAParameterSpec)) {
                throw new InvalidAlgorithmParameterException();
            }
            if (((RSAParameterSpec)algorithmParameterSpec).getPublicExponent().bitLength() > 31) {
                throw new InvalidAlgorithmParameterException("RSA Public Exponent must fit in 31 or fewer bits.");
            }
        } else {
            Assert._assert(this.algorithm == KeyPairAlgorithm.DSA);
            if (!(algorithmParameterSpec instanceof DSAParameterSpec)) {
                throw new InvalidAlgorithmParameterException();
            }
        }
        this.params = algorithmParameterSpec;
    }

    public KeyPair generateKeyPair() throws TokenException {
        if (this.algorithm == KeyPairAlgorithm.RSA) {
            if (this.params != null) {
                RSAParameterSpec rSAParameterSpec = (RSAParameterSpec)this.params;
                return this.generateRSAKeyPair(this.token, rSAParameterSpec.getKeySize(), rSAParameterSpec.getPublicExponent().longValue(), this.temporaryPairMode);
            }
            return this.generateRSAKeyPair(this.token, 2048, DEFAULT_RSA_PUBLIC_EXPONENT.longValue(), this.temporaryPairMode);
        }
        Assert._assert(this.algorithm == KeyPairAlgorithm.DSA);
        if (this.params == null) {
            this.params = PQG1024;
        }
        DSAParameterSpec dSAParameterSpec = (DSAParameterSpec)this.params;
        return this.generateDSAKeyPair(this.token, PQGParams.BigIntegerToUnsignedByteArray(dSAParameterSpec.getP()), PQGParams.BigIntegerToUnsignedByteArray(dSAParameterSpec.getQ()), PQGParams.BigIntegerToUnsignedByteArray(dSAParameterSpec.getG()), this.temporaryPairMode);
    }

    public boolean keygenOnInternalToken() {
        return this.mKeygenOnInternalToken;
    }

    private native KeyPair generateRSAKeyPair(PK11Token var1, int var2, long var3, boolean var5) throws TokenException;

    private native KeyPair generateDSAKeyPair(PK11Token var1, byte[] var2, byte[] var3, byte[] var4, boolean var5) throws TokenException;

    private static synchronized void testDefaults() {
    }

    public void temporaryPairs(boolean bl) {
        this.temporaryPairMode = bl;
    }
}

