/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.asn1;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.mozilla.jss.asn1.ASN1Header;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.util.Assert;

public class CHOICE
implements ASN1Value {
    private Tag tag;
    private ASN1Value val;

    private CHOICE() {
    }

    public CHOICE(Tag tag, ASN1Value aSN1Value) {
        this.tag = tag;
        this.val = aSN1Value;
    }

    public CHOICE(ASN1Value aSN1Value) {
        this.tag = aSN1Value.getTag();
        this.val = aSN1Value;
    }

    public Tag getTag() {
        return this.tag;
    }

    public ASN1Value getValue() {
        return this.val;
    }

    public static Template getTemplate() {
        return new Template();
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.val.encode(this.tag, outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        Assert._assert(tag.equals(this.tag));
        this.val.encode(this.tag, outputStream);
    }

    public static class Template
    implements ASN1Template {
        private Vector templates = new Vector();

        public void addElement(ASN1Template aSN1Template) {
            this.templates.addElement(new Element(aSN1Template));
        }

        public void addElement(Tag tag, ASN1Template aSN1Template) {
            this.templates.addElement(new Element(tag, aSN1Template));
        }

        public int size() {
            return this.templates.size();
        }

        public ASN1Template elementAt(int n) {
            return ((Element)this.templates.elementAt(n)).getTemplate();
        }

        public Tag implicitTagAt(int n) {
            return ((Element)this.templates.elementAt(n)).getImplicitTag();
        }

        public void removeAllElements() {
            this.templates.removeAllElements();
        }

        public void removeElementAt(int n) {
            this.templates.removeElementAt(n);
        }

        public boolean tagMatch(Tag tag) {
            int n = this.size();
            int n2 = 0;
            while (n2 < n) {
                ASN1Template aSN1Template;
                Tag tag2 = this.implicitTagAt(n2);
                if (tag2 != null ? tag2.equals(tag) : (aSN1Template = this.elementAt(n2)).tagMatch(tag)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public ASN1Value decode(InputStream inputStream) throws IOException, InvalidBERException {
            ASN1Header aSN1Header = ASN1Header.lookAhead(inputStream);
            Tag tag = aSN1Header.getTag();
            int n = this.size();
            int n2 = 0;
            while (n2 < n) {
                if (this.implicitTagAt(n2) != null) {
                    if (this.implicitTagAt(n2).equals(tag)) {
                        ASN1Value aSN1Value = this.elementAt(n2).decode(this.implicitTagAt(n2), inputStream);
                        return new CHOICE(this.implicitTagAt(n2), aSN1Value);
                    }
                } else if (this.elementAt(n2).tagMatch(tag)) {
                    return new CHOICE(this.elementAt(n2).decode(inputStream));
                }
                ++n2;
            }
            throw new InvalidBERException("Unable to decode CHOICE");
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws IOException, InvalidBERException {
            return this.decode(inputStream);
        }

        private static class Element {
            private ASN1Template template;
            private Tag implicitTag = null;

            public Element(ASN1Template aSN1Template) {
                this.template = aSN1Template;
            }

            public Element(Tag tag, ASN1Template aSN1Template) {
                this.template = aSN1Template;
                this.implicitTag = tag;
            }

            public ASN1Template getTemplate() {
                return this.template;
            }

            public Tag getImplicitTag() {
                return this.implicitTag;
            }
        }
    }
}

