/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.util.StringTokenizer;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.InternalCertificate;
import org.mozilla.jss.crypto.X509Certificate;

public class ModifyTrust {
    public static final String VALID_PEER = "p";
    public static final String TRUSTED_PEER = "P";
    public static final String VALID_CA = "c";
    public static final String TRUSTED_CA = "C";
    public static final String USER = "u";
    public static final String TRUSTED_CLIENT_CA = "T";
    public static final String NO_TRUST = "N";

    public static String getTrust(X509Certificate x509Certificate) {
        try {
            InternalCertificate internalCertificate = (InternalCertificate)x509Certificate;
            return ModifyTrust.getTrustStr(internalCertificate.getSSLTrust(), true) + "," + ModifyTrust.getTrustStr(internalCertificate.getEmailTrust()) + "," + ModifyTrust.getTrustStr(internalCertificate.getObjectSigningTrust());
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static int getTrust(String string) {
        char[] cArray = new char[string.length()];
        string.getChars(0, string.length(), cArray, 0);
        int n = 0;
        String string2 = "";
        int n2 = 0;
        while (n2 < cArray.length) {
            block11: {
                int n3;
                block5: {
                    block10: {
                        block9: {
                            block8: {
                                block7: {
                                    block6: {
                                        block4: {
                                            string2 = new Character(cArray[n2]).toString();
                                            if (!string2.equals(VALID_PEER)) break block4;
                                            n3 = 1;
                                            break block5;
                                        }
                                        if (!string2.equals(TRUSTED_PEER)) break block6;
                                        n3 = 2;
                                        break block5;
                                    }
                                    if (!string2.equals(VALID_CA)) break block7;
                                    n3 = 8;
                                    break block5;
                                }
                                if (!string2.equals(TRUSTED_CLIENT_CA)) break block8;
                                n3 = 136;
                                break block5;
                            }
                            if (!string2.equals(TRUSTED_CA)) break block9;
                            n3 = 24;
                            break block5;
                        }
                        if (!string2.equals(USER)) break block10;
                        n3 = 64;
                        break block5;
                    }
                    if (!string2.equals(NO_TRUST)) break block11;
                    n3 = 0;
                }
                n = n2 == 0 ? n3 : (n |= n3);
            }
            ++n2;
        }
        return n;
    }

    public static String getTrustStr(int n) {
        return ModifyTrust.getTrustStr(n, false);
    }

    public static String getTrustStr(int n, boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        String string = "";
        if ((0x18 & n) == 24) {
            string = string + TRUSTED_CA;
            bl2 = true;
        }
        if ((0x88 & n) == 136) {
            string = string + TRUSTED_CLIENT_CA;
            if (bl) {
                bl3 = true;
            }
        }
        if ((2 & n) == 2) {
            string = string + TRUSTED_PEER;
            bl4 = false;
        }
        if ((0x40 & n) == 64) {
            string = string + USER;
        }
        if ((8 & n) == 8 && !bl2 && !bl3) {
            string = string + VALID_CA;
        }
        if ((1 & n) == 1 && !bl4) {
            string = string + VALID_PEER;
        }
        return string;
    }

    public static X509Certificate changeCertificateTrust(X509Certificate x509Certificate, String string, String string2, String string3) throws Exception {
        int n = ModifyTrust.getTrust(string);
        int n2 = ModifyTrust.getTrust(string2);
        int n3 = ModifyTrust.getTrust(string3);
        System.out.println("Trust" + string + n + string2 + n2 + string3 + n3);
        try {
            InternalCertificate internalCertificate = (InternalCertificate)x509Certificate;
            internalCertificate.setSSLTrust(n);
            internalCertificate.setEmailTrust(n2);
            internalCertificate.setObjectSigningTrust(n3);
            return internalCertificate;
        }
        catch (Exception exception) {
            return x509Certificate;
        }
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length != 3) {
                System.out.println("Usage: ModifyTrust <dbdir> <nickname> <TrustFlags>");
                System.out.println("Trust flags in form \"C,C,C,\" use N for no trust flag");
                System.out.println("as in \"C,N,N\" to get \"C,,\"");
                return;
            }
            String string = stringArray[0];
            String string2 = stringArray[1];
            String string3 = stringArray[2];
            CryptoManager.initialize(string);
            CryptoManager cryptoManager = CryptoManager.getInstance();
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
            if (stringTokenizer.countTokens() != 3) {
                System.out.println("Invalid trust attribute " + string3 + " specified ");
                return;
            }
            System.out.println("Finding Cert");
            X509Certificate x509Certificate = cryptoManager.findCertByNickname(string2);
            System.out.println("Modify trust attributes");
            X509Certificate x509Certificate2 = ModifyTrust.changeCertificateTrust(x509Certificate, stringTokenizer.nextToken().trim(), stringTokenizer.nextToken().trim(), stringTokenizer.nextToken().trim());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

