/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.asn1;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Header;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BIT_STRING;
import org.mozilla.jss.asn1.BOOLEAN;
import org.mozilla.jss.asn1.CHOICE;
import org.mozilla.jss.asn1.CharacterString;
import org.mozilla.jss.asn1.CountingStream;
import org.mozilla.jss.asn1.ENUMERATED;
import org.mozilla.jss.asn1.EXPLICIT;
import org.mozilla.jss.asn1.Form;
import org.mozilla.jss.asn1.IA5String;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.NULL;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.PrintableString;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.util.Assert;

public class SEQUENCE
extends SET
implements ASN1Value {
    public static final Tag TAG = new Tag(Tag.Class.UNIVERSAL, 16L);

    public Tag getTag() {
        return TAG;
    }

    public static Template getTemplate() {
        return new Template();
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        this.BERencode(tag, outputStream);
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length > 0) {
                Template template = new Template();
                template.addOptionalElement(new Tag(15L), new INTEGER.Template());
                template.addElement(new Tag(16L), new INTEGER.Template(), new INTEGER(42L));
                template.addElement(new INTEGER.Template());
                template.addElement(new BOOLEAN.Template());
                template.addElement(new INTEGER.Template());
                template.addOptionalElement(new Tag(12L), new INTEGER.Template());
                template.addElement(new BOOLEAN.Template());
                template.addElement(new Tag(13L), new INTEGER.Template(), new INTEGER(53L));
                template.addElement(new INTEGER.Template());
                template.addElement(new INTEGER.Template());
                template.addOptionalElement(new Tag(14L), new INTEGER.Template());
                template.addElement(new OBJECT_IDENTIFIER.Template());
                template.addElement(new NULL.Template());
                template.addElement(new EXPLICIT.Template(new Tag(27L), new INTEGER.Template()));
                template.addElement(new ENUMERATED.Template());
                template.addElement(new OCTET_STRING.Template());
                template.addElement(new IA5String.Template());
                CHOICE.Template template2 = new CHOICE.Template();
                template2.addElement(new Tag(23L), new INTEGER.Template());
                template2.addElement(new BOOLEAN.Template());
                template.addElement(template2);
                template.addElement(new BIT_STRING.Template());
                template.addElement(new ANY.Template());
                template.addElement(new PrintableString.Template());
                template.addElement(new OF_Template(new INTEGER.Template()));
                template.addElement(new OF_Template(new INTEGER.Template()));
                FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
                System.out.println("Available: " + fileInputStream.available());
                byte[] byArray = new byte[fileInputStream.available()];
                ASN1Util.readFully(byArray, fileInputStream);
                SET sET = null;
                int n = 0;
                while (n < 1) {
                    sET = (SEQUENCE)template.decode(new ByteArrayInputStream(byArray));
                    ++n;
                }
                int n2 = 0;
                while (n2 < sET.size()) {
                    ASN1Value aSN1Value;
                    ASN1Value aSN1Value2 = sET.elementAt(n2);
                    if (aSN1Value2 instanceof ENUMERATED) {
                        aSN1Value = (ENUMERATED)aSN1Value2;
                        System.out.println("ENUMERATED: " + aSN1Value);
                    } else if (aSN1Value2 instanceof INTEGER) {
                        aSN1Value = (INTEGER)aSN1Value2;
                        System.out.println("INTEGER: " + aSN1Value);
                    } else if (aSN1Value2 instanceof BOOLEAN) {
                        aSN1Value = (BOOLEAN)aSN1Value2;
                        System.out.println("BOOLEAN: " + aSN1Value);
                    } else if (aSN1Value2 instanceof OBJECT_IDENTIFIER) {
                        aSN1Value = (OBJECT_IDENTIFIER)aSN1Value2;
                        System.out.println("OID: " + aSN1Value);
                    } else if (aSN1Value2 instanceof NULL) {
                        aSN1Value = (NULL)aSN1Value2;
                        System.out.println("NULL");
                    } else if (aSN1Value2 instanceof EXPLICIT) {
                        aSN1Value = (EXPLICIT)aSN1Value2;
                        INTEGER iNTEGER = (INTEGER)((EXPLICIT)aSN1Value).getContent();
                        System.out.println("EXPLICIT [" + ((EXPLICIT)aSN1Value).getTag() + "]: " + "INTEGER: " + iNTEGER);
                    } else if (aSN1Value2 instanceof OCTET_STRING) {
                        aSN1Value = (OCTET_STRING)aSN1Value2;
                        byte[] byArray2 = ((OCTET_STRING)aSN1Value).toByteArray();
                        System.out.print("OCTET_STRING: ");
                        int n3 = 0;
                        while (n3 < byArray2.length) {
                            System.out.print(byArray2[n3] + " ");
                            ++n3;
                        }
                        System.out.println("");
                    } else if (aSN1Value2 instanceof CharacterString) {
                        aSN1Value = (CharacterString)aSN1Value2;
                        System.out.println("String: " + aSN1Value);
                    } else if (aSN1Value2 instanceof BIT_STRING) {
                        aSN1Value = (BIT_STRING)aSN1Value2;
                        System.out.print("BIT_STRING: padCount=" + ((BIT_STRING)aSN1Value).getPadCount() + " : ");
                        byte[] byArray3 = ((BIT_STRING)aSN1Value).getBits();
                        int n4 = 0;
                        while (n4 < byArray3.length) {
                            System.out.print(byArray3[n4] + " ");
                            ++n4;
                        }
                        System.out.println("");
                    } else if (aSN1Value2 instanceof ANY) {
                        aSN1Value = (ANY)aSN1Value2;
                        Tag tag = ((ANY)aSN1Value).getTag();
                        System.out.println("Got ANY, tag is " + tag);
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((ANY)aSN1Value).getEncoded());
                        INTEGER iNTEGER = (INTEGER)new INTEGER.Template().decode(byteArrayInputStream);
                        System.out.println("    INTEGER: " + iNTEGER);
                    } else if (aSN1Value2 instanceof SEQUENCE) {
                        aSN1Value = (SEQUENCE)aSN1Value2;
                        System.out.println("SEQUENCE: ");
                        int n5 = 0;
                        while (n5 < ((SET)aSN1Value).size()) {
                            INTEGER iNTEGER = (INTEGER)((SET)aSN1Value).elementAt(n5);
                            System.out.println("    INTEGER: " + iNTEGER);
                            ++n5;
                        }
                    } else {
                        System.out.println("Unknown value");
                    }
                    ++n2;
                }
            } else {
                SEQUENCE sEQUENCE = new SEQUENCE();
                sEQUENCE.addElement(new INTEGER(5L));
                sEQUENCE.addElement(new BOOLEAN(true));
                sEQUENCE.addElement(new INTEGER(-322L));
                sEQUENCE.addElement(new BOOLEAN(false));
                sEQUENCE.addElement(new INTEGER(0L));
                sEQUENCE.addElement(new INTEGER("2934293834242"));
                sEQUENCE.addElement(new OBJECT_IDENTIFIER(new long[]{1L, 2L, 127L, 563L, 1231982L}));
                sEQUENCE.addElement(new NULL());
                sEQUENCE.addElement(new EXPLICIT(new Tag(27L), new INTEGER(39L)));
                sEQUENCE.addElement(new ENUMERATED(983L));
                sEQUENCE.addElement(new OCTET_STRING(new byte[]{0, -1, -52}));
                sEQUENCE.addElement(new IA5String("foobar"));
                sEQUENCE.addElement(new Tag(23L), new INTEGER(234L));
                byte[] byArray = new byte[]{-128, -1, 15};
                sEQUENCE.addElement(new BIT_STRING(byArray, 3));
                sEQUENCE.addElement(new INTEGER(82734L));
                sEQUENCE.addElement(new PrintableString("I'm printable??"));
                SEQUENCE sEQUENCE2 = new SEQUENCE();
                sEQUENCE2.addElement(new INTEGER(5L));
                sEQUENCE2.addElement(new INTEGER(6L));
                sEQUENCE.addElement(sEQUENCE2);
                sEQUENCE2 = new SEQUENCE();
                sEQUENCE.addElement(sEQUENCE2);
                sEQUENCE.encode(System.out);
                System.out.flush();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static class OF_Template
    implements ASN1Template {
        Template template;

        private OF_Template() {
        }

        public OF_Template(ASN1Template aSN1Template) {
            this.template = new Template();
            Template.Element element = new Template.Element(null, aSN1Template, true);
            element.makeRepeatable();
            this.template.addElement(element);
        }

        public static OF_Template makeOutputlessOFTemplate(ASN1Template aSN1Template) {
            OF_Template oF_Template = new OF_Template();
            oF_Template.template = new Template();
            Template.Element element = new Template.Element(null, aSN1Template, true, false);
            element.makeRepeatable();
            oF_Template.template.addElement(element);
            return oF_Template;
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        public ASN1Value decode(InputStream inputStream) throws IOException, InvalidBERException {
            return this.template.decode(inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws IOException, InvalidBERException {
            return this.template.decode(tag, inputStream);
        }
    }

    public static class Template
    implements ASN1Template {
        private Vector elements = new Vector();

        private void addElement(Element element) {
            this.elements.addElement(element);
        }

        private void insertElementAt(Element element, int n) {
            this.elements.insertElementAt(element, n);
        }

        public void addElement(ASN1Template aSN1Template) {
            this.addElement(new Element(null, aSN1Template, false));
        }

        public void insertElementAt(ASN1Template aSN1Template, int n) {
            this.insertElementAt(new Element(null, aSN1Template, false), n);
        }

        public void addElement(Tag tag, ASN1Template aSN1Template) {
            this.addElement(new Element(tag, aSN1Template, false));
        }

        public void insertElementAt(Tag tag, ASN1Template aSN1Template, int n) {
            this.insertElementAt(new Element(tag, aSN1Template, false), n);
        }

        public void addOptionalElement(ASN1Template aSN1Template) {
            this.addElement(new Element(null, aSN1Template, true));
        }

        public void insertOptionalElementAt(ASN1Template aSN1Template, int n) {
            this.insertElementAt(new Element(null, aSN1Template, true), n);
        }

        public void addOptionalElement(Tag tag, ASN1Template aSN1Template) {
            this.addElement(new Element(tag, aSN1Template, true));
        }

        public void insertOptionalElementAt(Tag tag, ASN1Template aSN1Template, int n) {
            this.insertElementAt(new Element(tag, aSN1Template, true), n);
        }

        public void addElement(ASN1Template aSN1Template, ASN1Value aSN1Value) {
            this.addElement(new Element(null, aSN1Template, aSN1Value));
        }

        public void insertElementAt(ASN1Template aSN1Template, ASN1Value aSN1Value, int n) {
            this.insertElementAt(new Element(null, aSN1Template, aSN1Value), n);
        }

        public void addElement(Tag tag, ASN1Template aSN1Template, ASN1Value aSN1Value) {
            this.addElement(new Element(tag, aSN1Template, aSN1Value));
        }

        public void insertElementAt(Tag tag, ASN1Template aSN1Template, ASN1Value aSN1Value, int n) {
            this.insertElementAt(new Element(tag, aSN1Template, aSN1Value), n);
        }

        public Tag implicitTagAt(int n) {
            return ((Element)this.elements.elementAt(n)).getImplicitTag();
        }

        public ASN1Template templateAt(int n) {
            return ((Element)this.elements.elementAt(n)).getTemplate();
        }

        public boolean isOptionalAt(int n) {
            return ((Element)this.elements.elementAt(n)).isOptional();
        }

        public ASN1Value defaultAt(int n) {
            return ((Element)this.elements.elementAt(n)).getDefault();
        }

        public int size() {
            return this.elements.size();
        }

        public void removeAllElements() {
            this.elements.removeAllElements();
        }

        public void removeElementAt(int n) {
            this.elements.removeElementAt(n);
        }

        Tag getTag() {
            return TAG;
        }

        public boolean tagMatch(Tag tag) {
            return tag.equals(TAG);
        }

        public ASN1Value decode(InputStream inputStream) throws IOException, InvalidBERException {
            return this.decode(this.getTag(), inputStream);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public ASN1Value decode(Tag tag, InputStream inputStream) throws IOException, InvalidBERException {
            int n = 0;
            try {
                ASN1Header aSN1Header = new ASN1Header(inputStream);
                aSN1Header.validate(tag, Form.CONSTRUCTED);
                long l = aSN1Header.getContentLength();
                boolean bl = false;
                SEQUENCE sEQUENCE = new SEQUENCE();
                ASN1Header aSN1Header2 = null;
                n = 0;
                while (true) {
                    block16: {
                        Object object;
                        Element element;
                        block17: {
                            block18: {
                                if (n >= this.size()) {
                                    if (l <= 0L) break;
                                    throw new InvalidBERException("SEQUENCE is " + l + " bytes longer than expected");
                                }
                                aSN1Header2 = l == 0L ? null : ASN1Header.lookAhead(inputStream);
                                element = (Element)this.elements.elementAt(n);
                                if (aSN1Header2 != null && !aSN1Header2.isEOC() && element.tagMatch(aSN1Header2.getTag())) break block17;
                                if (!element.isRepeatable()) break block18;
                                bl = true;
                                break block16;
                            }
                            if (element.isOptional()) {
                                object = new org.mozilla.jss.asn1.SEQUENCE$Element(null, null);
                                sEQUENCE.addElement(null);
                                break block16;
                            } else if (element.getDefault() != null) {
                                sEQUENCE.addElement(element.getDefault());
                                break block16;
                            } else {
                                if (aSN1Header2 == null) {
                                    object = "(null)";
                                    throw new InvalidBERException("Missing item #" + n + ": found " + (String)object);
                                }
                                object = aSN1Header2.getTag().toString();
                                throw new InvalidBERException("Missing item #" + n + ": found " + (String)object);
                            }
                        }
                        object = element.getTemplate();
                        CountingStream countingStream = new CountingStream(inputStream);
                        ASN1Value aSN1Value = element.getImplicitTag() == null ? object.decode(countingStream) : object.decode(element.getImplicitTag(), countingStream);
                        long l2 = countingStream.getNumRead();
                        if (l != -1L) {
                            if (l < l2) {
                                throw new InvalidBERException("Item went " + (l2 - l) + " bytes past the end of" + " the SEQUENCE");
                            }
                            l -= l2;
                        }
                        if (element.producesOutput()) {
                            if (element.getImplicitTag() == null) {
                                sEQUENCE.addElement(aSN1Value);
                            } else {
                                sEQUENCE.addElement(element.getImplicitTag(), aSN1Value);
                            }
                        }
                        if (element.isRepeatable()) {
                            bl = true;
                            --n;
                        }
                    }
                    ++n;
                }
                Assert._assert(l == 0L || l == -1L);
                if (l == -1L && !(aSN1Header2 = new ASN1Header(inputStream)).isEOC()) {
                    throw new InvalidBERException("No end-of-contents marker");
                }
                if (bl) return sEQUENCE;
                Assert._assert(n == sEQUENCE.size());
                return sEQUENCE;
            }
            catch (InvalidBERException invalidBERException) {
                invalidBERException.append("SEQUENCE(item #" + n + ")");
                throw invalidBERException;
            }
        }

        static class Element {
            private boolean doesProduceOutput = true;
            private boolean repeatable;
            private boolean optional;
            private Tag implicitTag = null;
            private ASN1Template type;
            private ASN1Value defaultVal = null;

            public Element(Tag tag, ASN1Template aSN1Template, boolean bl) {
                this(tag, aSN1Template, bl, true);
            }

            public Element(Tag tag, ASN1Template aSN1Template, boolean bl, boolean bl2) {
                this.type = aSN1Template;
                this.defaultVal = null;
                this.optional = bl;
                this.implicitTag = tag;
                this.doesProduceOutput = bl2;
            }

            public Element(Tag tag, ASN1Template aSN1Template, ASN1Value aSN1Value) {
                this.type = aSN1Template;
                this.defaultVal = aSN1Value;
                this.optional = false;
                this.implicitTag = tag;
            }

            boolean producesOutput() {
                return this.doesProduceOutput;
            }

            void makeRepeatable() {
                this.repeatable = true;
            }

            boolean isRepeatable() {
                return this.repeatable;
            }

            public boolean isOptional() {
                return this.optional;
            }

            public Tag getImplicitTag() {
                return this.implicitTag;
            }

            public boolean tagMatch(Tag tag) {
                if (this.implicitTag != null) {
                    return this.implicitTag.equals(tag);
                }
                return this.type.tagMatch(tag);
            }

            public ASN1Template getTemplate() {
                return this.type;
            }

            public ASN1Value getDefault() {
                return this.defaultVal;
            }
        }
    }

    private static class Element
    extends SET.Element {
        public Element(ASN1Value aSN1Value) {
            super(aSN1Value);
        }

        public Element(Tag tag, ASN1Value aSN1Value) {
            super(tag, aSN1Value);
        }
    }
}

