<%@ page contentType="application/x-java-jnlp-file" %>
<?xml version="1.0" encoding="utf-8"?>
<!-- JNLP File for IM Application -->
<%
 String locale = (String)request.getAttribute("locale");
 String g_url = (String)request.getAttribute("gateway_url");
 String dname = (String)request.getAttribute("domain");
 String invite = (String)request.getAttribute("auto_invite");
 String uid = (String)request.getAttribute("uid");
 String token = (String)request.getAttribute("token");
 String usessl = (String)request.getAttribute("use_ssl");
 String archive = (String)request.getAttribute("archive_control");
 String server = (String)request.getAttribute("server");
 String codebase = (String)request.getAttribute("codebase");

 //Required for backward compatibilty
 if (invite == null) 
    invite = request.getParameter("username");

 if (server == null) 
    server = request.getParameter("server");
 
 if (locale == null) 
    locale = request.getLocale().toString();
 
 if (codebase == null) {
    StringBuffer url = request.getRequestURL(); 
    codebase = url.substring(0,url.lastIndexOf("/"));
 }

%>

<jnlp
  spec="1.0+"
  codebase="<%= codebase %>">
  <information>
    <title>Sun Java System Instant Messenger</title>
    <vendor>Sun Microsystems, Inc.</vendor>
    <homepage href="help/getstart.htm"/>
    <description>Sun Java System Instant Messenger</description>
    <description kind="short">Instant Messenger</description>
    <icon href="IM_JLF32x.gif"/>
    <offline-allowed/>
  </information>
  <security>
    <all-permissions/>
  </security>
  <resources>
    <j2se version="1.3+">
      <resources>
        <jar href="<%= locale %>/imres.jar"/>
        <jar href="<%= locale %>/imbrand.jar"/>
      </resources>
    </j2se>
    <jar href="messenger.jar"/>
    <jar href="imdesktop.jar"/>
    <jar href="imnet.jar"/>
    <jar href="icalendar.jar"/>
<%
if ((usessl != null) && (usessl.equalsIgnoreCase("true"))) {
%>
    <jar href="jsse.jar"/>
    <jar href="jcert.jar"/>
    <jar href="jnet.jar"/>
<% } %>
    <nativelib href="imjni.jar"/>
  </resources>
  <application-desc main-class="com.iplanet.im.client.iIM">
    <argument>server=<%= server %></argument>
<% if (uid != null) { %>
    <argument>uid=<%= uid %></argument>
<% }
   if (token != null) { %>
    <argument>token=<%= token %></argument>
<% } 
    if (locale != null) { %>
    <argument>locale=<%= locale %></argument>
<% } 
    if (usessl != null) { %>
    <argument>usessl=<%= usessl %></argument>
<% } 
    if (archive != null) { %>
    <argument>archive_control=<%= archive %></argument>
<% }
   if (dname != null) { %>
    <argument>domain=<%= dname %></argument>
<% } 
    if (invite != null) { %>
    <argument>autoinvite=<%= invite %></argument>
<% } 
    if (g_url != null) { %>
    <argument>gateway_url=<%= g_url %></argument>
<% } %>
    <argument>help_codebase=<%= request.getAttribute("help_codebase") %></argument>
  </application-desc>
</jnlp>
