/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.api;

import com.iplanet.im.client.api.iIMConference;
import com.iplanet.im.client.api.iIMMessage;
import com.iplanet.im.client.api.iIMSession;
import com.iplanet.im.client.api.iIMSessionFactory;
import com.iplanet.im.net.Destination;
import com.iplanet.im.net.Message;
import com.iplanet.im.net.MessageEvent;
import com.iplanet.im.net.MessageListener;
import com.iplanet.im.net.Topic;
import com.iplanet.im.net.TopicMsg;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.ConferenceListener;
import com.sun.im.service.InviteMessage;
import com.sun.im.service.NewsChannel;
import com.sun.im.service.NewsChannelListener;

public class iIMNewsChannel
extends iIMConference
implements NewsChannel,
MessageListener {
    public iIMNewsChannel(iIMSession s, Topic t, NewsChannelListener listener) throws CollaborationException {
        super(s, (Destination)t, (ConferenceListener)listener, null);
    }

    public iIMNewsChannel(iIMSession s, String destination, NewsChannelListener listener, int defaultAccess) throws CollaborationException {
        super(s);
        this._listener = listener;
        this.createNewTopic(destination, defaultAccess);
        this._join();
    }

    public iIMNewsChannel(iIMSession s, Topic t) throws CollaborationException {
        super(s, (Destination)t);
    }

    private void createNewTopic(String destination, int accessLevel) throws CollaborationException {
        this._destination = new Topic(destination, this._session.connectionFactory.getServerName());
        this._session.connectionFactory.addTopic((Topic)this._destination);
        this._setAccess(accessLevel);
    }

    public void addMessage(com.sun.im.service.Message message) throws CollaborationException {
        this._join();
        this._session.connectionFactory.addMsg(((iIMMessage)message).getNetMessage());
        this._messages.put(message.getMessageId(), message);
    }

    public void removeMessage(String messageId) throws CollaborationException {
        iIMMessage m = (iIMMessage)((Object)this._messages.get(messageId));
        if (m != null) {
            this._join();
            this._session.connectionFactory.delMsg((Destination)((Topic)this._destination), m.getNetMessage());
            this._messages.remove(messageId);
        }
    }

    public void messageAdded(MessageEvent e) {
        iIMSessionFactory.debug("message received in New channel " + this._destination.getUID());
        iIMMessage m = new iIMMessage(this._session, e.getMsg());
        if (this._listener != null) {
            this._listener.onMessageAdded((com.sun.im.service.Message)m);
        }
        this._messages.put(m.getMessageId(), m);
    }

    public void messageDeleted(MessageEvent e) {
        iIMMessage m = (iIMMessage)((Object)this._messages.get(e.getMsgId()));
        if (m != null) {
            if (this._listener != null) {
                ((NewsChannelListener)this._listener).onMessageRemoved(m.getMessageId());
            }
            this._messages.remove(m.getMessageId());
        }
    }

    public void close() throws CollaborationException {
        this._listener = null;
        this._session.connectionFactory.delTopic((Topic)this._destination);
    }

    public void modifyMessage(String messageId, com.sun.im.service.Message message) throws CollaborationException {
    }

    public com.sun.im.service.Message createMessage() {
        TopicMsg newMsg = new TopicMsg();
        newMsg.addTo((Destination)((Topic)this._destination));
        return new iIMMessage(this._session, (Message)newMsg);
    }

    public InviteMessage createInviteMessage() {
        return null;
    }

    public void subscribe(NewsChannelListener listener) throws CollaborationException {
        this._listener = listener;
        this._join();
    }

    public String getDestination() {
        return this._destination.getUID().substring(6);
    }
}

