/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.api;

import com.iplanet.im.client.api.iIMSession;
import com.iplanet.im.client.api.iIMSessionFactory;
import com.iplanet.im.net.BaseMessageImpl;
import com.iplanet.im.net.Destination;
import com.iplanet.im.net.Message;
import com.iplanet.im.net.MessagePartImpl;
import com.iplanet.im.net.QueueMsg;
import com.iplanet.im.net.Room;
import com.iplanet.im.net.RoomMsg;
import com.iplanet.im.net.Topic;
import com.iplanet.im.net.TopicMsg;
import com.iplanet.im.net.iIMQueue;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.InviteMessage;
import com.sun.im.service.MessagePart;
import com.sun.im.service.Poll;

public class iIMMessage
extends BaseMessageImpl
implements InviteMessage {
    private iIMSession _session;
    private boolean _received;

    public iIMMessage(iIMSession s, Message m) {
        super(m);
        this._session = s;
        this._received = true;
    }

    public iIMMessage(iIMSession s, Destination destination, Destination originator) throws CollaborationException {
        this._session = s;
        if (destination instanceof Room) {
            ((MessagePartImpl)this)._message = new RoomMsg();
        } else if (destination instanceof Topic) {
            ((MessagePartImpl)this)._message = new TopicMsg();
        } else if (destination instanceof iIMQueue) {
            ((MessagePartImpl)this)._message = new QueueMsg();
        } else {
            throw new CollaborationException("Unknown destination format");
        }
        ((MessagePartImpl)this)._message.setFrom(originator);
        ((MessagePartImpl)this)._message.addTo(destination);
        this._received = false;
    }

    public iIMMessage(iIMSession s, Destination originator) throws CollaborationException {
        ((MessagePartImpl)this)._message = new QueueMsg();
        this._session = s;
        ((MessagePartImpl)this)._message.setFrom(originator);
    }

    public MessagePart newPart() throws CollaborationException {
        if (this.getContent() == null) {
            return this;
        }
        return new MessagePartImpl(false);
    }

    public void addRecipient(String destination) throws CollaborationException {
        iIMQueue q = this._session.createQueue(destination);
        ((MessagePartImpl)this)._message.addTo((Destination)q);
    }

    public void removeRecipient(String destination) throws CollaborationException {
    }

    protected Message getNetMessage() {
        return ((MessagePartImpl)this)._message;
    }

    public void sendStatus(int status) throws CollaborationException {
        if (!this._received) {
            throw new CollaborationException("Invalid operation : cannot acknowledge a message that was not received");
        }
        switch (status) {
            case 7: {
                this._session.connectionFactory.markRead(((MessagePartImpl)this)._message);
                break;
            }
        }
    }

    public void sendReply(com.sun.im.service.Message message) throws CollaborationException {
        if (!this._received) {
            throw new CollaborationException("Invalid operation : cannot acknowledge a message that was not received");
        }
        QueueMsg reply = (QueueMsg)((iIMMessage)message).getNetMessage();
        try {
            reply.setCorrelationMsgId(((MessagePartImpl)this)._message.getMsgid());
            if (((MessagePartImpl)this)._message.getContentType().equals("net/poll")) {
                reply.setContentType("net/pollreply");
                Poll ph = this._session.getPoll(((MessagePartImpl)this)._message.getMsgid());
                String answer = (String)reply.getBody();
                iIMSessionFactory.debug("Sending poll response: " + answer);
                byte[] buf = answer.getBytes();
                reply.setBody((Object)ph.parseAnswer(answer));
                reply.setSubject(((MessagePartImpl)this)._message.getSubject());
            } else {
                reply.setContentType("net/reply");
            }
            this._session.connectionFactory.addMsg((Message)reply);
        }
        catch (Exception e) {
            throw new CollaborationException(e.toString());
        }
    }

    protected iIMSession getSession() {
        return this._session;
    }

    public void rsvp(com.sun.im.service.Message message, boolean accepted) throws CollaborationException {
    }

    public void rsvp(boolean accepted) throws CollaborationException {
    }

    public void setOriginator(String originator) throws CollaborationException {
        ((MessagePartImpl)this)._message.setFrom((Destination)this._session.createQueue(originator));
    }
}

