/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service;

import com.sun.im.service.Presence;
import com.sun.im.service.PresenceTuple;
import com.sun.im.service.XMLProcessingException;
import com.sun.im.service.XMLUtil;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PresenceHelper {
    private Presence _presentity = null;
    public static final String ELEMENT_PRESENCE = "presence";
    public static final String ELEMENT_TUPLE = "tuple";
    public static final String ELEMENT_NOTE = "note";
    public static final String ELEMENT_STATUS = "status";
    public static final String ELEMENT_CONTACT = "contact";
    public static final String ELEMENT_BASIC = "basic";
    public static final String ELEMENT_XSTATUS = "xstatus";
    public static final String ELEMENT_TIMESTAMP = "timestamp";
    public static final String ATTRIBUTE_ENTITY = "entity";
    public static final String ATTRIBUTE_ID = "id";
    public static final String ATTRIBUTE_LANG = "lang";
    public static final String ATTRIBUTE_PRIORITY = "priority";
    public static final String XMLNS_PIDF_URI = "urn:ietf:params:xml:ns:cpim-pidf";
    public static final String XMLNS_ICP_URI = "urn:sun:icp:xml:ns:cpim-pidf";
    public static final String PIDF_XMLNS = "";
    public static final String ICP_XMLNS = "icp:";

    public PresenceHelper(Presence p) throws XMLProcessingException {
        this._presentity = p;
    }

    public PresenceHelper(InputStream in) throws XMLProcessingException, IOException {
        Document doc = XMLUtil.parse(in);
        Element e = doc.getDocumentElement();
        this._presentity = this.buildPresence(e);
    }

    public PresenceHelper(String pi) throws XMLProcessingException {
        Document doc = XMLUtil.parse(pi);
        Element e = doc.getDocumentElement();
        this._presentity = this.buildPresence(e);
    }

    private Presence buildPresence(Element element) throws XMLProcessingException {
        Presence p = null;
        NamedNodeMap attrs = element.getAttributes();
        if (attrs == null) {
            throw new XMLProcessingException("No attributes in root element");
        }
        Node n = attrs.getNamedItem(ATTRIBUTE_ENTITY);
        if (n != null) {
            String id = n.getNodeValue();
            p = new Presence(id);
            int i = 0;
            while (i < attrs.getLength()) {
                String nsURI;
                n = attrs.item(i);
                if (XMLUtil.isNamespaceAttribute(n) && !(nsURI = n.getNodeValue()).equals(XMLNS_PIDF_URI) && !nsURI.equals(XMLNS_ICP_URI)) {
                    String name = n.getNodeName();
                    if (name.startsWith("xmlns:")) {
                        name = name.substring(6);
                        p.addNamespace(name, nsURI);
                    } else {
                        throw new XMLProcessingException("Invalid namespace: " + name + "=" + nsURI);
                    }
                }
                ++i;
            }
            NodeList nl = element.getChildNodes();
            int i2 = 0;
            while (i2 < nl.getLength()) {
                Node ni = nl.item(i2);
                if (ni instanceof Element) {
                    Element elt = (Element)ni;
                    if (elt.getNodeName().equals(ELEMENT_TUPLE)) {
                        p.addTuple(this.buildTuple(elt));
                    } else if (elt.getNodeName().equals(ELEMENT_NOTE)) {
                        NamedNodeMap nnm = elt.getAttributes();
                        Node nc = nnm.getNamedItem(ATTRIBUTE_LANG);
                        if (nc != null) {
                            String lang = nc.getNodeValue();
                            p.addNote(lang, XMLUtil.getElementText(elt));
                        } else {
                            p.addNote(XMLUtil.getElementText(elt));
                        }
                    } else {
                        p.addCustomElement(elt);
                    }
                }
                ++i2;
            }
        } else {
            throw new XMLProcessingException("Missing entity attribute");
        }
        return p;
    }

    private PresenceTuple buildTuple(Element e) throws XMLProcessingException {
        PresenceTuple t = null;
        NamedNodeMap attrs = e.getAttributes();
        Node n = attrs.getNamedItem(ATTRIBUTE_ID);
        if (n != null) {
            String id = n.getNodeValue();
            t = new PresenceTuple(id);
            NodeList nl = e.getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                Node ni = nl.item(i);
                if (ni instanceof Element) {
                    Element elt = (Element)ni;
                    String name = elt.getNodeName();
                    if (name.equals(ELEMENT_CONTACT)) {
                        float priority = 0.0f;
                        NamedNodeMap nnm = elt.getAttributes();
                        Node nc = nnm.getNamedItem(ATTRIBUTE_PRIORITY);
                        if (nc != null) {
                            String sPriority = nc.getNodeValue();
                            priority = Float.parseFloat(sPriority);
                        }
                        t.setContact(XMLUtil.getElementText(elt), priority);
                    } else if (name.equals(ELEMENT_NOTE)) {
                        NamedNodeMap nnm = elt.getAttributes();
                        Node nc = nnm.getNamedItem(ATTRIBUTE_LANG);
                        if (nc != null) {
                            String lang = nc.getNodeValue();
                            t.addNote(lang, XMLUtil.getElementText(elt));
                        } else {
                            t.addNote(XMLUtil.getElementText(elt));
                        }
                    } else if (name.equals(ELEMENT_STATUS)) {
                        this.readStatus(elt, t);
                    } else if (name.equals(ELEMENT_TIMESTAMP)) {
                        t.setLastUpdateTimeStamp(XMLUtil.getElementText(elt));
                    } else {
                        t.addCustomTupleElement(elt);
                    }
                }
                ++i;
            }
        } else {
            throw new XMLProcessingException("Missing tuple id attribute");
        }
        return t;
    }

    private void readStatus(Element statusElement, PresenceTuple t) throws XMLProcessingException {
        NodeList nl = statusElement.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node ni = nl.item(i);
            if (ni instanceof Element) {
                Element elt = (Element)ni;
                String name = elt.getNodeName();
                if (name.equals(ELEMENT_BASIC)) {
                    t.basicStatus = XMLUtil.getElementText(elt);
                } else if (name.equals("icp:xstatus")) {
                    t.status = XMLUtil.getElementText(elt);
                } else {
                    t.addCustomStatusElement(elt);
                }
            }
            ++i;
        }
    }

    public Presence getPresence() {
        return this._presentity;
    }

    public Collection getTuples() {
        return this._presentity.getTuples();
    }

    public void addTuple(PresenceTuple t) {
        this._presentity.addTuple(t);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("<?xml version='1.0'?>\n");
        try {
            this._presentity.copyTo(buf);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return buf.toString();
    }

    public InputStream getInputStream() throws IOException {
        byte[] bytes = this.toString().getBytes();
        return new ByteArrayInputStream(bytes, 0, bytes.length);
    }

    public static void main(String[] arg) throws Exception {
        FileInputStream in = new FileInputStream(arg[0]);
        PresenceHelper ph = new PresenceHelper(in);
        Presence p = ph.getPresence();
        System.out.println("Entity: " + p.url);
        Iterator i = p.getTuples().iterator();
        while (i.hasNext()) {
            PresenceTuple pt = (PresenceTuple)i.next();
            System.out.println("    Contact          : " + pt.contact);
            System.out.println("    Status           : " + pt.status);
        }
        System.out.println("\n\n << " + p.toString() + " >>");
    }
}

