/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service;

import com.sun.im.service.PolsterHelperAnswer;
import com.sun.im.service.SAX;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PolsterHelper
extends DefaultHandler {
    private HashMap _answers = new HashMap();
    private String _customId = null;
    private String _question;
    private int _state;
    private PolsterHelperAnswer _currentAnswer;
    private StringBuffer _quotedAnswer;
    private StringBuffer _pollMessage = new StringBuffer("<?xml version='1.0'?>\n<poll");
    private final int IN_ROOT = 1;
    private final int IN_POLLR = 5;
    public final String ELEMENT_POLL = "poll";
    public final String ELEMENT_QUESTION = "question";
    public final String ELEMENT_ANSWER = "answer";
    public final String ELEMENT_POLLR = "pollr";
    public final String ATTRIBUTE_ID = "id";
    public final String ATTRIBUTE_CUSTOM = "custom";
    public final String ATTRIBUTE_QUOTE = "quote";
    public final String ATTRIBUTE_ANSWERID = "answerid";

    public PolsterHelper(String question, List answers, boolean custom) {
        if (custom) {
            this._answers.put("c", new PolsterHelperAnswer());
            this._pollMessage.append(" custom='c'");
        }
        this._pollMessage.append("><question>" + question + "</question>");
        int i = 0;
        while (i < answers.size()) {
            String id = new Integer(i).toString();
            this._answers.put(id, new PolsterHelperAnswer(id, (String)answers.get(i)));
            this._pollMessage.append("<answer id='" + i + "'>" + (String)answers.get(i) + "</answer>");
            ++i;
        }
        this._pollMessage.append("</poll>");
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        switch (this._state) {
            case 5: {
                this._quotedAnswer.append(ch, start, length);
                break;
            }
            default: {
                throw new SAXException("No characters at this stage");
            }
        }
    }

    public void startDocument() throws SAXException {
        this._state = 1;
    }

    public void endElement(String nsuri, String localName, String fqName) throws SAXException {
        switch (this._state) {
            case 5: {
                this._state = 1;
                ++this._currentAnswer.count;
                break;
            }
            default: {
                throw new SAXException("Invalid element end at this stage: " + fqName);
            }
        }
    }

    public void startElement(String nsuri, String localName, String fqName, Attributes attributes) throws SAXException {
        switch (this._state) {
            case 1: {
                if (fqName.equals("pollr")) {
                    this._state = 5;
                    String id = attributes.getValue("answerid");
                    if (id == null) {
                        throw new SAXException("Missing answer id");
                    }
                    this._currentAnswer = (PolsterHelperAnswer)this._answers.get(id);
                    if (this._currentAnswer == null) {
                        throw new SAXException("No answer matching id " + id);
                    }
                    this._quotedAnswer = new StringBuffer();
                    break;
                }
                throw new SAXException("Invalid element: " + fqName);
            }
            default: {
                throw new SAXException("Invalid element at this stage: " + fqName);
            }
        }
    }

    public String parseAnswer(InputStream in) throws Exception {
        SAX.parse(in, (DefaultHandler)this);
        if (this._currentAnswer.custom) {
            return this._quotedAnswer.toString();
        }
        return this._currentAnswer.text;
    }

    public String parseAnswer(String str) throws Exception {
        SAX.parse(str, (DefaultHandler)this);
        if (this._currentAnswer.custom) {
            return this._quotedAnswer.toString();
        }
        return this._currentAnswer.text;
    }

    public String toString() {
        return this._pollMessage.toString();
    }
}

