/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service;

import com.sun.im.service.CollaborationHelperException;
import com.sun.im.service.PollHelperAnswer;
import com.sun.im.service.SAX;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PollHelper
extends DefaultHandler {
    private ArrayList _answers = new ArrayList(3);
    private String _customId = null;
    private String _question;
    private boolean _quote;
    private int _state;
    private PollHelperAnswer _currentAnswer;
    private static final int IN_ROOT = 1;
    private static final int IN_QUESTION = 2;
    private static final int IN_ANSWER = 3;
    private static final int IN_POLL = 4;
    public static final String ELEMENT_POLL = "poll";
    public static final String ELEMENT_QUESTION = "question";
    public static final String ELEMENT_ANSWER = "answer";
    public static final String ELEMENT_POLLR = "pollr";
    public static final String ATTRIBUTE_ID = "id";
    public static final String ATTRIBUTE_CUSTOM = "custom";
    public static final String ATTRIBUTE_QUOTE = "quote";
    public static final String ATTRIBUTE_ANSWERID = "answerid";

    public PollHelper(InputStream in) throws Exception {
        SAX.parse(in, (DefaultHandler)this);
    }

    public PollHelper(String message) throws Exception {
        SAX.parse(message, (DefaultHandler)this);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        switch (this._state) {
            case 2: {
                this._question = String.copyValueOf(ch, start, length);
                break;
            }
            case 3: {
                this._currentAnswer.text.append(ch, start, length);
                break;
            }
            default: {
                throw new SAXException("No characters at this stage: ");
            }
        }
    }

    public void startDocument() throws SAXException {
        this._state = 1;
    }

    public void endElement(String nsuri, String localName, String fqName) throws SAXException {
        switch (this._state) {
            case 4: {
                this._state = 1;
                break;
            }
            case 2: {
                this._state = 4;
                break;
            }
            case 3: {
                this._answers.add(this._currentAnswer);
                this._state = 4;
                break;
            }
            default: {
                throw new SAXException("Invalid element end at this stage: " + fqName);
            }
        }
    }

    public void startElement(String nsuri, String localName, String fqName, Attributes attributes) throws SAXException {
        switch (this._state) {
            case 1: {
                if (fqName.equals(ELEMENT_POLL)) {
                    this._state = 4;
                    this._customId = attributes.getValue(ATTRIBUTE_CUSTOM);
                    if (attributes.getValue(ATTRIBUTE_QUOTE) == null) break;
                    this._quote = true;
                    break;
                }
                throw new SAXException("Invalid element: " + fqName);
            }
            case 4: {
                if (fqName.equals(ELEMENT_QUESTION)) {
                    this._state = 2;
                    break;
                }
                if (!fqName.equals(ELEMENT_ANSWER)) break;
                this._state = 3;
                String id = attributes.getValue(ATTRIBUTE_ID);
                if (id == null) {
                    throw new SAXException("Missing answer id");
                }
                this._currentAnswer = new PollHelperAnswer(id);
                break;
            }
            default: {
                throw new SAXException("Invalid element at this stage: " + fqName);
            }
        }
    }

    public String getQuestion() {
        return this._question;
    }

    public int countAnswers() {
        return this._answers.size();
    }

    public String getAnswer(int index) throws IndexOutOfBoundsException {
        PollHelperAnswer a = (PollHelperAnswer)this._answers.get(index);
        if (a == null) {
            throw new IndexOutOfBoundsException();
        }
        return a.text.toString();
    }

    public String createResponse(int index) {
        PollHelperAnswer a = (PollHelperAnswer)this._answers.get(index);
        if (this._quote) {
            return "<?xml version='1.0'?>\n<pollr answerid='" + a.id + "'>" + a.text.toString() + "</pollr>";
        }
        return "<?xml version='1.0'?>\n<pollr answerid='" + a.id + "' />";
    }

    public String createResponse(String answer) throws CollaborationHelperException {
        int i = 0;
        while (i < this._answers.size()) {
            if (answer.equals(((PollHelperAnswer)this._answers.get((int)i)).text.toString())) {
                if (this._quote) {
                    return "<?xml version='1.0'?>\n<pollr answerid='" + i + "'>" + answer + "</pollr>";
                }
                return "<?xml version='1.0'?>\n<pollr answerid='" + i + "' />";
            }
            ++i;
        }
        if (this._customId != null) {
            return "<?xml version='1.0'?>\n<pollr answerid='" + this._customId + "'>" + answer + "</pollr>";
        }
        throw new CollaborationHelperException("Custom answer not allowed for this poll: " + answer);
    }

    public InputStream createResponseStream(String answer) throws CollaborationHelperException {
        byte[] buf = this.createResponse(answer).getBytes();
        return new ByteArrayInputStream(buf, 0, buf.length);
    }

    public boolean isCustomAnswerAllowed() {
        return this._customId != null;
    }
}

