/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.net;

import com.iplanet.im.net.CommandData;
import com.iplanet.im.net.Connection;
import com.iplanet.im.net.ConnectionFactory;
import com.iplanet.im.net.Room;
import com.iplanet.im.net.RoomListener;
import com.iplanet.im.net.RoomUserEvent;
import java.util.Enumeration;
import java.util.EventListener;

public class RoomConnection
extends Connection {
    public static final int MODERATOR = 1;
    public static final int ARCHIVE = 16;

    public RoomConnection(ConnectionFactory connectionFactory, Room r) {
        this.cf = connectionFactory;
        this.destination = r;
    }

    public String toString() {
        return super.toString() + " Room Connection for " + this.destination.getName();
    }

    public void setUserStatus(String uid, String status, String note, CommandData cd) {
        this.fireRoomUserStatus(uid, status, note, cd);
    }

    public Room getRoom() {
        return (Room)this.destination;
    }

    protected synchronized void fireRoomUserStatus(String uid, String status, String note, CommandData cd) {
        RoomUserEvent event = new RoomUserEvent(this, uid, status, note, cd);
        Enumeration e = this.changeListeners.elements();
        while (e.hasMoreElements()) {
            EventListener listener = (EventListener)e.nextElement();
            if (listener instanceof RoomListener) {
                RoomListener rl = (RoomListener)listener;
                rl.roomUserStatusChange(event);
                continue;
            }
            System.out.println("RoomConnection.fireRoomUserStatus(): room's listener is not instance of RoomListener");
        }
    }
}

