/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.net;

import com.iplanet.im.net.Command;
import com.iplanet.im.net.CommandData;
import com.iplanet.im.net.Config;
import com.iplanet.im.net.ConnectionFactory;
import com.iplanet.im.net.MultiplexSocket;
import com.sun.im.service.AuthenticationException;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.TimeoutException;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Properties;

public class MultiplexConnectionFactory
extends ConnectionFactory {
    private MultiplexSocket _socket;
    private int _channel;
    private CommandData _reply;

    public MultiplexConnectionFactory(int channel, MultiplexSocket s, Properties props) {
        super(props);
        this._socket = s;
        this._channel = channel;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void connect() throws UnknownHostException, IOException, CollaborationException {
        this.connected = true;
        Object object = this.receivedHello;
        synchronized (object) {
            while (!this.bReceivedHello && this.connected) {
                try {
                    this.receivedHello.wait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.sayHello();
    }

    void sayHello() throws IOException, CollaborationException {
        CommandData cd = Command.create(106, "3.0", ConnectionFactory.VERSION, ConnectionFactory.VERSION, "");
        try {
            CommandData reply = this.sendCommand(cd);
        }
        catch (CollaborationException e) {
            this._close("protocol error at hello phase", false, 0);
        }
    }

    public Config login() throws CollaborationException, AuthenticationException {
        return this._login();
    }

    public void close() {
        this.connected = false;
        try {
            this._socket.close(this._channel);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected synchronized void closed(String reason) {
        this.connected = false;
        this.notify();
        this.fireConnectionLost(reason, 0);
    }

    public CommandData sendCommand(CommandData cd) throws CollaborationException {
        int increment = 0;
        CommandData nc = null;
        Object object = this.replyLock;
        synchronized (object) {
            this.writeCommand(cd);
            while (this._reply == null && this.connected) {
                if (++increment > 4) {
                    this._reply = null;
                    this._pendingCommand = null;
                    throw new TimeoutException("Timeout while waiting for server response to " + Command.toString(cd));
                }
                MultiplexConnectionFactory multiplexConnectionFactory = this;
                synchronized (multiplexConnectionFactory) {
                    try {
                        this.wait(5000L);
                    }
                    catch (Exception e) {
                        System.err.println("WAIT interrupted " + e);
                    }
                }
                if (this.connected) continue;
                throw new CollaborationException("Channel closed by server");
            }
            nc = this._reply;
            this._reply = null;
        }
        if (nc == null) {
            throw new CollaborationException("Command interrupted");
        }
        if (Command.getReplyCode(nc) != 0) {
            throw new CollaborationException(Command.getReplyString(nc));
        }
        return nc;
    }

    void writeCommand(CommandData cd) throws CollaborationException {
        try {
            this._socket.writeCommand(this._channel, cd);
        }
        catch (IOException e) {
            throw new CollaborationException(e.toString());
        }
    }

    synchronized void onReply(CommandData cd) {
        if (this._reply != null) {
            System.err.println("ERROR: <" + this._channel + "> writing over last reply: " + Command.toString((Integer)this._reply.args[0]));
        }
        this._reply = cd;
        this.notify();
    }
}

