/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.api.test;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;

public class ArchiveTest {
    String submitUrl = "";
    String searchUrl = "";
    String time = "2000";
    String soifData = "";
    String RDMServer = "";
    String keyword = "";
    String user = "";
    String session = "test";
    String URI = "/portal";
    String host = "localhost";
    static PrintStream ps = System.out;

    public ArchiveTest() {
    }

    public ArchiveTest(String[] args) {
        this.readArgs(args);
    }

    public ArchiveTest(String host, String soifFile, String keyword, String user) {
        this.host = host;
        this.soifData = ArchiveTest.readFile(soifFile);
        this.keyword = keyword;
        this.user = user;
    }

    public ArchiveTest(String host, String soifFile, String keyword, String user, String sessionId) {
        this.host = host;
        this.soifData = ArchiveTest.readFile(soifFile);
        this.keyword = keyword;
        this.user = user;
        this.session = sessionId;
    }

    private static String readFile(String filename) {
        StringBuffer buf = new StringBuffer();
        try {
            BufferedReader b = new BufferedReader(new FileReader(filename));
            String str = b.readLine();
            while (str != null) {
                buf.append(str);
                buf.append("\n");
                str = b.readLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return buf.toString();
    }

    private synchronized String callServlet(String[] args) {
        URL url = null;
        URLConnection connection = null;
        PrintStream outStream = null;
        BufferedReader inStream = null;
        String currentLine = null;
        if (args.length == 0) {
            return null;
        }
        StringBuffer argString = new StringBuffer();
        int i = 1;
        while (i < args.length) {
            argString.append(args[i]);
            if (i != args.length - 1) {
                argString.append("&");
            }
            ++i;
        }
        try {
            url = new URL(args[0]);
            connection = url.openConnection();
            connection.setDoOutput(true);
            outStream = new PrintStream(connection.getOutputStream());
            outStream.println(argString.toString());
            outStream.println("");
            outStream.close();
            outStream = null;
            inStream = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuffer ret = new StringBuffer();
            while (null != (currentLine = inStream.readLine())) {
                ret.append(currentLine);
                ret.append("\n");
            }
            inStream.close();
            inStream = null;
            return ret.toString();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return null;
        }
    }

    private static void usage() {
        ArchiveTest.print("com.iplanet.im.client.api.test.ArchiveTest options");
        ArchiveTest.print("where options can be one of the following:");
        ArchiveTest.print("-runrdmgr TIME --> TIME is the period after which the indexing of the data will be done. The default value is 2000 msec.");
        ArchiveTest.print("-soif SOIF_FILE --> SOIF_FILE is the file which contains the soif data which will be submitted to the database.");
        ArchiveTest.print("-keyword KEYWORD --> KEYWORD is the keyword of the SOIF data.");
        ArchiveTest.print("-user USER_DN --> The DN of the user whose entry should be removed from the SOIF data.");
        ArchiveTest.print("-host HOST --> Host name of the portal server.");
        ArchiveTest.print("-uri URI --> URI of the portal server.");
        ArchiveTest.print("-log FILE --> The log file wher the output should be directed.");
    }

    private static void print(String str) {
        ps.println(str);
    }

    private void readArgs(String[] args) {
        int i = 0;
        while (i < args.length) {
            if (args[i].equalsIgnoreCase("-runrdmgr")) {
                this.time = args[++i];
            } else if (args[i].equalsIgnoreCase("-soif")) {
                this.soifData = ArchiveTest.readFile(args[++i]);
            } else if (args[i].equalsIgnoreCase("-keyword")) {
                this.keyword = args[++i];
            } else if (args[i].equalsIgnoreCase("-user")) {
                this.user = args[++i];
            } else if (args[i].equalsIgnoreCase("-session")) {
                this.session = args[++i];
            } else if (args[i].equalsIgnoreCase("-host")) {
                this.host = args[++i];
            } else if (args[i].equalsIgnoreCase("-URI")) {
                this.URI = args[++i];
            } else if (args[i].equalsIgnoreCase("-log")) {
                ++i;
                try {
                    ps = new PrintStream(new FileOutputStream(args[i], true));
                }
                catch (FileNotFoundException e) {
                    ps = System.out;
                    ArchiveTest.print("File not found: " + args[i]);
                }
            } else {
                ArchiveTest.usage();
            }
            ++i;
        }
    }

    public String fireRunrdmgr() {
        ArchiveTest.print("Calling submit servlet: op=runrdmgr, time=" + this.time);
        String[] command = new String[]{this.submitUrl, "op=runrdmgr", "data=" + URLEncoder.encode(this.time)};
        return this.callServlet(command);
    }

    public String fireSubmit() {
        ArchiveTest.print("Calling submit servlet to submit data " + this.soifData);
        String[] command = new String[]{this.submitUrl, "data=" + URLEncoder.encode(this.soifData)};
        return this.callServlet(command);
    }

    public String fireSearch() {
        ArchiveTest.print("Calling search servlet");
        String[] command = new String[]{this.searchUrl, "RDMServer=" + this.RDMServer, "scope=" + this.keyword, "Session=" + URLEncoder.encode(this.session)};
        return this.callServlet(command);
    }

    public String fireRemoveACL() {
        ArchiveTest.print("Calling submit servlet: op=removeacl, user=" + this.user);
        String[] command = new String[]{this.submitUrl, "op=removeacl", "user=" + URLEncoder.encode(this.user), "data=" + URLEncoder.encode(this.keyword)};
        return this.callServlet(command);
    }

    public String fireGet() {
        ArchiveTest.print("Calling submit servlet: op=get, data=" + this.keyword);
        String[] command = new String[]{this.submitUrl, "op=get", "data=" + URLEncoder.encode(this.keyword)};
        return this.callServlet(command);
    }

    public String fireDelete() {
        StringBuffer data_to_be_deleted = new StringBuffer();
        data_to_be_deleted.append("@DOCUMENT { ");
        data_to_be_deleted.append("/portal/searchServlet?RDMServer=");
        data_to_be_deleted.append(this.RDMServer);
        data_to_be_deleted.append("&scope=");
        data_to_be_deleted.append(this.keyword);
        data_to_be_deleted.append("\n}\n");
        String[] command = new String[]{this.submitUrl, "op=delete", "data=" + URLEncoder.encode(data_to_be_deleted.toString())};
        ArchiveTest.print("Calling submit servlet: op=delete, data=" + data_to_be_deleted.toString());
        return this.callServlet(command);
    }

    public void sleep(long time) {
        try {
            ArchiveTest.print("Sleep for " + time + " msec");
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void runTests() {
        this.submitUrl = "http://" + this.host + this.URI + "/submitServlet";
        this.searchUrl = "http://" + this.host + this.URI + "/searchServlet";
        this.RDMServer = "http://" + this.host + this.URI + "/search";
        ArchiveTest.print(this.fireRunrdmgr());
        ArchiveTest.print(this.fireSubmit());
        this.sleep(2L * Long.parseLong(this.time));
        ArchiveTest.print(this.fireSearch());
        ArchiveTest.print(this.fireRemoveACL());
        this.sleep(2L * Long.parseLong(this.time));
        ArchiveTest.print(this.fireGet());
        ArchiveTest.print(this.fireDelete());
        this.sleep(2L * Long.parseLong(this.time));
        ArchiveTest.print(this.fireSearch());
    }

    public static void main(String[] args) {
        ArchiveTest at = new ArchiveTest(args);
        at.runTests();
    }
}

