/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.api;

import com.iplanet.im.client.api.iIMContactList;
import com.iplanet.im.client.api.iIMSession;
import com.iplanet.im.net.iIMUser;
import com.iplanet.im.util.StringUtility;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.PersonalContact;
import com.sun.im.service.PersonalStoreFolder;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.List;

public class iIMContact
implements PersonalContact {
    ArrayList _addresses;
    iIMSession _session;
    ArrayList _folders;
    iIMUser _user;
    String _displayName;

    protected iIMContact(iIMSession s, String displayName) throws CollaborationException {
        this._displayName = displayName;
        this._session = s;
        this._addresses = new ArrayList();
        this._folders = new ArrayList();
        this.addAddress("im", displayName, 0);
    }

    protected iIMContact(iIMSession s, iIMUser user) throws CollaborationException {
        this._user = user;
        this._session = s;
        this._addresses = new ArrayList();
        this._folders = new ArrayList();
        this.addAddress("im", user.getUID(), 0);
    }

    protected void setiIMUser(iIMUser user) throws CollaborationException {
        this._user = user;
        this._addresses.clear();
        this.addAddress("im", user.getUID(), 0);
    }

    public String getAddress(String addressType) {
        if (this._addresses.size() > 0) {
            return (String)this._addresses.get(0);
        }
        return null;
    }

    public List getAddresses(String addressType) {
        return this._addresses;
    }

    public void removeAddress(String addressType, String address) throws CollaborationException {
        this._addresses.remove(0);
    }

    public void addAddress(String addressType, String address, int priority) throws CollaborationException {
        try {
            String fqadr = StringUtility.appendDomainToAddress(address, this._session.connectionFactory.getServerName());
            this._addresses.add(fqadr);
            if (this._user == null && this._addresses.size() == 1) {
                this._user = this._session.connectionFactory.getiIMUserFromUID(this.getAddress("im"));
            }
        }
        catch (CollaborationException e) {
            throw new CollaborationException(e.toString());
        }
    }

    public String getEntryId() {
        return (String)this._addresses.get(0);
    }

    public String getDisplayName() {
        if (this._user == null) {
            return this._displayName;
        }
        return this._user.getDisplayName();
    }

    public String getType() {
        return "contact";
    }

    public void addToFolder(PersonalStoreFolder folder) throws CollaborationException {
        this._folders.add(folder);
        ((iIMContactList)folder).addEntry(this);
    }

    public void removeFromFolder(PersonalStoreFolder folder) throws CollaborationException {
        ((iIMContactList)folder).removeEntry(this);
        ((AbstractCollection)this._folders).remove(folder);
    }

    public void save() throws CollaborationException {
        if (this._user == null) {
            this.remove();
        } else if (this._folders.size() > 0) {
            ((iIMContactList)this._folders.get(0)).save();
        } else {
            throw new CollaborationException("Entry not contained in any folder");
        }
    }

    public void remove() throws CollaborationException {
        int i = 0;
        while (i < this._folders.size()) {
            this.removeFromFolder((iIMContactList)this._folders.get(i));
            ++i;
        }
    }

    public boolean equals(Object o) {
        if (o instanceof iIMContact) {
            iIMContact c = (iIMContact)o;
            if (!this._addresses.isEmpty() && c.getAddress("im").equals(this._addresses.get(0))) {
                return true;
            }
            if (this._addresses.isEmpty() && c.getAddress("im") == null) {
                return true;
            }
        }
        return false;
    }
}

