/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.net.Destination;
import com.iplanet.im.net.Room;
import com.iplanet.im.net.Topic;
import com.iplanet.im.net.iIMQueue;
import com.iplanet.im.net.iIMUser;
import com.iplanet.im.server.DestinationAcl;
import com.iplanet.im.server.IMPolicy;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.RoomStorage;
import com.iplanet.im.server.Storage;
import com.iplanet.im.util.PlatformUtil;
import com.iplanet.im.util.SafeResourceBundle;
import com.iplanet.im.util.StringUtility;
import com.iplanet.im.util.WildCardPattern;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;

public final class Settings {
    SafeResourceBundle res = new SafeResourceBundle("com.iplanet.im.server.NMSBundle");
    Hashtable topics = new Hashtable();
    Hashtable rooms = new Hashtable();
    private static Settings s;

    public static synchronized Settings getSettings() {
        if (s == null) {
            s = new Settings();
            s.load();
        }
        return s;
    }

    public static synchronized void reset() {
        s = null;
    }

    private Settings() {
    }

    private void loadDestinationProperties(Destination d, String prefix, Properties props) {
        Map map = d.getProperties();
        if (map != null) {
            String key;
            int i = 0;
            while (!(key = props.getProperty(prefix + ".att" + i, "error")).equals("error")) {
                String value = props.getProperty(prefix + ".val" + i);
                if (value != null) {
                    map.put(key, value);
                }
                ++i;
            }
        }
    }

    private void saveDestinationProperties(Destination d, String prefix, Properties props) {
        int j = 0;
        Map map = d.getProperties();
        if (props != null) {
            Iterator ie = map.entrySet().iterator();
            while (ie.hasNext()) {
                Map.Entry entry = ie.next();
                ((Hashtable)props).put(prefix + ".att" + j, entry.getKey());
                ((Hashtable)props).put(prefix + ".val" + j, entry.getValue());
                Log.out.debug("writing props " + prefix + ".att" + j + "=" + entry.getKey());
                ++j;
            }
        }
    }

    public boolean load() {
        String s;
        String s2;
        boolean ret;
        Properties p = new Properties();
        String domain = null;
        try {
            File f = new File(NMS.getDBDir(), "storage.properties");
            FileInputStream is = new FileInputStream(f);
            p.load(is);
            ret = true;
            is.close();
        }
        catch (Exception e) {
            Log.out.warning("Failed to open storage.properties file: " + e.toString());
            ret = false;
        }
        int topicndx = 1;
        while (!(s2 = p.getProperty("topic" + topicndx, "error")).equals("error")) {
            domain = StringUtility.getDomainFromAddress(s2, NMS.getName());
            s2 = StringUtility.getLocalPartFromAddress(s2);
            Topic t = new Topic(s2, domain);
            this.loadDestinationProperties((Destination)t, "topic" + topicndx, p);
            Storage ts = Storage.create(t);
            if (ts != null) {
                this.topics.put(t.getUID(), ts.getTopic());
            }
            ++topicndx;
        }
        int roomndx = 1;
        while (!(s = p.getProperty("room" + roomndx, "error")).equals("error")) {
            domain = StringUtility.getDomainFromAddress(s, NMS.getName());
            s = StringUtility.getLocalPartFromAddress(s);
            Room r = new Room(s, domain);
            this.loadDestinationProperties((Destination)r, "room" + roomndx, p);
            RoomStorage rs = RoomStorage.create(r, false);
            if (rs != null) {
                this.rooms.put(r.getUID(), rs.getRoom());
            }
            ++roomndx;
        }
        return ret;
    }

    private boolean save() {
        try {
            Log.out.debug("Saving the room-topic lists ");
            Properties p = new Properties();
            File f = new File(NMS.getDBDir(), "storage.properties");
            File tmpfile = PlatformUtil.getTempFile(f);
            FileOutputStream os = new FileOutputStream(tmpfile);
            int i = 1;
            Iterator iter = this.topics.values().iterator();
            while (iter.hasNext()) {
                Topic t = (Topic)iter.next();
                ((Hashtable)p).put("topic" + i, t.getName() + "@" + t.getLocation());
                this.saveDestinationProperties((Destination)t, "room" + i, p);
                ++i;
            }
            i = 1;
            Iterator iter2 = this.rooms.values().iterator();
            while (iter2.hasNext()) {
                Room r = (Room)iter2.next();
                ((Hashtable)p).put("room" + i, r.getName() + "@" + r.getLocation());
                this.saveDestinationProperties((Destination)r, "room" + i, p);
                ++i;
            }
            p.store(os, "nms");
            os.close();
            PlatformUtil.renameTempFile(tmpfile, f);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.out.error("Failed to save server properties: " + e.toString());
            return false;
        }
    }

    protected boolean exists(Destination d) {
        if (d instanceof Room) {
            return this.getRoom(d.getUID()) != null;
        }
        if (d instanceof Topic) {
            return this.getTopic(d.getUID()) != null;
        }
        return false;
    }

    boolean addTopic(Topic t, iIMUser u) {
        Storage temp = Storage.get(t);
        if (temp != null) {
            return false;
        }
        Storage ts = Storage.create(t);
        this.topics.put(t.getUID(), t);
        if (!this.save()) {
            return false;
        }
        DestinationAcl.createDestinationAcls((Destination)t, u);
        return true;
    }

    void removeTopic(Topic topic, iIMUser u) {
        Storage.remove(topic);
        Topic t = (Topic)this.topics.get(topic.getUID());
        if (t != null) {
            this.topics.remove(t.getUID());
            DestinationAcl.deleteDestinationAcls((Destination)t);
            this.save();
        }
    }

    Topic getTopic(String address) {
        String id = address;
        if (!id.startsWith("topic-")) {
            id = "topic-" + id;
        }
        id = StringUtility.appendDomainToAddress(id, NMS.getName());
        return (Topic)this.topics.get(id);
    }

    Topic[] getTopics(String pattern) {
        LinkedList<Topic> v = new LinkedList<Topic>();
        WildCardPattern wcp = new WildCardPattern(pattern);
        if (wcp.getFilterType() == 4) {
            return this.getOneTopicArray(pattern);
        }
        Iterator iter = this.topics.values().iterator();
        while (iter.hasNext()) {
            Topic t = (Topic)iter.next();
            if (!wcp.match(t.getName())) continue;
            v.add(t);
        }
        if (v.size() > 0) {
            Topic[] ra = new Topic[v.size()];
            int i = 0;
            Iterator iter2 = v.iterator();
            while (iter2.hasNext()) {
                ra[i++] = (Topic)iter2.next();
            }
            return ra;
        }
        return null;
    }

    Topic[] getTopics(iIMUser u, String pattern, int access, boolean useDefaultDomain) {
        String userDomain = null;
        userDomain = useDefaultDomain ? NMS.getName() : u.getServer();
        if (!IMPolicy.canAccessNews(u)) {
            return null;
        }
        LinkedList<Topic> v = new LinkedList<Topic>();
        WildCardPattern wcp = new WildCardPattern(pattern);
        if (wcp.getFilterType() == 4) {
            Topic[] oneTopicArray = this.getOneTopicArray(pattern);
            if (oneTopicArray != null && oneTopicArray[0].getLocation().equalsIgnoreCase(userDomain)) {
                return oneTopicArray;
            }
            return null;
        }
        Iterator iter = this.topics.values().iterator();
        while (iter.hasNext()) {
            Topic t = (Topic)iter.next();
            if (!t.getLocation().equalsIgnoreCase(userDomain) || !DestinationAcl.check((Destination)t, u, access) || !wcp.match(t.getName())) continue;
            v.add(t);
        }
        if (v.size() > 0) {
            Topic[] ra = new Topic[v.size()];
            int i = 0;
            Iterator iter2 = v.iterator();
            while (iter2.hasNext()) {
                ra[i++] = (Topic)iter2.next();
            }
            return ra;
        }
        return null;
    }

    boolean addRoom(Room room, iIMUser u, boolean temp) {
        RoomStorage rs = RoomStorage.create(room, temp);
        if (rs == null) {
            return false;
        }
        if (!temp) {
            this.rooms.put(room.getUID(), room);
            if (!this.save()) {
                return false;
            }
            DestinationAcl.createDestinationAcls((Destination)room, u);
        }
        return true;
    }

    void removeRoom(Room room, iIMUser u) {
        RoomStorage.remove(room);
        Room r = (Room)this.rooms.get(room.getUID());
        if (r != null) {
            this.rooms.remove(r.getUID());
            DestinationAcl.deleteDestinationAcls((Destination)r);
        }
        this.save();
    }

    Room[] getRooms(String pattern) {
        WildCardPattern wcp = new WildCardPattern(pattern);
        if (wcp.getFilterType() == 4) {
            return this.getOneRoomArray(pattern);
        }
        LinkedList<Room> v = new LinkedList<Room>();
        Iterator iter = this.rooms.values().iterator();
        while (iter.hasNext()) {
            Room r = (Room)iter.next();
            if (!wcp.match(r.getName())) continue;
            v.add(r);
        }
        if (v.size() > 0) {
            Room[] ra = new Room[v.size()];
            int i = 0;
            Iterator iter2 = v.iterator();
            while (iter2.hasNext()) {
                ra[i++] = (Room)iter2.next();
            }
            return ra;
        }
        return null;
    }

    Room[] getRooms(iIMUser u, String pattern, int access, boolean useDefaultDomain) {
        String userDomain = null;
        userDomain = useDefaultDomain ? NMS.getName() : u.getServer();
        if (!IMPolicy.canAccessConferenceRooms(u)) {
            return null;
        }
        WildCardPattern wcp = new WildCardPattern(pattern);
        if (wcp.getFilterType() == 4) {
            Room[] oneRoomArray = this.getOneRoomArray(pattern);
            if (oneRoomArray != null && oneRoomArray[0].getLocation().equalsIgnoreCase(userDomain)) {
                return oneRoomArray;
            }
            return null;
        }
        LinkedList<Room> v = new LinkedList<Room>();
        Iterator iter = this.rooms.values().iterator();
        while (iter.hasNext()) {
            Room r = (Room)iter.next();
            if (!r.getLocation().equalsIgnoreCase(userDomain) || !DestinationAcl.check((Destination)r, u, access) || !wcp.match(r.getName())) continue;
            v.add(r);
        }
        if (v.size() > 0) {
            Room[] ra = new Room[v.size()];
            int i = 0;
            Iterator iter2 = v.iterator();
            while (iter2.hasNext()) {
                ra[i++] = (Room)iter2.next();
            }
            return ra;
        }
        return null;
    }

    Room getRoom(String address) {
        String id = address;
        if (!id.startsWith("room-")) {
            id = "room-" + id;
        }
        id = StringUtility.appendDomainToAddress(id, NMS.getName());
        return (Room)this.rooms.get(id);
    }

    Room[] getOneRoomArray(String address) {
        Room r = this.getRoom(address);
        if (r != null) {
            Room[] ra = new Room[]{r};
            return ra;
        }
        return null;
    }

    Topic[] getOneTopicArray(String address) {
        Topic r = this.getTopic(address);
        if (r != null) {
            Topic[] ra = new Topic[]{r};
            return ra;
        }
        return null;
    }

    iIMQueue[] getQueues(iIMUser u) {
        iIMQueue[] qs = new iIMQueue[]{new iIMQueue(u)};
        return qs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateDestination(Destination d) throws Exception {
        if (d instanceof Room) {
            if (this.rooms.get(d.getUID()) == null) throw new Exception("Public Conference " + d.getUID() + " does not exist");
            this.rooms.put(d.getUID(), d);
        } else {
            if (!(d instanceof Topic)) throw new Exception("Properties can be saved only for public conferences and news channels");
            if (this.topics.get(d.getUID()) == null) throw new Exception("News Channel " + d.getUID() + " does not exist");
            this.topics.put(d.getUID(), d);
        }
        this.save();
    }
}

