/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.net.UserSearchReply;
import com.iplanet.im.net.iIMGroup;
import com.iplanet.im.net.iIMPrincipal;
import com.iplanet.im.net.iIMRealm;
import com.iplanet.im.net.iIMUser;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.NMSGroup;
import com.iplanet.im.server.NMSUser;
import com.iplanet.im.server.RealmException;
import com.iplanet.im.util.SafeResourceBundle;
import com.iplanet.im.util.StringUtility;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class Realm
implements iIMRealm {
    SafeResourceBundle res = new SafeResourceBundle("com.iplanet.im.server.NMSBundle");
    private static Hashtable realms = new Hashtable();
    private Hashtable nmsUsersHT = new Hashtable();
    private Hashtable nmsGroupsHT = new Hashtable();
    private iIMGroup[] nlga;

    public abstract void stop();

    public abstract iIMUser _getiIMUser(iIMPrincipal var1, String var2) throws RealmException;

    public abstract iIMUser _getiIMUser(String var1, String var2) throws RealmException;

    public abstract iIMGroup _getiIMGroup(iIMPrincipal var1, String var2) throws RealmException;

    public abstract NMSGroup _getNMSGroup(iIMPrincipal var1, iIMGroup var2) throws RealmException;

    public abstract UserSearchReply _search(iIMPrincipal var1, String var2, boolean var3, String var4) throws RealmException;

    public abstract UserSearchReply _search(String var1, String var2, boolean var3, String var4) throws RealmException;

    public abstract UserSearchReply _search(String var1, String var2) throws RealmException;

    public abstract iIMUser _auth(String var1, String var2) throws RealmException;

    public void resync() {
        this.nlga = null;
        this.nmsGroupsHT.clear();
    }

    public NMSUser auth(String uid, String pass) throws RealmException {
        NMSUser nmsu = null;
        iIMUser u = this._auth(uid, pass);
        if (u != null) {
            nmsu = this.getFromNMSUserCache(u.getUID());
            if (nmsu == null) {
                nmsu = new NMSUser(u);
            } else {
                nmsu.setiIMUser(u);
            }
            this.addToNMSUserCache(u.getUID(), nmsu);
        }
        return nmsu;
    }

    public NMSUser getUser(iIMPrincipal principal, String uid) throws RealmException {
        return this.getUser(principal, uid, false);
    }

    public String getSearchBase() {
        return null;
    }

    public NMSUser refreshUser(iIMPrincipal principal, String uid) throws RealmException {
        return this.getUser(principal, uid, true);
    }

    private NMSUser getUser(iIMPrincipal principal, String uid, boolean refresh) throws RealmException {
        uid = StringUtility.appendDomainToAddress(uid, principal.getServer());
        Log.out.debug("[Realm] getUser: " + uid);
        iIMUser nlu = null;
        NMSUser nmsu = this.getFromNMSUserCache(uid);
        if (!refresh && nmsu != null) {
            nlu = nmsu.getiIMUser();
        }
        if (nlu == null && (nlu = this._getiIMUser(principal, uid)) == null) {
            throw new RealmException("User " + uid + " does not exist.");
        }
        if (nmsu == null) {
            nmsu = new NMSUser(nlu);
            this.addToNMSUserCache(nlu.getUID(), nmsu);
        } else {
            Log.out.debug("[Realm] found user in cache: " + uid);
            nmsu.setiIMUser(nlu);
        }
        return nmsu;
    }

    public NMSUser getUser(String uid) throws RealmException {
        return this.getUser(uid, false);
    }

    public NMSUser getUser(String uid, boolean refresh) throws RealmException {
        uid = StringUtility.appendDomainToAddress(uid, NMS.getName());
        String domain = StringUtility.getDomainFromAddress(uid, NMS.getName());
        Log.out.debug("[Realm] getUser (default search base): " + uid);
        iIMUser nlu = null;
        NMSUser nmsu = this.getFromNMSUserCache(uid);
        if (!refresh && nmsu != null) {
            nlu = nmsu.getiIMUser();
        }
        if (nlu == null && (nlu = this._getiIMUser(this.getSearchBase(domain), uid)) == null) {
            throw new RealmException("User " + uid + " does not exist.");
        }
        if (nmsu == null) {
            nmsu = new NMSUser(nlu);
            this.addToNMSUserCache(nlu.getUID(), nmsu);
        } else {
            nmsu.setiIMUser(nlu);
            Log.out.debug("[Realm] found user in cache: " + uid);
        }
        return nmsu;
    }

    public NMSGroup getGroup(iIMPrincipal principal, String uid) throws RealmException {
        String server = StringUtility.getDomainFromAddress(uid, principal.getServer());
        uid = StringUtility.getLocalPartFromAddress(uid);
        iIMGroup nlg = this._getiIMGroup(principal, uid);
        NMSGroup nmsg = null;
        if (nlg != null && (nmsg = this.getFromNMSGroupCache(nlg)) == null) {
            nmsg = this._getNMSGroup(principal, nlg);
            this.addToNMSGroupCache(nlg, nmsg);
        }
        return nmsg;
    }

    private NMSUser getFromNMSUserCache(String name) {
        return (NMSUser)this.nmsUsersHT.get(name.toLowerCase());
    }

    private void addToNMSUserCache(String name, NMSUser nmsu) {
        this.nmsUsersHT.put(name.toLowerCase(), nmsu);
    }

    private void removeFromNMSUserCache(String name) {
        this.nmsUsersHT.remove(name.toLowerCase());
    }

    private NMSGroup getFromNMSGroupCache(iIMGroup g) {
        return (NMSGroup)this.nmsGroupsHT.get(g);
    }

    private void addToNMSGroupCache(iIMGroup nlg, NMSGroup nmsg) {
        this.nmsGroupsHT.put(nlg, nmsg);
    }

    private void removeFromNMSGroupCache(iIMGroup nlg) {
        this.nmsGroupsHT.remove(nlg);
    }

    public UserSearchReply search(iIMPrincipal principal, String pattern, boolean byid, String filter) throws RealmException {
        return this._search(principal, pattern, byid, filter);
    }

    public UserSearchReply search(String base, String pattern, boolean byid, String filter) throws RealmException {
        return this._search(base, pattern, byid, filter);
    }

    public String getSearchBase(String uid, String password) throws RealmException {
        return null;
    }

    public String getSearchBase(String domainName) throws RealmException {
        return null;
    }

    public String getDomainName(String searchBase) throws RealmException {
        return null;
    }

    public String getDomainName(String uid, String password) throws RealmException {
        return null;
    }

    public abstract String getSearchBase(iIMPrincipal var1) throws RealmException;

    public static synchronized Realm get(String realmName) {
        try {
            Realm r = (Realm)realms.get(realmName);
            if (r == null) {
                Log.out.debug("Creating realm for first time " + realmName);
                Class<?> c = Class.forName(realmName);
                r = (Realm)c.newInstance();
                realms.put(realmName, r);
            }
            return r;
        }
        catch (Exception e) {
            Log.out.error("Error creating realm " + realmName + ":" + e.toString());
            Log.out.printStackTrace(e);
            return null;
        }
    }

    public static synchronized void reset() {
        Enumeration e = realms.keys();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            Realm r = (Realm)realms.get(s);
            r.stop();
        }
        realms.clear();
    }

    public boolean isMemberOfGroup(iIMPrincipal p, iIMGroup g) {
        try {
            NMSGroup nmsg = this.getGroup((iIMPrincipal)g, g.getUID());
            return nmsg != null && nmsg.hasMember(p);
        }
        catch (Exception e) {
            Log.out.warning("isMemberOfGroup(" + p.getUID() + ", " + g.getUID() + " : " + e.toString());
            return false;
        }
    }
}

