/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.net.UserSearchReply;
import com.iplanet.im.net.iIMGroup;
import com.iplanet.im.net.iIMPrincipal;
import com.iplanet.im.net.iIMUser;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.NMSGroup;
import com.iplanet.im.server.Realm;
import com.iplanet.im.server.RealmException;
import com.iplanet.im.util.SafeResourceBundle;
import com.iplanet.im.util.StringUtility;
import com.iplanet.im.util.WildCardPattern;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class PasswordFileRealm
extends Realm {
    private static final String userFileName = "users.cfg";
    private static final String groupFileName = "groups.cfg";
    private Hashtable groupHT = new Hashtable();
    private Hashtable userHT = new Hashtable();
    SafeResourceBundle res = new SafeResourceBundle("com.iplanet.im.server.NMSBundle");
    long um;
    long gm;
    private boolean mod = false;

    public PasswordFileRealm() throws RealmException, FileNotFoundException, IOException {
        this.readIn();
    }

    public void stop() {
    }

    public void resync() {
        try {
            this.readIn();
            super.resync();
        }
        catch (Exception e) {
            Log.out.error("[password] Reload password files failed " + e);
        }
    }

    public NMSGroup _getNMSGroup(iIMPrincipal principal, iIMGroup nlg) throws RealmException {
        NMSGroup g = (NMSGroup)this.groupHT.get(nlg.getName().toLowerCase());
        if (g != null) {
            return g;
        }
        throw new RealmException(this.res.getString("group") + nlg.getName() + " " + this.res.getString("does_not_exist"));
    }

    public iIMGroup[] _getiIMGroups() {
        iIMGroup[] ret = new iIMGroup[this.groupHT.size()];
        Enumeration e = this.groupHT.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            NMSGroup g = (NMSGroup)e.nextElement();
            ret[i++] = g.getiIMGroup();
        }
        return ret;
    }

    public iIMGroup[] _getiIMGroups(String searchBase) {
        return this._getiIMGroups();
    }

    public iIMGroup _getiIMGroup(String dn, String domainName) {
        return null;
    }

    public iIMGroup _getiIMGroup(iIMPrincipal principal, String uid) throws RealmException {
        NMSGroup nmsg = (NMSGroup)this.groupHT.get(uid = uid.toLowerCase());
        if (nmsg != null) {
            return nmsg.getiIMGroup();
        }
        throw new RealmException("[password] group not found:" + uid);
    }

    public iIMUser _getiIMUser(iIMPrincipal principal, String uid) throws RealmException {
        return this._getiIMUser(principal.getServer(), uid);
    }

    public iIMUser _getiIMUser(String searchBase, String uid) throws RealmException {
        uid = StringUtility.getLocalPartFromAddress(uid);
        User u = (User)this.userHT.get(uid = uid.toLowerCase());
        if (u != null) {
            return u.u;
        }
        Log.out.info("[password] user not found " + uid);
        throw new RealmException("[password] " + uid + " not found.");
    }

    public iIMUser _auth(String name, String possiblePass) throws RealmException {
        try {
            User u = (User)this.userHT.get(name.toLowerCase());
            if (u == null) {
                throw new RealmException("[password] " + name + " not found.");
            }
            String realPass = u.password;
            if (realPass.equals(possiblePass)) {
                Log.out.debug("[password] authenticated " + name + " using password file");
                return u.u;
            }
            Log.out.info("[password] authentication failed for " + name);
        }
        catch (Exception e) {
            Log.out.error("[password] error while authentication " + name + " : " + e.toString());
        }
        return null;
    }

    private boolean _isMatch(String comp, String start, String end) {
        Log.out.debug("[password] match(" + comp + ", " + start + ", " + end + ")");
        return end == null ? comp.startsWith(start) : comp.startsWith(start) && comp.endsWith(end);
    }

    private Vector _searchUsers(WildCardPattern wcp, iIMUser[] allUsers, boolean byid) {
        Vector<iIMUser> foundUsers = new Vector<iIMUser>();
        int i = 0;
        while (i < allUsers.length) {
            if (wcp.matchIgnoreCase(allUsers[i].getDisplayName())) {
                foundUsers.add(allUsers[i]);
            }
            ++i;
        }
        return foundUsers;
    }

    private Vector _searchGroups(WildCardPattern wcp, iIMGroup[] allGroups, boolean byid) {
        Vector<iIMGroup> foundUsers = new Vector<iIMGroup>();
        int i = 0;
        while (i < allGroups.length) {
            if (wcp.matchIgnoreCase(allGroups[i].getDisplayName())) {
                foundUsers.add(allGroups[i]);
            }
            ++i;
        }
        return foundUsers;
    }

    public UserSearchReply _search(iIMPrincipal principal, String pattern, boolean byid, String filter) {
        return this._search(pattern, byid);
    }

    public UserSearchReply _search(String base, String pattern, boolean byid, String filter) {
        return this._search(pattern, byid);
    }

    public UserSearchReply _search(String filter, String base) {
        return this._search(filter, true);
    }

    private UserSearchReply _search(String pattern, boolean byid) {
        WildCardPattern wcp = new WildCardPattern(pattern);
        Vector v = new Vector();
        iIMUser[] allUsers = this.getUsers();
        Vector newv = this._searchUsers(wcp, allUsers, byid);
        v.addAll(newv);
        iIMGroup[] allGroups = this._getiIMGroups();
        newv = this._searchGroups(wcp, allGroups, byid);
        v.addAll(newv);
        Object[] p = new iIMPrincipal[v.size()];
        v.copyInto(p);
        return new UserSearchReply(2, (iIMPrincipal[])p);
    }

    /*
     * WARNING - void declaration
     */
    private void readIn() throws RealmException, FileNotFoundException, IOException {
        String line;
        if (this.mod) {
            return;
        }
        File uf = new File(NMS.getConfigDir(), userFileName);
        File gf = new File(NMS.getConfigDir(), groupFileName);
        long newum = uf.lastModified();
        long newgm = gf.lastModified();
        if (newum <= this.um && newgm <= this.gm) {
            return;
        }
        this.um = newum;
        this.gm = newgm;
        this.userHT.clear();
        this.groupHT.clear();
        File f = new File(NMS.getConfigDir(), groupFileName);
        BufferedReader d = new BufferedReader(new FileReader(f));
        while ((line = d.readLine()) != null) {
            void var9_7;
            line = var9_7.trim();
            if (line.equals("")) continue;
            StringTokenizer st = new StringTokenizer(line, ":");
            if (!st.hasMoreTokens()) {
                throw new RealmException(this.res.getString("bad_group_format_at") + line);
            }
            String uid = st.nextToken();
            uid = uid.trim();
            int n = uid.indexOf(64);
            if (n != -1) {
                throw new RealmException("@ is not allowed in group uid " + uid);
            }
            if (!st.hasMoreTokens()) {
                throw new RealmException(this.res.getString("bad_group_format_at1") + line);
            }
            String displayname = st.nextToken();
            displayname = displayname.trim();
            iIMGroup g = new iIMGroup(uid, NMS.getName(), displayname);
            NMSGroup nmsg = new NMSGroup(g);
            this.groupHT.put(uid.toLowerCase(), nmsg);
        }
        d.close();
        f = new File(NMS.getConfigDir(), userFileName);
        d = new BufferedReader(new FileReader(f));
        while ((line = d.readLine()) != null) {
            if ((line = line.trim()).equals("")) continue;
            int lineIndex = 0;
            int findIndex = line.indexOf(":", lineIndex);
            if (findIndex == -1) {
                throw new RealmException(this.res.getString("bad_group_format_at2") + line);
            }
            String user = line.substring(lineIndex, findIndex);
            lineIndex = findIndex + 1;
            user = user.trim();
            int n = user.indexOf(64);
            if (n != -1) {
                throw new RealmException("@ is not allowed in user uid " + user);
            }
            findIndex = line.indexOf(":", lineIndex);
            if (findIndex == -1) {
                throw new RealmException(this.res.getString("bad_group_format_at3") + line);
            }
            String pass = line.substring(lineIndex, findIndex);
            lineIndex = findIndex + 1;
            pass = pass.trim();
            findIndex = line.indexOf(":", lineIndex);
            if (findIndex == -1) {
                throw new RealmException(this.res.getString("bad_group_format_at1") + line);
            }
            String displayname = line.substring(lineIndex, findIndex);
            lineIndex = findIndex + 1;
            displayname = displayname.trim();
            String g = line.substring(lineIndex, line.length());
            g = g.trim();
            iIMUser nlu = new iIMUser(user, NMS.getName(), displayname, null);
            StringTokenizer gst = new StringTokenizer(g, ",");
            while (gst.hasMoreElements()) {
                String groupid = gst.nextToken();
                NMSGroup ng = (NMSGroup)this.groupHT.get((groupid = groupid.trim()).toLowerCase());
                if (ng == null) continue;
                ng.addMember((iIMPrincipal)nlu);
            }
            User u = new User();
            u.u = nlu;
            u.password = pass;
            this.userHT.put(user.toLowerCase(), u);
            Log.out.debug("Loaded user from password files: " + displayname + " <" + nlu.getUID() + ">");
        }
    }

    public void saveOut() {
        try {
            File f = new File(NMS.getConfigDir(), groupFileName);
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(f)));
            Enumeration e = this.groupHT.elements();
            while (e.hasMoreElements()) {
                NMSGroup g = (NMSGroup)e.nextElement();
                out.println(g.getiIMGroup().getName() + ":" + g.getiIMGroup().getDisplayName());
            }
            out.close();
            f = new File(NMS.getConfigDir(), userFileName);
            out = new PrintWriter(new BufferedWriter(new FileWriter(f)));
            e = this.userHT.elements();
            while (e.hasMoreElements()) {
                User u = (User)e.nextElement();
                String pass = u.password;
                if (pass.equals("")) {
                    pass = "*";
                }
                String groupsString = "";
                NMSGroup[] g = this.getGroups();
                int i = 0;
                while (i < g.length) {
                    if (g[i].hasMember((iIMPrincipal)u.u)) {
                        if (!groupsString.equals("")) {
                            groupsString = groupsString + ",";
                        }
                        groupsString = groupsString + g[i].getiIMGroup().getName();
                    }
                    ++i;
                }
                out.println(u.u.getName() + ":" + pass + ":" + u.u.getDisplayName() + ":" + groupsString);
            }
            out.close();
        }
        catch (Exception e) {
            Log.out.error(this.res.getString("unable_to_save") + e.toString());
        }
    }

    public NMSGroup addGroup(String uid, String displayname) throws RealmException {
        this.mod = true;
        iIMGroup g = new iIMGroup(uid, NMS.getName(), displayname);
        NMSGroup nmsg = new NMSGroup(g);
        this.groupHT.put(uid.toLowerCase(), nmsg);
        return nmsg;
    }

    public iIMUser addUser(String uid, String displayname) throws RealmException {
        this.mod = true;
        iIMUser nlu = new iIMUser(uid, NMS.getName(), displayname);
        User u = new User();
        u.u = nlu;
        this.userHT.put(uid.toLowerCase(), u);
        return nlu;
    }

    public void deleteGroup(String uid) throws RealmException {
        this.mod = true;
        this.groupHT.remove(uid.toLowerCase());
    }

    public void deleteUser(String uid) throws RealmException {
        this.mod = true;
        NMSGroup[] ga = this.getGroups();
        int i = 0;
        while (i < ga.length) {
            ga[i].removeMember(uid);
            ++i;
        }
    }

    public NMSGroup[] getGroups() throws RealmException {
        iIMGroup[] nlga = this._getiIMGroups();
        NMSGroup[] nmsga = new NMSGroup[nlga.length];
        int i = 0;
        while (i < nlga.length) {
            nmsga[i] = this.getGroup(null, nlga[i].getName());
            ++i;
        }
        return nmsga;
    }

    public iIMUser[] getUsers() {
        iIMUser[] ua = new iIMUser[this.userHT.size()];
        Enumeration e = this.userHT.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            User u = (User)e.nextElement();
            ua[i] = u.u;
            ++i;
        }
        return ua;
    }

    public void setPassword(iIMUser nlu, String password) {
        this.mod = true;
        User u = (User)this.userHT.get(nlu.getName().toLowerCase());
        if (u != null) {
            u.password = password;
        }
    }

    public String getPassword(iIMUser nlu) {
        User u = (User)this.userHT.get(nlu.getName().toLowerCase());
        if (u != null) {
            return u.password;
        }
        return "";
    }

    public String getSearchBase(iIMPrincipal u) throws RealmException {
        return "";
    }

    class User {
        iIMUser u;
        String password;

        User() {
        }
    }
}

