/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.net.CommandData;
import com.iplanet.im.net.CommandToNet;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.NMSSocket;
import com.iplanet.im.server.NMSSocketCallback;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.InetAddress;
import java.net.Socket;

public class NMSPlainSocket
implements NMSSocket,
Runnable {
    private NMSSocketCallback callback;
    private Socket socket;
    private DataInputStream is;
    private DataOutputStream os;
    private InetAddress addr;
    private CommandToNet c2n = new CommandToNet();

    public NMSPlainSocket(Socket s) {
        this.socket = s;
        this.addr = s.getInetAddress();
        try {
            this.is = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
            this.os = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
            Thread t = new Thread(this);
            t.start();
        }
        catch (Exception e) {
            Log.out.error("Cannot open plainsocket streams");
        }
    }

    public void close() {
        if (this.socket == null) {
            return;
        }
        Socket tempSocket = this.socket;
        this.socket = null;
        try {
            tempSocket.close();
            this.os.close();
            this.is.close();
        }
        catch (Exception e) {
            Log.out.printStackTrace(e);
        }
        this.os = null;
        this.is = null;
        this.callback.onClose();
    }

    public void setCallback(NMSSocketCallback i) {
        this.callback = i;
    }

    public void run() {
        while (true) {
            CommandData nc = null;
            nc = this.readCommand();
            if (nc == null) {
                return;
            }
            this.callback.onCommand(nc);
        }
    }

    private CommandData readCommand() {
        if (this.is == null) {
            return null;
        }
        try {
            return this.c2n.readCommand(this.is);
        }
        catch (Exception e) {
            Log.out.debug("Plainsocket " + this.addr.toString() + ": error during read: " + e.toString());
            Log.out.printStackTrace(e);
            this.close();
            return null;
        }
    }

    public synchronized boolean sendCommand(CommandData cd) {
        try {
            this.c2n.sendCommand(this.os, cd);
            return true;
        }
        catch (Exception e) {
            Log.out.debug("PlainSocket " + this.addr.toString() + ": error during write: " + e.toString());
            Log.out.printStackTrace(e);
            this.close();
            return false;
        }
    }
}

