/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.net.CommandData;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.MultiplexSocketManager;
import com.iplanet.im.server.NMSSocket;
import com.iplanet.im.server.NMSSocketCallback;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.util.Vector;

public class NMSMultiSocket
implements NMSSocket {
    MultiplexSocketManager msMgr;
    Integer id;
    String ip;
    NMSSocketCallback callback;
    private byte[] cmdbuff = new byte[4096];
    private int[] header = new int[4];
    private ByteArrayInputStream bais = new ByteArrayInputStream(this.cmdbuff);
    int cmdlen;
    int readin;
    int state;
    private Vector buffers = new Vector(4);

    public NMSMultiSocket(MultiplexSocketManager msMgr, Integer id, String ip) {
        this.id = id;
        this.msMgr = msMgr;
        this.ip = ip;
    }

    public boolean sendCommand(CommandData cd) {
        if (!this.msMgr.sendCommand(this.id, cd)) {
            this.close();
            return false;
        }
        return true;
    }

    public void addBuffer(byte[] b, int len) {
        this.buffers.add(new Buffer(b, len));
    }

    public void close() {
        this.callback = null;
        this.msMgr.close(this.id);
    }

    public void setCallback(NMSSocketCallback i) {
        this.callback = i;
    }

    public void onClose() {
        NMSSocketCallback cb = this.callback;
        if (cb != null) {
            this.callback = null;
            this.onData();
            cb.onClose();
        }
    }

    public synchronized void onData() {
        while (!this.buffers.isEmpty()) {
            Buffer b = (Buffer)this.buffers.remove(0);
            this.onData(b.b, b.len);
        }
    }

    public void onData(byte[] b, int len) {
        int offset = 0;
        while (offset < len) {
            switch (this.state) {
                case 0: {
                    this.header[this.readin] = b[offset] & 0xFF;
                    ++this.readin;
                    ++offset;
                    if (this.readin != 4) break;
                    this.cmdlen = (this.header[0] << 24) + (this.header[1] << 16) + (this.header[2] << 8) + this.header[3];
                    if (this.cmdlen > this.cmdbuff.length) {
                        this.cmdbuff = new byte[this.cmdlen];
                        this.bais = new ByteArrayInputStream(this.cmdbuff);
                    }
                    this.state = 1;
                    this.readin = 0;
                    break;
                }
                case 1: {
                    int maxcopy = Math.min(this.cmdlen - this.readin, len - offset);
                    try {
                        System.arraycopy(b, offset, this.cmdbuff, this.readin, maxcopy);
                    }
                    catch (Exception e) {
                        Log.out.error("arraycopy Error " + e.toString() + " ip=" + this.ip + " offset=" + offset + " readin=" + this.readin + " cmdlen=" + this.cmdlen + " len=" + len + " maxcopy=" + maxcopy);
                        e.printStackTrace();
                        this.close();
                        return;
                    }
                    this.readin += maxcopy;
                    offset += maxcopy;
                    if (this.readin != this.cmdlen) break;
                    try {
                        ObjectInputStream obis = new ObjectInputStream(this.bais);
                        Object o = obis.readObject();
                        obis.close();
                        this.bais.reset();
                        obis = null;
                        this.callback.onCommand((CommandData)o);
                    }
                    catch (Exception e) {
                        Log.out.error("Error parsing multiplex command " + e);
                    }
                    this.state = 0;
                    this.readin = 0;
                }
            }
        }
    }

    class Buffer {
        byte[] b;
        int len;

        Buffer(byte[] b, int len) {
            this.b = b;
            this.len = len;
        }
    }
}

