/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.net.UserSearchReply;
import com.iplanet.im.net.iIMGroup;
import com.iplanet.im.net.iIMPrincipal;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.Realm;
import com.iplanet.im.server.RealmException;
import com.iplanet.im.util.StringUtility;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class NMSGroup
implements Serializable {
    static final long serialVersionUID = -3443525777748932085L;
    private iIMGroup nlg;
    private Realm realm;
    private String[] users = new String[0];
    private iIMPrincipal[] principals = new iIMPrincipal[0];
    private Hashtable userHT = new Hashtable();
    private boolean updateArray = false;

    public NMSGroup(iIMGroup nlg) {
        this.nlg = nlg;
        this.realm = NMS.getRealm();
    }

    public NMSGroup(iIMGroup nlg, Realm realm) {
        this.nlg = nlg;
        this.realm = realm;
    }

    private void updateRetArray() {
        this.principals = new iIMPrincipal[this.userHT.size()];
        Enumeration e = this.userHT.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            this.principals[i++] = (iIMPrincipal)e.nextElement();
        }
        this.updateArray = false;
    }

    public synchronized boolean hasMember(iIMPrincipal p) throws RealmException {
        Log.out.debug("searching for " + p.getUID() + " in " + this.nlg.getUID());
        if (this.nlg.isDynamic()) {
            String uid = StringUtility.getLocalPartFromAddress(p.getUID());
            UserSearchReply reply = this.realm._search(this.nlg.getScope(), uid, true, this.nlg.getFilter());
            return reply.getPrincipals().length > 0;
        }
        return this.userHT.containsKey(p.getUID().toLowerCase());
    }

    public synchronized iIMPrincipal[] getMembers() throws RealmException {
        if (this.nlg.isDynamic()) {
            Log.out.debug("searching members for " + this.nlg.getUID());
            UserSearchReply reply = this.realm._search(this.nlg.getFilter(), this.nlg.getScope());
            return reply.getPrincipals();
        }
        Log.out.debug("getting members for " + this.nlg.getUID());
        if (this.updateArray) {
            this.updateRetArray();
        }
        return this.principals;
    }

    public synchronized void addMember(iIMPrincipal p) {
        try {
            String uid = p.getUID().toLowerCase();
            if (this.hasMember(p)) {
                return;
            }
            this.userHT.put(uid, p);
            this.updateArray = true;
            Log.out.debug("NMSGroup: added " + uid + " to " + this.nlg.getUID());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void removeMember(String uid) {
        this.userHT.remove(uid.toLowerCase());
        this.updateArray = true;
    }

    public iIMGroup getiIMGroup() {
        return this.nlg;
    }

    public String toString() {
        return this.nlg.toString();
    }
}

